/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.tool;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.DemultiplexingListener;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.tool.FeatureChangeListener;
import org.eclipse.sirius.viewpoint.description.tool.ToolFilterDescription;

public class ToolFilterDescriptionListener
extends DemultiplexingListener {
    private ToolFilterDescription filter;
    private boolean shoudUpdate;
    private Runnable updateRunnable;

    public ToolFilterDescriptionListener(ToolFilterDescription filter, DRepresentation representation) {
        super(ToolFilterDescriptionListener.getFilter(representation, filter));
        this.filter = filter;
    }

    public void setUpdateRunnable(Runnable runnable) {
        this.updateRunnable = runnable;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        this.shoudUpdate = false;
        super.resourceSetChanged(event);
        if (this.shoudUpdate) {
            this.updateRunnable.run();
        }
    }

    protected void handleNotification(TransactionalEditingDomain domain, Notification notification) {
        if (notification.getNotifier() instanceof EObject) {
            EObject notifier = (EObject)notification.getNotifier();
            EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
            ModelAccessor accessor = this.getModelAccessor(domain);
            for (FeatureChangeListener listener : this.filter.getListeners()) {
                if (!accessor.eInstanceOf(notifier, listener.getDomainClass()) || !feature.getName().equals(listener.getFeatureName())) continue;
                this.shoudUpdate = true;
            }
        }
    }

    private ModelAccessor getModelAccessor(TransactionalEditingDomain domain) {
        return SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(domain.getResourceSet());
    }

    private static NotificationFilter getFilter(DRepresentation representation, ToolFilterDescription filter) {
        Collection<EObject> elementsToListen = ToolFilterDescriptionListener.elementsToListen(representation, filter.getElementsToListen());
        NotificationFilter notificationFilter = NotificationFilter.NOT_TOUCH;
        for (EObject eObject : elementsToListen) {
            notificationFilter = notificationFilter.and(NotificationFilter.createNotifierFilter((Object)eObject));
        }
        return notificationFilter;
    }

    private static Collection<EObject> elementsToListen(DRepresentation representation, String elementsToListen) {
        IInterpreter interpreter = InterpreterUtil.getInterpreter(representation);
        Collection<Object> semanticCandidates = Collections.emptySet();
        try {
            if (interpreter != null && !StringUtil.isEmpty((String)elementsToListen)) {
                semanticCandidates = interpreter.evaluateCollection((EObject)representation, elementsToListen);
            }
        }
        catch (EvaluationException evaluationException) {}
        return semanticCandidates;
    }
}

