/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.session.danalysis;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSelector;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSelectorProvider;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public final class DAnalysisSelectorService {
    public static final String ID = "org.eclipse.sirius.analysisSelectorProvider";
    public static final String CLASS_ATTRIBUTE = "providerClass";
    private static final String DEFAULT_PROVIDER_ID = "org.eclipse.sirius.analysisSelectorProvider.default";
    private static DAnalysisSelectorProvider defaultSiriusProvider;
    private static List<DAnalysisSelectorProvider> customerProviders;

    private DAnalysisSelectorService() {
    }

    public static DAnalysisSelector getSelector(DAnalysisSession session) {
        for (DAnalysisSelectorProvider provider : DAnalysisSelectorService.getCustomerProviders()) {
            if (!provider.provides(session)) continue;
            return provider.getSelector(session);
        }
        return DAnalysisSelectorService.getDefaultProvider().getSelector(session);
    }

    private static DAnalysisSelectorProvider getDefaultProvider() {
        if (defaultSiriusProvider == null) {
            DAnalysisSelectorService.initializeProviders();
        }
        return defaultSiriusProvider;
    }

    private static List<DAnalysisSelectorProvider> getCustomerProviders() {
        if (customerProviders == null) {
            DAnalysisSelectorService.initializeProviders();
        }
        return customerProviders;
    }

    private static void initializeProviders() {
        Map providers = EclipseUtil.getExtensionPluginsByKey(DAnalysisSelectorProvider.class, (String)ID, (String)CLASS_ATTRIBUTE, (String)"id");
        Collection defaults = (Collection)providers.get(DEFAULT_PROVIDER_ID);
        if (defaults.isEmpty()) {
            SiriusPlugin.getDefault().error(String.format("No default analysis selector provider found at extension point \"%s\".", ID), null);
        } else if (defaultSiriusProvider == null) {
            defaultSiriusProvider = (DAnalysisSelectorProvider)defaults.iterator().next();
        }
        if (defaults.size() > 1) {
            SiriusPlugin.getDefault().error(String.format("Multiple default analysis selector providers found at extension point \"%s\": took only the first found.", ID), null);
        }
        customerProviders = Lists.newArrayList();
        for (Map.Entry entry : providers.entrySet()) {
            if (DEFAULT_PROVIDER_ID.equals(entry.getKey())) continue;
            customerProviders.addAll((Collection)entry.getValue());
        }
    }
}

