/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.helper.task;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.internal.helper.task.ExecuteToolOperationTask;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;

public class TaskHelper {
    private ModelAccessor modelAccessor;
    private UICallBack uiCallback;

    public TaskHelper(ModelAccessor modelAccessor, UICallBack uiCallback) {
        this.modelAccessor = modelAccessor;
        this.uiCallback = uiCallback;
    }

    public ICommandTask buildTaskFromModelOperation(DRepresentation representation, EObject target, ModelOperation op) {
        ExecuteToolOperationTask task = new ExecuteToolOperationTask(this.modelAccessor, target, representation, op, this.uiCallback);
        return task;
    }

    public Set<DSemanticDecorator> getDElementToClearFromSemanticElements(EObject root, Set<EObject> semanticElements) {
        HashSet<DSemanticDecorator> decoratorsToDestroy = new HashSet<DSemanticDecorator>();
        if (!semanticElements.isEmpty()) {
            TreeIterator it = root.eAllContents();
            while (it.hasNext()) {
                DSemanticDecorator decorator;
                EObject eObj = (EObject)it.next();
                if (eObj instanceof DRepresentationElement) {
                    DRepresentationElement representationElement = (DRepresentationElement)eObj;
                    if (representationElement.getSemanticElements().isEmpty()) {
                        if (!semanticElements.contains(representationElement.getTarget())) continue;
                        decoratorsToDestroy.add(representationElement);
                        continue;
                    }
                    if (!semanticElements.containsAll((Collection<?>)representationElement.getSemanticElements())) continue;
                    decoratorsToDestroy.add(representationElement);
                    continue;
                }
                if (!(eObj instanceof DSemanticDecorator) || !semanticElements.contains((decorator = (DSemanticDecorator)eObj).getTarget())) continue;
                decoratorsToDestroy.add(decorator);
            }
        }
        return decoratorsToDestroy;
    }

    public boolean checkPrecondition(EObject container, AbstractToolDescription toolDescription) {
        boolean result = true;
        if (toolDescription.getPrecondition() != null && !StringUtil.isEmpty((String)toolDescription.getPrecondition().trim())) {
            IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(container);
            interpreter.setVariable("container", (Object)container);
            try {
                result = false;
                result = interpreter.evaluateBoolean(container, toolDescription.getPrecondition());
            }
            catch (EvaluationException evaluationException) {}
            interpreter.unSetVariable("container");
        }
        return result;
    }
}

