/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.dialect.command;

import java.util.Collection;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class MoveRepresentationCommand
extends RecordingCommand {
    private Collection<DRepresentation> representations;
    private Session session;
    private DAnalysis targetAnalysis;

    public MoveRepresentationCommand(Session session, DAnalysis targetAnalysis, Collection<DRepresentation> movableRepresentations) {
        super(session.getTransactionalEditingDomain(), "Move representation to " + targetAnalysis.eResource().getURI().toString());
        this.representations = movableRepresentations;
        this.targetAnalysis = targetAnalysis;
        this.session = session;
    }

    protected void doExecute() {
        if (this.representations == null || this.representations.isEmpty() || this.targetAnalysis == null || this.session == null) {
            return;
        }
        for (DRepresentation representation : this.representations) {
            ((DAnalysisSession)this.session).moveRepresentation(this.targetAnalysis, representation);
        }
    }
}

