/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.dialect.command;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationCreationDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class CreateRepresentationCommand
extends RecordingCommand {
    private RepresentationDescription description;
    private Session session;
    private EObject semantic;
    private String name;
    private DRepresentation representation;
    private boolean isInitialOperation;
    private RepresentationCreationDescription creationDescription;
    private IProgressMonitor monitor;

    public CreateRepresentationCommand(Session session, RepresentationDescription description, EObject eObject, String name, IProgressMonitor monitor) {
        super(session.getTransactionalEditingDomain(), "Create representation");
        this.session = session;
        this.description = description;
        this.semantic = eObject;
        this.name = name;
        this.monitor = monitor;
    }

    public void setInitialOperation(RepresentationCreationDescription creationDesc) {
        this.creationDescription = creationDesc;
        this.isInitialOperation = creationDesc.getInitialOperation() != null && creationDesc.getInitialOperation().getFirstModelOperations() != null;
    }

    public boolean canExecute() {
        if (this.isInitialOperation) {
            return super.canExecute();
        }
        EObject root = CreateRepresentationCommand.computeRepresentationRoot(this.session.getInterpreter(), this.creationDescription, this.semantic);
        return DialectManager.INSTANCE.canCreate(root, this.description);
    }

    protected void doExecute() {
        EObject root = CreateRepresentationCommand.computeRepresentationRoot(this.session.getInterpreter(), this.creationDescription, this.semantic);
        this.representation = DialectManager.INSTANCE.createRepresentation(this.name, root, this.description, this.session, this.monitor);
        if (this.representation != null) {
            this.representation.setName(this.name);
        }
    }

    public Collection<?> getResult() {
        HashSet result = Sets.newHashSet();
        result.add(this.representation);
        this.clearData();
        return result;
    }

    public DRepresentation getCreatedRepresentation() {
        return (DRepresentation)this.getResult().iterator().next();
    }

    public void dispose() {
        super.dispose();
        this.clearData();
    }

    private void clearData() {
        this.representation = null;
        this.session = null;
        this.description = null;
        this.semantic = null;
        this.name = null;
        this.creationDescription = null;
    }

    private static EObject computeRepresentationRoot(IInterpreter interpreter, RepresentationCreationDescription desc, EObject initialRoot) {
        EObject newRepresentationRoot = initialRoot;
        if (desc != null && !StringUtil.isEmpty((String)desc.getBrowseExpression())) {
            try {
                newRepresentationRoot = interpreter.evaluateEObject(newRepresentationRoot, desc.getBrowseExpression());
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.warning(newRepresentationRoot, (EStructuralFeature)ToolPackage.eINSTANCE.getRepresentationCreationDescription_BrowseExpression(), e);
            }
            if (newRepresentationRoot == null) {
                RuntimeLoggerManager.INSTANCE.warning(initialRoot, (EStructuralFeature)ToolPackage.eINSTANCE.getRepresentationCreationDescription_BrowseExpression(), "Browse expression " + desc.getBrowseExpression() + " evaluated to null.");
            }
        }
        return newRepresentationRoot;
    }
}

