/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.dialect.command;

import java.util.Collection;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class CopyRepresentationCommand
extends RecordingCommand {
    private Collection<DRepresentation> representations;
    private Session session;
    private String newName;

    public CopyRepresentationCommand(TransactionalEditingDomain domain, Collection<DRepresentation> representations, String newName, Session session) {
        super(domain, "Copy representations");
        this.representations = representations;
        this.newName = newName;
        this.session = session;
    }

    protected void doExecute() {
        if (this.representations == null || this.session == null) {
            return;
        }
        for (DRepresentation representation : this.representations) {
            DialectManager.INSTANCE.copyRepresentation(representation, this.getName(representation), this.session, null);
        }
    }

    private String getName(DRepresentation representation) {
        if (this.representations.size() == 1) {
            return this.newName;
        }
        return String.valueOf(this.newName) + " " + representation.getName();
    }
}

