/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.ocl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCacheAdder;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IQueryContext;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.ocl.CDOAdditionalOperation;
import org.eclipse.emf.cdo.server.ocl.CDOEnvironment;
import org.eclipse.emf.cdo.server.ocl.CDOEnvironmentFactory;
import org.eclipse.emf.cdo.server.ocl.CDOExtentCreator;
import org.eclipse.emf.cdo.server.ocl.CDOExtentMap;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetDataRevisionProvider;
import org.eclipse.emf.cdo.spi.server.QueryHandlerFactory;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.ecore.BooleanLiteralExp;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.EnumLiteralExp;
import org.eclipse.ocl.ecore.IntegerLiteralExp;
import org.eclipse.ocl.ecore.RealLiteralExp;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.helper.OCLHelper;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.ProblemAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLQueryHandler
implements IQueryHandler {
    public static final String LANGUAGE_NAME = "ocl";
    public static final String LAZY_EXTENTS_PARAMETER = "cdoLazyExtents";
    public static final String IMPLICIT_ROOT_CLASS_PARAMETER = "cdoImplicitRootClass";
    private static final Set<String> SERVER_QUERY_PARAMETERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("cdoLazyExtents", "cdoImplicitRootClass")));
    private static final EcoreFactory FACTORY = EcoreFactory.eINSTANCE;
    private boolean lazyExtents = true;
    private EClass implicitRootClass;

    public void executeQuery(CDOQueryInfo info, IQueryContext context) {
        block10: {
            CDOExtentMap extentMap = null;
            try {
                try {
                    this.readParameters(info.getParameters());
                    IView revisionProvider = context.getView();
                    CDOChangeSetData changeSetData = info.getChangeSetData();
                    if (changeSetData != null) {
                        revisionProvider = new CDOChangeSetDataRevisionProvider((CDORevisionProvider)revisionProvider, changeSetData);
                    }
                    CDOView view = CDOServerUtil.openView((ISession)context.getView().getSession(), (CDOBranchPoint)context, (CDORevisionProvider)revisionProvider);
                    extentMap = this.createExtentMap(view, changeSetData, context);
                    OCL<?, EClassifier, ?, ?, ?, ?, ?, ?, ?, Constraint, EClass, EObject> ocl = this.createOCL(view, extentMap);
                    ContextParameter contextParameter = this.getContextParameter(info, view);
                    Query<EClassifier, EClass, EObject> query = this.createQuery(view, info, contextParameter, ocl);
                    Object result = this.evaluate(query, contextParameter.getObject());
                    if (result == ocl.getEnvironment().getOCLStandardLibrary().getInvalid()) {
                        throw new Exception("OCL query evaluated to 'invalid'. Run with '-Dorg.eclipse.ocl.debug=true' and visit the log for failure details.");
                    }
                    if (result instanceof Collection) {
                        for (Object element : (Collection)result) {
                            if (this.addResult(element, context, view)) continue;
                            break block10;
                        }
                        break block10;
                    }
                    this.addResult(result, context, view);
                }
                catch (Exception ex) {
                    throw WrappedException.wrap((Exception)ex, (String)("Problem executing OCL query: " + info.getQueryString()));
                }
            }
            finally {
                if (extentMap != null) {
                    extentMap.cancel();
                }
            }
        }
    }

    protected boolean addResult(Object result, IQueryContext context, CDOView view) {
        if (result instanceof EObject) {
            CDORevision revision = this.getRevision((EObject)result, view);
            return context.addResult((Object)revision);
        }
        return context.addResult(result);
    }

    protected CDORevision getRevision(EObject object, CDOView view) {
        return FSMUtil.adapt((Object)object, (CDOView)view).cdoRevision();
    }

    protected Object evaluate(Query<EClassifier, EClass, EObject> query, EObject object) {
        if (object == null) {
            return query.evaluate();
        }
        return query.evaluate((Object)object);
    }

    protected CDOExtentMap createExtentMap(CDOView view, CDOChangeSetData changeSetData, IQueryContext context) {
        CDOExtentCreator creator = this.createsLazyExtents() ? new CDOExtentCreator.Lazy(view) : new CDOExtentCreator(view);
        creator.setChangeSetData(changeSetData);
        creator.setRevisionCacheAdder((CDORevisionCacheAdder)context.getView().getRepository().getRevisionManager());
        return new CDOExtentMap(creator);
    }

    protected boolean createsLazyExtents() {
        return this.lazyExtents;
    }

    protected OCL<?, EClassifier, ?, ?, ?, ?, ?, ?, ?, Constraint, EClass, EObject> createOCL(CDOView view, CDOExtentMap extentMap) {
        CDOEnvironmentFactory envFactory = new CDOEnvironmentFactory((EPackage.Registry)view.getSession().getPackageRegistry());
        OCL ocl = OCL.newInstance((EnvironmentFactory)envFactory);
        CDOAdditionalOperation.registerOperations((CDOEnvironment)ocl.getEnvironment());
        ocl.setExtentMap((Map)extentMap);
        return ocl;
    }

    protected Query<EClassifier, EClass, EObject> createQuery(CDOView view, CDOQueryInfo info, ContextParameter contextParameter, OCL<?, EClassifier, ?, ?, ?, ?, ?, ?, ?, Constraint, EClass, EObject> ocl) throws ParserException, DiagnosticException {
        ProblemAware problemAware;
        Diagnostic problems;
        HashMap<String, Object> parameters = new HashMap<String, Object>(info.getParameters());
        this.initEnvironment(ocl.getEnvironment(), view.getSession().getPackageRegistry(), parameters);
        OCLHelper helper = ocl.createOCLHelper();
        helper.setContext((Object)contextParameter.getClassifier());
        OCLExpression expr = helper.createQuery(info.getQueryString());
        Query query = ocl.createQuery(expr);
        if (query instanceof ProblemAware && (problems = (problemAware = (ProblemAware)query).getProblems()) != null) {
            throw new DiagnosticException(problems);
        }
        this.setOCLQueryParameters(parameters, (Query<EClassifier, EClass, EObject>)query);
        return query;
    }

    @Deprecated
    protected EClassifier getArbitraryContextClassifier(CDOPackageRegistry packageRegistry) {
        return ContextParameter.getArbitraryContextClassifier(packageRegistry);
    }

    protected void initEnvironment(Environment<?, EClassifier, ?, ?, ?, ?, ?, ?, ?, Constraint, EClass, EObject> environment, CDOPackageRegistry packageRegistry, Map<String, Object> parameters) {
        EClass implicitRootClass = this.getImplicitRootClass();
        if (implicitRootClass != null) {
            ParsingOptions.setOption(environment, (Option)ParsingOptions.implicitRootClass(environment), (Object)implicitRootClass);
        }
        OCLStandardLibrary stdLib = environment.getOCLStandardLibrary();
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            String name = parameter.getKey();
            if (!this.isOCLQueryParameter(name)) continue;
            Object value = parameter.getValue();
            OCLExpression<EClassifier> initExpression = this.createInitExpression((OCLStandardLibrary<EClassifier>)stdLib, packageRegistry, value);
            Variable variable = FACTORY.createVariable();
            variable.setName(name);
            variable.setType((Object)((EClassifier)initExpression.getType()));
            variable.setInitExpression(initExpression);
            this.addEnvironmentVariable(environment, (org.eclipse.ocl.expressions.Variable<EClassifier, ?>)variable);
        }
    }

    protected EClass getImplicitRootClass() {
        return this.implicitRootClass;
    }

    protected OCLExpression<EClassifier> createInitExpression(OCLStandardLibrary<EClassifier> stdLib, CDOPackageRegistry packageRegistry, Object value) {
        if (value instanceof String) {
            String v = (String)value;
            StringLiteralExp literal = FACTORY.createStringLiteralExp();
            literal.setType((Object)((EClassifier)stdLib.getString()));
            literal.setStringSymbol(v);
            return literal;
        }
        if (value instanceof Boolean) {
            Boolean v = (Boolean)value;
            BooleanLiteralExp literal = FACTORY.createBooleanLiteralExp();
            literal.setType((Object)((EClassifier)stdLib.getBoolean()));
            literal.setBooleanSymbol(v);
            return literal;
        }
        Integer integerValue = this.getInteger(value);
        if (integerValue != null) {
            IntegerLiteralExp literal = FACTORY.createIntegerLiteralExp();
            literal.setType((Object)((EClassifier)stdLib.getInteger()));
            literal.setIntegerSymbol(integerValue);
            return literal;
        }
        Double doubleValue = this.getDouble(value);
        if (doubleValue != null) {
            RealLiteralExp literal = FACTORY.createRealLiteralExp();
            literal.setType((Object)((EClassifier)stdLib.getReal()));
            literal.setRealSymbol(doubleValue);
            return literal;
        }
        if (value instanceof Enumerator) {
            Enumerator v = (Enumerator)value;
            String name = v.getName();
            EEnumLiteral eEnumLiteral = packageRegistry.getEnumLiteralFor(v);
            if (eEnumLiteral == null) {
                throw new IllegalArgumentException("Enum literal not found: " + name);
            }
            EnumLiteralExp literal = FACTORY.createEnumLiteralExp();
            literal.setType((Object)eEnumLiteral.getEEnum());
            literal.setReferredEnumLiteral((Object)eEnumLiteral);
            return literal;
        }
        throw new IllegalArgumentException("Unrecognized parameter type: " + value.getClass().getName());
    }

    protected void addEnvironmentVariable(Environment<?, EClassifier, ?, ?, ?, ?, ?, ?, ?, Constraint, EClass, EObject> environment, org.eclipse.ocl.expressions.Variable<EClassifier, ?> variable) {
        environment.addElement(variable.getName(), variable, true);
    }

    protected ContextParameter getContextParameter(CDOQueryInfo info, CDOView view) {
        return new ContextParameter(view, info);
    }

    protected void readParameters(Map<String, ?> queryParameters) {
        this.lazyExtents = this.readParameter(queryParameters, LAZY_EXTENTS_PARAMETER, this.lazyExtents);
        this.implicitRootClass = this.readParameter(queryParameters, IMPLICIT_ROOT_CLASS_PARAMETER, EClass.class, this.implicitRootClass);
    }

    protected boolean readParameter(Map<String, ?> queryParameters, String name, boolean defaultValue) {
        return this.readParameter(queryParameters, name, Boolean.class, defaultValue);
    }

    protected <T> T readParameter(Map<String, ?> queryParameters, String name, Class<T> type, T defaultValue) {
        T result = defaultValue;
        Object o = queryParameters.get(name);
        if (o != null) {
            try {
                result = type.cast(o);
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException("Parameter " + name + " must be a " + type.getSimpleName() + " but it is a " + o + " class " + o.getClass().getName(), ex);
            }
        }
        return result;
    }

    protected void setOCLQueryParameters(Map<String, Object> parameters, Query<EClassifier, EClass, EObject> query) {
        EvaluationEnvironment evalEnv = query.getEvaluationEnvironment();
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            String key = parameter.getKey();
            if (!this.isOCLQueryParameter(key)) continue;
            Object value = parameter.getValue();
            evalEnv.add(key, value);
        }
    }

    protected boolean isOCLQueryParameter(String name) {
        return !SERVER_QUERY_PARAMETERS.contains(name);
    }

    private Integer getInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Short) {
            return (int)((Short)value);
        }
        if (value instanceof Byte) {
            return (int)((Byte)value);
        }
        return null;
    }

    private Double getDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        return null;
    }

    public static void prepareContainer(IManagedContainer container) {
        container.registerFactory((IFactory)new Factory());
    }

    protected static final class ContextParameter {
        private final EClassifier classifier;
        private final EObject object;

        public ContextParameter(CDOView view, CDOQueryInfo info) {
            Object contextParameter = info.getContext();
            if (contextParameter instanceof CDOID) {
                CDOID id = (CDOID)contextParameter;
                if (id.isNull()) {
                    CDOPackageRegistry packageRegistry = view.getSession().getPackageRegistry();
                    this.classifier = ContextParameter.getArbitraryContextClassifier(packageRegistry);
                    this.object = null;
                } else {
                    InternalCDOObject cdoObject = (InternalCDOObject)view.getObject(id);
                    this.classifier = cdoObject.eClass();
                    this.object = cdoObject.cdoInternalInstance();
                }
            } else if (contextParameter instanceof EClassifier) {
                this.classifier = (EClassifier)contextParameter;
                this.object = null;
            } else {
                CDOPackageRegistry packageRegistry = view.getSession().getPackageRegistry();
                this.classifier = ContextParameter.getArbitraryContextClassifier(packageRegistry);
                this.object = null;
            }
        }

        public ContextParameter(EClassifier classifier, EObject object) {
            this.classifier = classifier;
            this.object = object;
        }

        public EClassifier getClassifier() {
            return this.classifier;
        }

        public EObject getObject() {
            return this.object;
        }

        protected static EClassifier getArbitraryContextClassifier(CDOPackageRegistry packageRegistry) {
            CDOPackageUnit[] cDOPackageUnitArray = packageRegistry.getPackageUnits();
            int n = cDOPackageUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOPackageUnit packageUnit = cDOPackageUnitArray[n2];
                CDOPackageInfo[] cDOPackageInfoArray = packageUnit.getPackageInfos();
                int n3 = cDOPackageInfoArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Iterator iterator;
                    CDOPackageInfo packageInfo = cDOPackageInfoArray[n4];
                    if (!packageUnit.isSystem() && (iterator = packageInfo.getEPackage().getEClassifiers().iterator()).hasNext()) {
                        EClassifier classifier = (EClassifier)iterator.next();
                        return classifier;
                    }
                    ++n4;
                }
                ++n2;
            }
            throw new IllegalStateException("Context missing");
        }
    }

    public static class Factory
    extends QueryHandlerFactory {
        public Factory() {
            super(OCLQueryHandler.LANGUAGE_NAME);
        }

        public OCLQueryHandler create(String description) throws ProductCreationException {
            return new OCLQueryHandler();
        }
    }
}

