/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.kdm.uml2converter.popup.actions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogHandler;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.kdm.uml2converter.KdmToUml2Activator;
import org.eclipse.gmt.modisco.kdm.uml2converter.Messages;
import org.eclipse.gmt.modisco.kdm.uml2converter.impl.KdmtoUmlConverterImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ConvertWithCustomTransformation
implements IObjectActionDelegate {
    private final Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private IFile kdmFile;
    private Shell shell;
    private IWorkbenchPart workbench;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        this.workbench = targetPart;
    }

    public void run(IAction action) {
        final IPath kdmModelPath = this.kdmFile.getFullPath();
        final IPath umlModelPath = this.kdmFile.getFullPath().removeFileExtension().addFileExtension("uml");
        String customTransformation = "";
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.shell, (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator(null);
        dialog.setAllowMultiple(false);
        dialog.setTitle(Messages.ConvertWithCustomTransformation_2);
        dialog.setMessage(Messages.ConvertWithCustomTransformation_3);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    return ((IFile)element).getFileExtension().equals("asm");
                }
                return true;
            }
        });
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            if (elements.length == 1) {
                customTransformation = ((IResource)elements[0]).getLocation().toString();
            }
        } else {
            return;
        }
        try {
            final URL customTransformationUrl = new URL("file:///" + customTransformation);
            Job job = new Job(String.valueOf(Messages.ConvertWithCustomTransformation_6) + umlModelPath.lastSegment()){

                protected IStatus run(IProgressMonitor monitor) {
                    IPath umlModelFilePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(umlModelPath);
                    MoDiscoLogHandler logHandler = new MoDiscoLogHandler(String.valueOf(umlModelFilePath.toString()) + ".log");
                    ConvertWithCustomTransformation.this.logger.addHandler((Handler)logHandler);
                    try {
                        KdmtoUmlConverterImpl transfo = new KdmtoUmlConverterImpl();
                        URI outputURI = URI.createPlatformResourceURI((String)umlModelPath.toString(), (boolean)true);
                        transfo.getUML2ModelFromKDMModelWithCustomTransformation(URI.createPlatformResourceURI((String)kdmModelPath.toString(), (boolean)true), false, customTransformationUrl, outputURI);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    catch (Exception e) {
                        MoDiscoLogger.logError((Throwable)e, (Plugin)KdmToUml2Activator.getDefault());
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    finally {
                        try {
                            ConvertWithCustomTransformation.this.logger.removeHandler((Handler)logHandler);
                            logHandler.close();
                            ConvertWithCustomTransformation.this.kdmFile.getParent().refreshLocal(1, null);
                        }
                        catch (Exception e1) {
                            MoDiscoLogger.logError((Throwable)e1, (Plugin)KdmToUml2Activator.getDefault());
                        }
                    }
                }
            };
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            try {
                                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                                IFile ifile = root.getFileForLocation(ConvertWithCustomTransformation.this.kdmFile.getLocation().removeFileExtension().addFileExtension("uml"));
                                if (ifile.exists()) {
                                    IWorkbenchPage page = ConvertWithCustomTransformation.this.workbench.getSite().getPage();
                                    IDE.openEditor((IWorkbenchPage)page, (IFile)ifile);
                                }
                            }
                            catch (PartInitException e) {
                                MoDiscoLogger.logError((Throwable)e, (Plugin)KdmToUml2Activator.getDefault());
                            }
                        }
                    });
                }
            });
            job.schedule();
        }
        catch (MalformedURLException e2) {
            MoDiscoLogger.logError((Throwable)e2, (String)(String.valueOf(Messages.ConvertWithCustomTransformation_9) + customTransformation), (Plugin)KdmToUml2Activator.getDefault());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.kdmFile = (IFile)((IStructuredSelection)selection).getFirstElement();
    }
}

