/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.views;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.ui.shared.SharedIcons;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.container.ISlow;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.LifecycleState;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.views.IElementFilter;
import org.eclipse.net4j.util.ui.views.ItemProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PartInitException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerItemProvider<CONTAINER extends IContainer<Object>>
extends ItemProvider<CONTAINER> {
    private Map<Object, Node> nodes = new HashMap<Object, Node>();
    private Node root;
    private IElementFilter rootElementFilter;

    public ContainerItemProvider() {
    }

    public ContainerItemProvider(IElementFilter rootElementFilter) {
        this.rootElementFilter = rootElementFilter;
    }

    public IElementFilter getRootElementFilter() {
        return this.rootElementFilter;
    }

    public Object[] getChildren(Object element) {
        try {
            Node node = this.getNode(element);
            List<Node> children = node.getChildren();
            Iterator<Node> it = children.iterator();
            while (it.hasNext()) {
                Node child = it.next();
                if (child.isDisposed()) {
                    it.remove();
                    continue;
                }
                Object childElement = child.getElement();
                LifecycleState lifecycleState = LifecycleUtil.getLifecycleState((Object)childElement);
                if (lifecycleState != LifecycleState.INACTIVE && lifecycleState != LifecycleState.DEACTIVATING) continue;
                this.handleInactiveElement(it, child);
            }
            Object[] result = new Object[children.size()];
            int i = 0;
            while (i < result.length) {
                result[i] = children.get(i).getElement();
                ++i;
            }
            return result;
        }
        catch (RuntimeException ex) {
            return NO_ELEMENTS;
        }
    }

    public Object getParent(Object element) {
        try {
            Node node = this.getNode(element);
            Node parentNode = node.getParent();
            return parentNode == null ? null : parentNode.getElement();
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    public void clearNodesCache() {
        this.disposeRoot();
        IContainer input = (IContainer)this.getInput();
        this.initRoot(input);
    }

    private void initRoot(CONTAINER input) {
        this.root = this.createNode(null, input);
        if (this.root != null) {
            this.addNode(input, this.root);
        }
    }

    private void disposeRoot() {
        this.root.dispose();
        this.root = null;
        this.nodes.clear();
    }

    @Override
    protected void connectInput(CONTAINER input) {
        this.initRoot(input);
    }

    @Override
    protected void disconnectInput(CONTAINER input) {
        this.disposeRoot();
    }

    protected void handleInactiveElement(Iterator<Node> it, Node child) {
        it.remove();
        child.dispose();
    }

    protected void elementAdded(Object element, Object parent) {
    }

    protected void elementRemoved(Object element, Object parent) {
    }

    protected void handleElementEvent(IEvent event) {
    }

    protected Node getRoot() {
        return this.root;
    }

    protected Map<Object, Node> getNodes() {
        return this.nodes;
    }

    protected Node getNode(Object element) {
        Node node = this.root;
        if (element != this.getInput()) {
            node = this.nodes.get(element);
        }
        if (node == null) {
            throw new IllegalStateException("No node for " + element);
        }
        return node;
    }

    protected Node createNode(Node parent, Object element) {
        if (element instanceof IContainer) {
            return this.createContaineNode(parent, element);
        }
        return this.createLeafNode(parent, element);
    }

    protected LeafNode createLeafNode(Node parent, Object element) {
        return new LeafNode(parent, element);
    }

    protected ContainerNode createContaineNode(Node parent, Object element) {
        return new ContainerNode(parent, (IContainer<Object>)((IContainer)element));
    }

    protected void addNode(Object element, Node node) {
        this.nodes.put(element, node);
    }

    protected Node removeNode(Object element) {
        return this.nodes.remove(element);
    }

    protected boolean filterRootElement(Object element) {
        if (this.rootElementFilter != null) {
            return this.rootElementFilter.filter(element);
        }
        return true;
    }

    protected void executeRunnable(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.start();
    }

    protected boolean isSlow(IContainer<Object> container) {
        return container instanceof ISlow;
    }

    protected String getSlowText(IContainer<Object> container) {
        return "Pending...";
    }

    protected String getErrorText(IContainer<Object> container) {
        return "Error";
    }

    @Override
    public void fillContextMenu(IMenuManager manager, ITreeSelection selection) {
        Object element;
        super.fillContextMenu(manager, selection);
        if (selection.size() == 1 && (element = selection.getFirstElement()) instanceof ErrorElement) {
            manager.add((IAction)new Action("Open Error Log"){

                public void run() {
                    try {
                        UIUtil.getActiveWorkbenchPage().showView("org.eclipse.pde.runtime.LogView");
                    }
                    catch (PartInitException ex) {
                        OM.LOG.error((Throwable)ex);
                    }
                }
            });
        }
    }

    @Override
    public Font getFont(Object obj) {
        if (obj instanceof LazyElement) {
            return this.getItalicFont();
        }
        return super.getFont(obj);
    }

    @Override
    public Color getForeground(Object obj) {
        if (obj instanceof LazyElement) {
            return this.getDisplay().getSystemColor(15);
        }
        return super.getForeground(obj);
    }

    @Override
    public Image getImage(Object obj) {
        if (obj instanceof LazyElement) {
            return SharedIcons.getImage((String)"obj16/pending");
        }
        if (obj instanceof ErrorElement) {
            return SharedIcons.getImage((String)"obj16/error");
        }
        return super.getImage(obj);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class AbstractContainerNode
    extends AbstractNode {
        private List<Node> children;
        protected IListener containerListener;

        public AbstractContainerNode(Node parent) {
            super(parent);
            this.containerListener = new ContainerEventAdapter<Object>(){

                protected void notifyContainerEvent(IContainerEvent<Object> event) {
                    super.notifyContainerEvent(event);
                    ContainerItemProvider.this.handleElementEvent((IEvent)event);
                }

                protected void onAdded(IContainer<Object> container, Object element) {
                    AbstractContainerNode.this.onAdded(container, element);
                }

                protected void onRemoved(IContainer<Object> container, Object element) {
                    AbstractContainerNode.this.onRemoved(container, element);
                }

                protected void notifyOtherEvent(IEvent event) {
                    ContainerItemProvider.this.updateLabels(event.getSource());
                    ContainerItemProvider.this.handleElementEvent(event);
                }
            };
        }

        @Override
        public void dispose() {
            if (!this.isDisposed()) {
                if (this.children != null) {
                    for (Node child : this.children) {
                        child.dispose();
                    }
                    this.children.clear();
                    this.children = null;
                    this.containerListener = null;
                }
                super.dispose();
            }
        }

        @Override
        public final List<Node> getChildren() {
            this.checkNotDisposed();
            if (this.children == null) {
                this.children = this.createChildren();
            }
            return this.children;
        }

        public IContainer<Object> getContainer() {
            return (IContainer)this.getElement();
        }

        protected List<Node> createChildren() {
            final ArrayList<Node> children = new ArrayList<Node>();
            final IContainer<Object> container = this.getContainer();
            if (ContainerItemProvider.this.isSlow(container)) {
                final LazyElement lazyElement = new LazyElement(container);
                this.addChild(children, lazyElement);
                Runnable runnable = new Runnable(){

                    public void run() {
                        try {
                            try {
                                AbstractContainerNode.this.fillChildren(children, (IContainer<Object>)container);
                            }
                            catch (Exception ex) {
                                OM.LOG.error((Throwable)ex);
                                AbstractContainerNode.this.addChild(children, new ErrorElement((IContainer<Object>)container));
                                Node node = ContainerItemProvider.this.removeNode(lazyElement);
                                children.remove(node);
                                ContainerItemProvider.this.refreshElement(container, false);
                            }
                        }
                        finally {
                            Node node = ContainerItemProvider.this.removeNode(lazyElement);
                            children.remove(node);
                            ContainerItemProvider.this.refreshElement(container, false);
                        }
                    }
                };
                ContainerItemProvider.this.executeRunnable(runnable);
            } else {
                this.fillChildren(children, container);
            }
            container.addListener(this.containerListener);
            return children;
        }

        protected void fillChildren(List<Node> children, IContainer<Object> container) {
            Object[] elements = container.getElements();
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                this.addChild(children, element);
                ++i;
            }
        }

        protected void onAdded(IContainer<Object> container, Object element) {
            Node node = this.addChild(this.getChildren(), element);
            if (node != null) {
                ContainerItemProvider.this.refreshElement(container, true);
                ContainerItemProvider.this.revealElement(element);
                ContainerItemProvider.this.elementAdded(element, container);
            }
        }

        protected void onRemoved(IContainer<Object> container, Object element) {
            Node node = ContainerItemProvider.this.removeNode(element);
            if (node != null) {
                this.getChildren().remove(node);
                ContainerItemProvider.this.elementRemoved(element, container);
                Object rootElement = ContainerItemProvider.this.root.getElement();
                IContainer<Object> refreshElement = container == rootElement ? null : container;
                ContainerItemProvider.this.refreshElement(refreshElement, true);
                node.dispose();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class AbstractNode
    implements Node {
        private Node parent;
        private boolean disposed;

        public AbstractNode(Node parent) {
            this.parent = parent;
        }

        @Override
        public void dispose() {
            if (!this.disposed) {
                ContainerItemProvider.this.removeNode(this.getElement());
                this.parent = null;
                this.disposed = true;
            }
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        public String toString() {
            return MessageFormat.format("{0}[{1}]", this.getClass().getSimpleName(), this.getElement());
        }

        @Override
        public final Node getParent() {
            this.checkNotDisposed();
            return this.parent;
        }

        @Override
        public TreePath getTreePath() {
            TreePath parentPath = this.parent == null ? TreePath.EMPTY : this.parent.getTreePath();
            return parentPath.createChildPath(this.getElement());
        }

        protected void checkNotDisposed() {
            if (this.disposed) {
                throw new IllegalStateException("Node is already disposed of");
            }
        }

        protected Node addChild(Collection<Node> children, Object element) {
            Node node;
            if (ContainerItemProvider.this.nodes.containsKey(element)) {
                return null;
            }
            if ((this != ContainerItemProvider.this.root || ContainerItemProvider.this.filterRootElement(element)) && (node = ContainerItemProvider.this.createNode(this, element)) != null) {
                ContainerItemProvider.this.addNode(element, node);
                children.add(node);
                return node;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ContainerNode
    extends AbstractContainerNode {
        private IContainer<Object> container;

        public ContainerNode(Node parent, IContainer<Object> container) {
            super(parent);
            this.container = container;
            if (container == null) {
                throw new IllegalArgumentException("container == null");
            }
        }

        @Override
        public void dispose() {
            if (!this.isDisposed()) {
                this.container.removeListener(this.containerListener);
                super.dispose();
                this.container = null;
            }
        }

        @Override
        public Object getElement() {
            return this.container;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ErrorElement {
        private IContainer<Object> container;

        public ErrorElement(IContainer<Object> container) {
            this.container = container;
        }

        public IContainer<Object> getContainer() {
            return this.container;
        }

        public String toString() {
            return ContainerItemProvider.this.getErrorText(this.container);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LazyElement {
        private IContainer<Object> container;

        public LazyElement(IContainer<Object> container) {
            this.container = container;
        }

        public IContainer<Object> getContainer() {
            return this.container;
        }

        public String toString() {
            return ContainerItemProvider.this.getSlowText(this.container);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LeafNode
    extends AbstractNode
    implements IListener {
        private Object element;

        public LeafNode(Node parent, Object element) {
            super(parent);
            this.element = element;
            EventUtil.addListener((Object)element, (IListener)this);
        }

        @Override
        public void dispose() {
            if (!this.isDisposed()) {
                EventUtil.removeListener((Object)this.element, (IListener)this);
                this.element = null;
                super.dispose();
            }
        }

        @Override
        public Object getElement() {
            this.checkNotDisposed();
            return this.element;
        }

        @Override
        public List<Node> getChildren() {
            this.checkNotDisposed();
            return Collections.emptyList();
        }

        public void notifyEvent(IEvent event) {
            ContainerItemProvider.this.updateLabels(event.getSource());
            ContainerItemProvider.this.handleElementEvent(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Node {
        public void dispose();

        public boolean isDisposed();

        public Object getElement();

        public Node getParent();

        public List<Node> getChildren();

        public TreePath getTreePath();
    }
}

