/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.confirmation;

import java.util.Set;
import org.eclipse.net4j.util.confirmation.Confirmation;
import org.eclipse.net4j.util.confirmation.IConfirmationProvider;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.confirmation.ConfirmationDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractiveConfirmationProvider
implements IConfirmationProvider {
    public boolean isInteractive() {
        return true;
    }

    public Confirmation confirm(final String subject, final String message, final Set<Confirmation> acceptable, final Confirmation suggestion) {
        final Confirmation[] confirmation = new Confirmation[1];
        final Display display = UIUtil.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                Shell shell;
                try {
                    IWorkbenchWindow window = UIUtil.getActiveWorkbenchWindow();
                    shell = window.getShell();
                }
                catch (Exception ex) {
                    shell = new Shell(display);
                }
                confirmation[0] = ConfirmationDialog.openConfirm(shell, subject, message, acceptable, suggestion);
            }
        });
        return confirmation[0];
    }

    public static class Factory
    extends IConfirmationProvider.Factory {
        public Factory() {
            super("interactive");
        }

        public Object create(String description) throws ProductCreationException {
            return new InteractiveConfirmationProvider();
        }
    }
}

