/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.common.core.internal.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.facet.infra.common.core.internal.CommonEmfFacetActivator;
import org.eclipse.emf.facet.infra.common.core.internal.protocol.EmfFacetProtocolException;
import org.eclipse.emf.facet.infra.common.core.internal.protocol.EmfFacetURIHandler;
import org.eclipse.emf.facet.infra.common.core.internal.resource.BrokenRefException;
import org.eclipse.emf.facet.infra.common.core.internal.resource.EmfFacetResourceListenerGroup;
import org.eclipse.emf.facet.infra.common.core.internal.resource.IEmfFacetResourceListener;

public final class EmfFacetResourceSet
extends ResourceSetImpl {
    private static final String DEBUG_ID = "org.eclipse.emf.facet.infra.common.core/debug/EmfFacetResoureSet/debug";
    public static final boolean DEBUG = CommonEmfFacetActivator.getDefault().isDebugging() && new Boolean(Platform.getDebugOption((String)"org.eclipse.emf.facet.infra.common.core/debug/EmfFacetResoureSet/debug")) != false;
    private static EmfFacetResourceSet resourceSet = null;
    private final Map<URI, EmfFacetResourceListenerGroup> listenerGroupMap = new HashMap<URI, EmfFacetResourceListenerGroup>();

    private EmfFacetResourceSet() {
    }

    public static EmfFacetResourceSet getResourceSetSingleton() {
        if (resourceSet == null) {
            resourceSet = new EmfFacetResourceSet();
        }
        return resourceSet;
    }

    public Resource getResource(URI uri, IEmfFacetResourceListener listener) throws IOException {
        this.setPackageRegistry(EPackage.Registry.INSTANCE);
        if (DEBUG) {
            String message = String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".getResource(URI,Listener): uri=" + uri.toString();
            System.out.println(message);
        }
        for (Resource existingResource : this.getResources()) {
            if (!existingResource.getURI().equals(uri)) continue;
            existingResource.unload();
            break;
        }
        Resource resource = super.getResource(uri, true);
        resource.load(Collections.EMPTY_MAP);
        try {
            this.addListenerToReferedResource(resource, listener);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return resource;
    }

    private void addListenerToReferedResource(Resource resource, IEmfFacetResourceListener listener) throws Exception {
        TreeIterator treeIterator = resource.getAllContents();
        while (treeIterator.hasNext()) {
            try {
                EObject eObject = (EObject)treeIterator.next();
                for (EStructuralFeature feature : eObject.eClass().getEAllStructuralFeatures()) {
                    Object object = eObject.eGet(feature);
                    if (object instanceof EObject) {
                        this.readEObject(resource, listener, eObject, (EObject)object);
                        continue;
                    }
                    if (!(object instanceof EList)) continue;
                    EList list = (EList)object;
                    for (Object listObject : list) {
                        if (!(object instanceof EObject)) continue;
                        this.readEObject(resource, listener, eObject, (EObject)listObject);
                    }
                }
            }
            catch (BrokenRefException e) {
                resource.getErrors().add((Object)e);
            }
            catch (Exception e) {
                if (e instanceof EmfFacetProtocolException) {
                    EmfFacetProtocolException mpe = (EmfFacetProtocolException)e;
                    resource.getErrors().add((Object)mpe);
                    continue;
                }
                throw e;
            }
        }
    }

    private void readEObject(Resource resource, IEmfFacetResourceListener listener, EObject referringEObject, EObject referredEObject) throws BrokenRefException {
        Resource referredObjectResource = referredEObject.eResource();
        if (referredObjectResource != resource) {
            EObject resolved;
            if (listener != null) {
                URI referredURI = referredObjectResource != null ? referredObjectResource.getURI() : EcoreUtil.getURI((EObject)referredEObject).trimFragment();
                EmfFacetResourceListenerGroup listenerGroup = this.getListenerGroup(referredURI);
                listenerGroup.addListener(listener, resource.getURI());
            }
            if (referredObjectResource == null && (resolved = EcoreUtil.resolve((EObject)referredEObject, (ResourceSet)this)).eIsProxy()) {
                throw new BrokenRefException(referringEObject, referredEObject);
            }
        }
    }

    public EmfFacetResourceListenerGroup getListenerGroup(URI watchedResourceUri) {
        EmfFacetResourceListenerGroup listenerGroup = this.listenerGroupMap.get(watchedResourceUri);
        if (listenerGroup == null) {
            listenerGroup = new EmfFacetResourceListenerGroup(watchedResourceUri);
            this.listenerGroupMap.put(watchedResourceUri, listenerGroup);
        }
        return listenerGroup;
    }

    public void aResourceHasBeenLoaded(Resource resource) {
        URI uri = resource.getURI();
        if (DEBUG) {
            String message = String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".aResourceHasBeenLoaded(Resource)] resource.getURI()=" + uri.toString();
            System.out.println(message);
        }
        EmfFacetResourceListenerGroup listenerGroup = this.getListenerGroup(uri);
        listenerGroup.notifyChange();
    }

    public void aResourceHasBeenUnLoaded(Resource resource) {
        URI uri = resource.getURI();
        if (DEBUG) {
            String message = String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".aResourceHasBeenUnLoaded(Resource): resource.getURI()=" + uri.toString();
            System.out.println(message);
        }
        EmfFacetResourceListenerGroup listenerGroup = this.getListenerGroup(uri);
        listenerGroup.notifyChange();
    }

    public URIConverter getURIConverter() {
        if (this.uriConverter == null) {
            this.uriConverter = EmfFacetResourceSet.createURIConverter();
        }
        return this.uriConverter;
    }

    public static URIConverter createURIConverter() {
        List defaultHandlers = URIHandler.DEFAULT_HANDLERS;
        ArrayList<EmfFacetURIHandler> uriHandlers = new ArrayList<EmfFacetURIHandler>();
        uriHandlers.add(new EmfFacetURIHandler());
        uriHandlers.addAll(defaultHandlers);
        return new ExtensibleURIConverterImpl(uriHandlers, (Collection)ContentHandler.Registry.INSTANCE.contentHandlers());
    }

    public void removeListener(IEmfFacetResourceListener listener, URI dependingResource) {
        for (EmfFacetResourceListenerGroup group : this.listenerGroupMap.values()) {
            group.remove(listener, dependingResource);
        }
    }
}

