/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchChangedEvent;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerWriteIndication;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;

public class RenameBranchIndication
extends CDOServerWriteIndication {
    private int branchID;
    private String newName;

    public RenameBranchIndication(CDOServerProtocol protocol) {
        super(protocol, (short)58);
    }

    protected void indicating(CDODataInput in) throws IOException {
        this.branchID = in.readInt();
        this.newName = in.readString();
    }

    protected void responding(CDODataOutput out) throws IOException {
        InternalCDOBranchManager branchManager = this.getRepository().getBranchManager();
        InternalCDOBranch branch = branchManager.getBranch(this.branchID);
        branchManager.renameBranch((CDOBranch)branch, this.newName);
        InternalSessionManager sessionManager = this.getRepository().getSessionManager();
        sessionManager.sendBranchNotification(this.getSession(), branch, CDOBranchChangedEvent.ChangeKind.RENAMED);
        out.writeBoolean(true);
    }
}

