/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.blockdefinition.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.AbstractEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.SelectionEditor;
import org.eclipse.papyrus.infra.widgets.providers.AbstractStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.papyrus.sysml.diagram.blockdefinition.messages.Messages;
import org.eclipse.papyrus.sysml.diagram.blockdefinition.ui.CreateUmlElementDialog;
import org.eclipse.papyrus.sysml.diagram.blockdefinition.ui.NewElementRepresentation;
import org.eclipse.papyrus.sysml.portandflows.FlowSpecification;
import org.eclipse.papyrus.uml.diagram.common.util.Util;
import org.eclipse.papyrus.uml.diagram.common.util.Visitor;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceManagerDialog
extends SelectionDialog {
    private Port port;
    private List<Object> providedInterfaces;
    private List<Object> requiredInterfaces;
    private ReferenceSelector providedSelector;
    private ReferenceSelector requiredSelector;
    private SelectionEditor providedEditor;
    private SelectionEditor requiredEditor;
    private Map<Interface, List<Usage>> requiredInterfacesMappedWithUsage = new HashMap<Interface, List<Usage>>();
    private Map<Interface, List<Realization>> providedInterfacesMappedWithRealization = new HashMap<Interface, List<Realization>>();
    private final ILabelProvider selectorLabelProvider = new SelectorLabelProvider();
    private final ILabelProvider newElementLabelProvider = new CreateElementLabelProvider();
    private TransactionalEditingDomain domain;
    private Package model = null;
    private CompoundCommand interfaceCreationCommand = new CompoundCommand("Create Interfaces Commands");
    private List<NewElementRepresentation> interfaceRepresentations;
    private boolean typedWithInterface;
    private static final String ICON_WARNING = "/icons/warning.gif";
    private List<String> forbiddenNames;

    public InterfaceManagerDialog(Shell parentShell, Port port) {
        super(parentShell);
        this.setTitle(Messages.InterfaceManagerDialog_Title);
        this.port = port;
        Assert.isTrue((boolean)(this.port.getType() instanceof Classifier));
        this.typedWithInterface = this.port.getType() instanceof Interface;
    }

    public void create() {
        super.create();
        this.init();
    }

    protected void init() {
        this.forbiddenNames = new ArrayList<String>();
        this.interfaceRepresentations = new ArrayList<NewElementRepresentation>();
        EList namespaces = this.port.allNamespaces();
        Element el = (Element)namespaces.get(namespaces.size() - 1);
        this.model = el instanceof Package ? (Package)el : el.getNearestPackage();
        this.buildProvidedInterfaces();
        this.buildRequiredInterfaces();
        this.providedInterfaces = new ArrayList<Object>();
        for (Interface current : this.port.getProvideds()) {
            this.providedInterfaces.add(current);
        }
        if (this.typedWithInterface) {
            this.providedInterfaces.remove(this.port.getType());
        }
        this.requiredInterfaces = new ArrayList<Object>();
        for (Interface current : this.port.getRequireds()) {
            this.requiredInterfaces.add(current);
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = activePage.getActiveEditor();
        if (editor instanceof IMultiDiagramEditor) {
            try {
                this.domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)((IMultiDiagramEditor)editor).getServicesRegistry());
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        this.createSelectors();
        this.createEditors();
    }

    protected void buildRequiredInterfaces() {
        List allUsage = Util.getInstancesFilteredByType((Package)this.model, Usage.class, null);
        ArrayList<Classifier> classifiers = new ArrayList<Classifier>();
        classifiers.add((Classifier)this.port.getType());
        classifiers.addAll(Util.getAllSuperClasses(null, (Classifier)((Classifier)this.port.getType())));
        block0: for (Object current : allUsage) {
            Usage usage = (Usage)current;
            for (Classifier classifier : classifiers) {
                if (!usage.getClients().contains((Object)classifier)) continue;
                for (EObject target : usage.getSuppliers()) {
                    if (!this.port.getRequireds().contains((Object)target)) continue;
                    List<Usage> usages = this.requiredInterfacesMappedWithUsage.get(target);
                    if (usages != null) {
                        usages.add(usage);
                        continue;
                    }
                    usages = new ArrayList<Usage>();
                    usages.add(usage);
                    this.requiredInterfacesMappedWithUsage.put((Interface)target, usages);
                }
                continue block0;
            }
        }
    }

    protected void buildProvidedInterfaces() {
        List allRealization = Util.getInstancesFilteredByType((Package)this.model, Realization.class, null);
        ArrayList<Classifier> classifiers = new ArrayList<Classifier>();
        classifiers.add((Classifier)this.port.getType());
        classifiers.addAll(Util.getAllSuperClasses(null, (Classifier)((Classifier)this.port.getType())));
        block0: for (Object current : allRealization) {
            Realization realization = (Realization)current;
            for (Classifier classifier : classifiers) {
                if (!realization.getClients().contains((Object)classifier)) continue;
                for (EObject target : realization.getSuppliers()) {
                    if (!this.port.getProvideds().contains((Object)target)) continue;
                    List<Realization> realizations = this.providedInterfacesMappedWithRealization.get(target);
                    if (realizations != null) {
                        realizations.add(realization);
                        continue;
                    }
                    realizations = new ArrayList<Realization>();
                    realizations.add(realization);
                    this.providedInterfacesMappedWithRealization.put((Interface)target, realizations);
                }
                continue block0;
            }
        }
    }

    protected void createSelectors() {
        this.providedSelector = new ReferenceSelector(true);
        this.providedSelector.setLabelProvider(this.selectorLabelProvider);
        this.providedSelector.setContentProvider(new IStaticContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements() {
                ArrayList<Interface> tmp = new ArrayList<Interface>();
                tmp.addAll(InterfaceManagerDialog.this.getAllAvailableInterfaces(InterfaceManagerDialog.this.model));
                if (InterfaceManagerDialog.this.typedWithInterface) {
                    tmp.remove(InterfaceManagerDialog.this.port.getType());
                }
                tmp.addAll(InterfaceManagerDialog.this.interfaceRepresentations);
                return tmp.toArray();
            }

            public Object[] getElements(Object inputElement) {
                return this.getElements();
            }
        });
        this.requiredSelector = new ReferenceSelector(true);
        this.requiredSelector.setLabelProvider(this.selectorLabelProvider);
        this.requiredSelector.setContentProvider((IStaticContentProvider)new AbstractStaticContentProvider(){

            public Object[] getElements() {
                ArrayList<Interface> tmp = new ArrayList<Interface>();
                tmp.addAll(InterfaceManagerDialog.this.getAllAvailableInterfaces(InterfaceManagerDialog.this.model));
                tmp.addAll(InterfaceManagerDialog.this.interfaceRepresentations);
                return tmp.toArray();
            }
        });
    }

    protected void createEditors() {
        Composite parent = (Composite)this.getDialogArea();
        CreateButtonListener listener = new CreateButtonListener();
        if (this.typedWithInterface) {
            Composite messageSection = new Composite(parent, 2048);
            CLabel label = new CLabel(messageSection, 0);
            label.setText(Messages.InterfaceManagerDialog_ThePortIsTypedWithAnInterfaceWarningMessage);
            Image errorImage = org.eclipse.papyrus.uml.diagram.common.Activator.getPluginIconImage((String)"org.eclipse.papyrus.uml.diagram.common", (String)ICON_WARNING);
            label.setImage(errorImage);
            GridLayout layout = new GridLayout(1, true);
            GridData data = new GridData(4, 4, true, false);
            messageSection.setLayout((Layout)layout);
            messageSection.setLayoutData((Object)data);
            messageSection.setEnabled(false);
        }
        this.providedEditor = this.createEditor(parent, (IElementSelector)this.providedSelector, Messages.InterfaceManagerDialog_SelectedTheProvidedInterfaces, false, listener, this.providedInterfaces);
        this.requiredEditor = this.createEditor(parent, (IElementSelector)this.requiredSelector, Messages.InterfaceManagerDialog_SelectTheRequiredInterfaces, true, listener, this.requiredInterfaces);
        this.providedEditor.create();
        this.requiredEditor.create();
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        GridData data = new GridData(4, 4, true, true);
        this.providedEditor.setLayoutData((Object)data);
        this.requiredEditor.setLayoutData((Object)data);
        this.getShell().setSize(950, 700);
        this.getShell().layout();
    }

    protected SelectionEditor createEditor(Composite parent, IElementSelector selector, String message, boolean withCreateButton, SelectionListener listener, List<Object> initialSelection) {
        SelectionEditor editor = new SelectionEditor(parent, selector, this.selectorLabelProvider, initialSelection);
        editor.setMessage(message);
        editor.setAdditionalButton(withCreateButton, Messages.InterfaceManagerDialog_CreateNewInterface, listener);
        return editor;
    }

    protected List<Interface> getAllAvailableInterfaces(Package pack) {
        ArrayList<Interface> otherInterfaces = new ArrayList<Interface>();
        List interfaces = Visitor.getOwnedAndImportedElement((Namespace)pack, Interface.class);
        for (Namespace namespace : Visitor.getOwnedAndImportedNamespaces((Namespace)pack)) {
            interfaces.addAll(Visitor.getOwnedAndImportedElement((Namespace)namespace, Interface.class));
        }
        for (Element element : interfaces) {
            FlowSpecification flowSpec = (FlowSpecification)UMLUtil.getStereotypeApplication((Element)element, FlowSpecification.class);
            if (flowSpec != null) continue;
            otherInterfaces.add((Interface)element);
        }
        return otherInterfaces;
    }

    public Command getCommand() {
        Command cmd;
        CompoundCommand command = new CompoundCommand("Command to manage interfaces on Port");
        if (!this.interfaceCreationCommand.isEmpty()) {
            command.add((Command)this.interfaceCreationCommand);
        }
        if ((cmd = this.getCommandsToCreateElements()).canExecute()) {
            command.add(cmd);
        }
        if ((cmd = this.getCommandToRemoveReferencedInterfaces()).canExecute()) {
            command.add(cmd);
        }
        return command;
    }

    protected Command getCommandToRemoveReferencedInterfaces() {
        Command cmd;
        DestroyReferenceRequest request;
        CompoundCommand command = new CompoundCommand("Command to destroy Usage and InterfaceRealization");
        HashSet<Dependency> relationshipToDestroy = new HashSet<Dependency>();
        for (Object current : this.requiredEditor.getElementToRemove()) {
            List<Usage> usages = this.requiredInterfacesMappedWithUsage.get(current);
            for (Usage currentUsage : usages) {
                request = new DestroyReferenceRequest(this.domain, (EObject)currentUsage, UMLPackage.eINSTANCE.getDependency_Supplier(), (EObject)current, false);
                cmd = this.getCommand((AbstractEditCommandRequest)request);
                if (!cmd.canExecute()) continue;
                command.add(cmd);
                relationshipToDestroy.add((Dependency)currentUsage);
            }
        }
        for (Object current : this.providedEditor.getElementToRemove()) {
            List<Realization> realizations = this.providedInterfacesMappedWithRealization.get(current);
            for (Realization currentRealization : realizations) {
                request = new DestroyReferenceRequest(this.domain, (EObject)currentRealization, UMLPackage.eINSTANCE.getDependency_Supplier(), (EObject)current, false);
                cmd = this.getCommand((AbstractEditCommandRequest)request);
                if (!cmd.canExecute()) continue;
                command.add(cmd);
                relationshipToDestroy.add((Dependency)currentRealization);
            }
        }
        if (!relationshipToDestroy.isEmpty()) {
            command.add((Command)new ICommandProxy((ICommand)new DestroyDependencyWithoutSupplierCommand(this.domain, null, relationshipToDestroy)));
            return command;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getCommandsToCreateElements() {
        AbstractTransactionalCommand cmd;
        Command cmd2;
        CreateRelationshipRequest request;
        CompoundCommand command = new CompoundCommand("Command to create Usage and InterfaceRealization");
        for (Object current : this.requiredEditor.getElementToAdd()) {
            if (current instanceof EObject) {
                request = new CreateRelationshipRequest(this.port.getType().eContainer(), (EObject)this.port.getType(), (EObject)current, (IElementType)UMLElementTypes.USAGE);
                cmd2 = this.getCommand((AbstractEditCommandRequest)request);
                if (!cmd2.canExecute()) continue;
                command.add(cmd2);
                continue;
            }
            cmd = new CreateUsageCommand(this.domain, this.port.getType().eContainer(), (EObject)this.port.getType(), (NewElementRepresentation)current, null);
            if (!cmd.canExecute()) continue;
            command.add((Command)new ICommandProxy((ICommand)cmd));
        }
        for (Object current : this.providedEditor.getElementToAdd()) {
            if (current instanceof EObject) {
                request = new CreateRelationshipRequest(this.port.getType().eContainer(), (EObject)this.port.getType(), (EObject)current, (IElementType)UMLElementTypes.INTERFACE_REALIZATION);
                cmd2 = this.getCommand((AbstractEditCommandRequest)request);
                if (!cmd2.canExecute()) continue;
                command.add(cmd2);
                continue;
            }
            cmd = new CreateInterfaceRealizationCommand(this.domain, this.port.getType().eContainer(), (EObject)this.port.getType(), (NewElementRepresentation)current, null);
            if (!cmd.canExecute()) continue;
            command.add((Command)new ICommandProxy((ICommand)cmd));
        }
        if (!command.isEmpty()) {
            return command;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getCommand(AbstractEditCommandRequest req) {
        ICommand setCommand;
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)this.model);
        if (provider != null && (setCommand = provider.getEditCommand((IEditCommandRequest)req)) != null) {
            return new ICommandProxy(setCommand.reduce());
        }
        return UnexecutableCommand.INSTANCE;
    }

    public class CreateButtonListener
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            CreateUmlElementDialog dialog = new CreateUmlElementDialog(InterfaceManagerDialog.this.getShell(), InterfaceManagerDialog.this.domain, InterfaceManagerDialog.this.newElementLabelProvider, new CustomContentProvider(), InterfaceManagerDialog.this.model, UMLElementTypes.INTERFACE);
            dialog.setTitle(Messages.InterfaceManagerDialog_CreateANewInterface);
            dialog.setMessage(Messages.InterfaceManagerDialog_SelectTheParentOfThisNewInterface);
            dialog.setHelpAvailable(false);
            dialog.setForbiddenNames(InterfaceManagerDialog.this.forbiddenNames);
            ArrayList<Package> input = new ArrayList<Package>();
            input.add(InterfaceManagerDialog.this.model);
            dialog.setInput(input);
            dialog.setValidator(new ParentInterfaceValidator());
            if (dialog.open() == 0) {
                Object[] res;
                InterfaceManagerDialog.this.interfaceCreationCommand.add(dialog.getCommand());
                Object[] objectArray = res = dialog.getResult();
                int n = res.length;
                int n2 = 0;
                while (n2 < n) {
                    Object current = objectArray[n2];
                    if (current instanceof NewElementRepresentation) {
                        InterfaceManagerDialog.this.interfaceRepresentations.add((NewElementRepresentation)current);
                        InterfaceManagerDialog.this.forbiddenNames.add(((NewElementRepresentation)current).getName());
                    }
                    ++n2;
                }
                InterfaceManagerDialog.this.providedSelector.refresh();
                InterfaceManagerDialog.this.requiredSelector.refresh();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class CreateElementLabelProvider
    extends UMLLabelProvider {
        public Image getImage(Object element) {
            if (element instanceof NewElementRepresentation) {
                return Activator.getDefault().getImageForUMLMetaclass(UMLPackage.eINSTANCE.getInterface());
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof NewElementRepresentation) {
                return ((NewElementRepresentation)element).getName();
            }
            return super.getText(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CreateInterfaceRealizationCommand
    extends AbstractTransactionalCommand {
        private EObject container;
        private EObject source;
        private NewElementRepresentation target;

        public CreateInterfaceRealizationCommand(TransactionalEditingDomain domain, EObject container, EObject source, NewElementRepresentation target, List<?> affectedFiles) {
            super(domain, "Create InterfaceRealization Command", affectedFiles);
            this.container = container;
            this.source = source;
            this.target = target;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            CreateRelationshipRequest request = new CreateRelationshipRequest(InterfaceManagerDialog.this.domain, this.container, this.source, this.target.getEObject(), (IElementType)UMLElementTypes.INTERFACE_REALIZATION);
            Command command = InterfaceManagerDialog.this.getCommand((AbstractEditCommandRequest)request);
            if (command.canExecute()) {
                command.execute();
            }
            return CommandResult.newOKCommandResult((Object)request.getNewElement());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CreateUsageCommand
    extends AbstractTransactionalCommand {
        private EObject container;
        private EObject source;
        private NewElementRepresentation target;

        public CreateUsageCommand(TransactionalEditingDomain domain, EObject container, EObject source, NewElementRepresentation target, List<?> affectedFiles) {
            super(domain, "Create Usage Command", affectedFiles);
            this.container = container;
            this.source = source;
            this.target = target;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            CreateRelationshipRequest request = new CreateRelationshipRequest(InterfaceManagerDialog.this.domain, this.container, this.source, this.target.getEObject(), (IElementType)UMLElementTypes.USAGE);
            Command command = InterfaceManagerDialog.this.getCommand((AbstractEditCommandRequest)request);
            if (command.canExecute()) {
                command.execute();
            }
            return CommandResult.newOKCommandResult((Object)request.getNewElement());
        }
    }

    public class CustomContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<Object> children = new ArrayList<Object>();
            EList tmp = null;
            if (parentElement instanceof Package) {
                tmp = ((Package)parentElement).getOwnedMembers();
            } else if (parentElement instanceof Classifier) {
                tmp = ((Classifier)parentElement).getOwnedMembers();
            }
            if (tmp != null) {
                for (Object current : tmp) {
                    if (!(current instanceof Classifier) && !(current instanceof Package)) continue;
                    children.add(current);
                }
            }
            for (Object current : InterfaceManagerDialog.this.interfaceRepresentations) {
                if (((NewElementRepresentation)current).getParent() != parentElement) continue;
                children.add(current);
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            if (element == InterfaceManagerDialog.this.model) {
                return InterfaceManagerDialog.this.model;
            }
            if (element instanceof NamedElement) {
                return ((NamedElement)element).eContainer();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length != 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DestroyDependencyWithoutSupplierCommand
    extends AbstractTransactionalCommand {
        private Set<Dependency> dependencies;

        public DestroyDependencyWithoutSupplierCommand(TransactionalEditingDomain domain, List<?> affectedFiles, Set<Dependency> dependencies) {
            super(domain, "Destroy the empty elements", affectedFiles);
            this.dependencies = dependencies;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            CompoundCommand command = new CompoundCommand("Destroy relationship without suppliers");
            for (Dependency current : this.dependencies) {
                DestroyElementRequest request;
                Command cmd;
                if (!current.getSuppliers().isEmpty() || !(cmd = InterfaceManagerDialog.this.getCommand((AbstractEditCommandRequest)(request = new DestroyElementRequest(InterfaceManagerDialog.this.domain, (EObject)current, false)))).canExecute()) continue;
                command.add(cmd);
            }
            if (!command.isEmpty() && command.canExecute()) {
                command.execute();
            }
            return CommandResult.newOKCommandResult();
        }
    }

    public class ParentInterfaceValidator
    implements ISelectionStatusValidator {
        public IStatus validate(Object[] selection) {
            Status status = new Status(4, "org.eclipse.papyrus.sysml.diagram.blockdefinition", Messages.NoSelectionFound);
            if (selection.length >= 1) {
                int i = 0;
                while (i < selection.length) {
                    if (!(selection[i] instanceof Package || selection[i] instanceof Classifier || selection[i] instanceof NewElementRepresentation)) {
                        status = new Status(4, "org.eclipse.papyrus.sysml.diagram.blockdefinition", Messages.InterfaceManagerDialog_SelectionHasToBeAPackageOrAClassifier);
                        break;
                    }
                    status = new Status(0, "org.eclipse.papyrus.sysml.diagram.blockdefinition", Messages.SelectionValidated);
                    ++i;
                }
            }
            return status;
        }
    }

    public class SelectorLabelProvider
    extends CreateElementLabelProvider {
        public String getText(Object element) {
            if (element instanceof NewElementRepresentation) {
                return ((NewElementRepresentation)element).getQualifiedName();
            }
            if (element instanceof NamedElement) {
                return ((NamedElement)element).getQualifiedName();
            }
            return super.getText(element);
        }
    }
}

