/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ATTRIBUTE_OP implements Enumerator
{
    EQUALS(0, "EQUALS", "="),
    CONTAINS(1, "CONTAINS", "~="),
    UNEQUALS(2, "UNEQUALS", "!=");

    public static final int EQUALS_VALUE = 0;
    public static final int CONTAINS_VALUE = 1;
    public static final int UNEQUALS_VALUE = 2;
    private static final ATTRIBUTE_OP[] VALUES_ARRAY;
    public static final List<ATTRIBUTE_OP> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ATTRIBUTE_OP[]{EQUALS, CONTAINS, UNEQUALS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ATTRIBUTE_OP get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ATTRIBUTE_OP result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ATTRIBUTE_OP getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ATTRIBUTE_OP result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ATTRIBUTE_OP get(int value) {
        switch (value) {
            case 0: {
                return EQUALS;
            }
            case 1: {
                return CONTAINS;
            }
            case 2: {
                return UNEQUALS;
            }
        }
        return null;
    }

    private ATTRIBUTE_OP(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

