/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.builder.BaseApiAnalyzer;
import org.eclipse.pde.api.tools.internal.builder.BuildContext;
import org.eclipse.pde.api.tools.internal.model.StubApiComponent;
import org.eclipse.pde.api.tools.internal.problems.ApiProblem;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.builder.IBuildContext;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.search.MissingRefMetadata;
import org.eclipse.pde.api.tools.internal.search.SkippedComponent;
import org.eclipse.pde.api.tools.internal.search.UseScanManager;
import org.eclipse.pde.api.tools.internal.tasks.CommonUtilsTask;
import org.eclipse.pde.api.tools.internal.tasks.Messages;
import org.eclipse.pde.api.tools.internal.util.FilteredElements;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.osgi.framework.Version;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MissingRefProblemsTask
extends CommonUtilsTask {
    private FilteredElements excludedElements;
    private FilteredElements includedElements;
    private String apiUseScans;
    private String[] usescans;
    private Properties properties = new Properties();
    TreeSet<SkippedComponent> notsearched = new TreeSet(Util.componentsorter);
    public static final String COMPATIBILITY = "compatibility";
    private static final Summary[] NO_SUMMARIES = new Summary[0];

    public void execute() throws BuildException {
        if (this.currentBaselineLocation == null || this.reportLocation == null || this.apiUseScans == null) {
            StringBuffer error = new StringBuffer(NLS.bind((String)Messages.MissingRefProblemsTask_missingArguments, (Object[])new String[]{this.currentBaselineLocation, this.reportLocation}));
            throw new BuildException(error.toString());
        }
        File loc = new File(this.reportLocation);
        if (loc.exists()) {
            Util.delete((File)loc);
        }
        if (this.usescans != null && this.usescans.length > 0) {
            int i = 0;
            while (i < this.usescans.length) {
                File file = new File(this.usescans[i].trim());
                if (!file.exists()) {
                    StringBuffer error = new StringBuffer(Messages.MissingRefProblemsTask_invalidApiUseScanLocation);
                    error.append(this.usescans[i]);
                    throw new BuildException(error.toString());
                }
                ++i;
            }
        }
        if (this.debug) {
            System.out.println("profile to compare : " + this.currentBaselineLocation);
            System.out.println("report location : " + this.reportLocation);
            if (this.excludeListLocation != null) {
                System.out.println("exclude list location : " + this.excludeListLocation);
            } else {
                System.out.println("No exclude list location");
            }
            if (this.includeListLocation != null) {
                System.out.println("include list location : " + this.includeListLocation);
            } else {
                System.out.println("No include list location");
            }
        }
        long time = 0L;
        if (this.debug) {
            time = System.currentTimeMillis();
        }
        File baselineInstallDir = this.extractSDK("currentBaseline", this.currentBaselineLocation);
        if (this.debug) {
            System.out.println("Preparation of profile installation : " + (System.currentTimeMillis() - time) + "ms");
            time = System.currentTimeMillis();
        }
        IApiBaseline profile = this.createBaseline("current_baseline", baselineInstallDir.getAbsolutePath(), null);
        if (this.debug) {
            System.out.println("Creation of baseline : " + (System.currentTimeMillis() - time) + "ms");
            time = System.currentTimeMillis();
        }
        if (this.excludeListLocation != null) {
            this.excludedElements = CommonUtilsTask.initializeFilteredElements(this.excludeListLocation, profile, this.debug);
        }
        if (this.includeListLocation != null) {
            this.includedElements = CommonUtilsTask.initializeFilteredElements(this.includeListLocation, profile, this.debug);
        }
        UseScanManager.getInstance().setReportLocations(this.usescans);
        if (this.debug) {
            System.out.println("====================================================================================");
            System.out.println("API Use Scan locations:");
            int i = 0;
            while (i < this.usescans.length) {
                System.out.println("Location " + (i + 1) + " : " + this.usescans[i]);
                ++i;
            }
        }
        HashMap<String, IApiProblem[]> allProblems = new HashMap<String, IApiProblem[]>();
        try {
            IApiComponent[] apiComponents = profile.getApiComponents();
            int length = apiComponents.length;
            HashSet<String> visitedApiComponentNames = new HashSet<String>();
            int i = 0;
            while (i < length) {
                block33: {
                    IApiComponent apiComponent = apiComponents[i];
                    String name = apiComponent.getSymbolicName();
                    String version = apiComponent.getVersion();
                    if (this.acceptComponent(apiComponent)) {
                        visitedApiComponentNames.add(name);
                        BaseApiAnalyzer analyzer = new BaseApiAnalyzer();
                        try {
                            try {
                                if (this.properties.isEmpty()) {
                                    this.addDefaultProperties();
                                }
                                analyzer.checkExternalDependencies(apiComponent, (IBuildContext)new BuildContext(), this.properties, (IProgressMonitor)new NullProgressMonitor());
                                IApiProblem[] problems = analyzer.getProblems();
                                if (problems.length != 0) {
                                    allProblems.put(String.valueOf(name) + " (" + new Version(version).toString() + ")", problems);
                                }
                            }
                            catch (RuntimeException e) {
                                ApiPlugin.log((Throwable)e);
                                throw e;
                            }
                            catch (CoreException e) {
                                ApiPlugin.log((Throwable)e);
                                analyzer.dispose();
                                break block33;
                            }
                        }
                        catch (Throwable throwable) {
                            analyzer.dispose();
                            throw throwable;
                        }
                        analyzer.dispose();
                    }
                }
                ++i;
            }
        }
        finally {
            if (this.debug) {
                System.out.println("Use scan reference check completed in: " + (System.currentTimeMillis() - time) + "ms");
                time = System.currentTimeMillis();
            }
            profile.dispose();
            StubApiComponent.disposeAllCaches();
            this.deleteBaseline(this.currentBaselineLocation, baselineInstallDir);
            this.writeMetaData(new File(this.reportLocation, "meta.xml"));
        }
        Summary[] summaries = this.createAllSummaries(allProblems);
        try {
            this.dumpReport(summaries);
            this.reportNotSearched(this.notsearched);
        }
        catch (RuntimeException e) {
            ApiPlugin.log((Throwable)e);
            throw e;
        }
    }

    boolean acceptComponent(IApiComponent component) {
        ResolverError[] errors;
        String version;
        String name;
        block6: {
            block5: {
                name = component.getSymbolicName();
                version = component.getVersion();
                try {
                    errors = component.getErrors();
                    if ((errors == null || errors.length <= 0) && !component.isSystemComponent() && Util.isApiToolsComponent((IApiComponent)component)) break block5;
                    this.notsearched.add(new SkippedComponent(name, version, errors));
                    return false;
                }
                catch (CoreException coreException) {
                    this.notsearched.add(new SkippedComponent(name, version, null));
                    return false;
                }
            }
            if (this.excludedElements == null || !this.excludedElements.containsExactMatch(name) && !this.excludedElements.containsPartialMatch(name)) break block6;
            this.notsearched.add(new SkippedComponent(name, version, errors));
            return false;
        }
        if (!(this.includedElements == null || this.includedElements.isEmpty() || this.includedElements.containsExactMatch(name) || this.includedElements.containsPartialMatch(name))) {
            this.notsearched.add(new SkippedComponent(name, version, errors));
            return false;
        }
        return true;
    }

    private void addDefaultProperties() {
        this.properties.put("API_USE_SCAN_TYPE_SEVERITY", "Error");
        this.properties.put("API_USE_SCAN_METHOD_SEVERITY", "Error");
        this.properties.put("API_USE_SCAN_FIELD_SEVERITY", "Error");
    }

    private void writeMetaData(File file) {
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                if (!file.createNewFile()) {
                    return;
                }
            }
            if (this.debug) {
                System.out.println("Writing metadata to " + file.getAbsolutePath());
            }
            MissingRefMetadata metadata = new MissingRefMetadata(this.currentBaselineLocation, this.reportLocation, this.apiUseScans);
            metadata.serializeToFile(file);
        }
        catch (UnsupportedEncodingException e) {
            ApiPlugin.log((Throwable)e);
        }
        catch (FileNotFoundException e) {
            ApiPlugin.log((Throwable)e);
        }
        catch (IOException e) {
            ApiPlugin.log((Throwable)e);
        }
        catch (CoreException e) {
            ApiPlugin.log((Throwable)e);
        }
    }

    private Summary[] createAllSummaries(Map<String, IApiProblem[]> allProblems) {
        Set<Map.Entry<String, IApiProblem[]>> entrySet = allProblems.entrySet();
        int size = entrySet.size();
        if (size == 0) {
            return NO_SUMMARIES;
        }
        ArrayList<Map.Entry<String, IApiProblem[]>> allEntries = new ArrayList<Map.Entry<String, IApiProblem[]>>();
        allEntries.addAll(entrySet);
        Collections.sort(allEntries, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Map.Entry entry1 = (Map.Entry)o1;
                Map.Entry entry2 = (Map.Entry)o2;
                return ((String)entry1.getKey()).compareTo((String)entry2.getKey());
            }
        });
        Summary[] summaries = new Summary[size];
        int i = 0;
        for (Map.Entry entry : allEntries) {
            summaries[i++] = new Summary((String)entry.getKey(), (IApiProblem[])entry.getValue());
        }
        return summaries;
    }

    private void dumpReport(Summary[] summaries) {
        int i = 0;
        int max = summaries.length;
        while (i < max) {
            Summary summary = summaries[i];
            String contents = null;
            String componentID = summary.fComponentID;
            try {
                Document document = Util.newDocument();
                Element report = document.createElement("report");
                report.setAttribute("version", "1");
                report.setAttribute("componentID", componentID);
                document.appendChild(report);
                Element category = document.createElement("category");
                category.setAttribute("key", Integer.toString(Integer.MIN_VALUE));
                category.setAttribute("value", COMPATIBILITY);
                this.insertAPIProblems(category, document, summary.fApiProblems);
                report.appendChild(category);
                contents = Util.serializeDocument((Document)document);
            }
            catch (DOMException e) {
                throw new BuildException((Throwable)e);
            }
            catch (CoreException e) {
                throw new BuildException((Throwable)e);
            }
            if (contents != null) {
                this.saveReport(componentID, contents, "report.xml");
            }
            ++i;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reportNotSearched(Set<SkippedComponent> notSearchedList) {
        if (notSearchedList.isEmpty()) {
            return;
        }
        BufferedWriter writer = null;
        try {
            File file;
            File rootfile;
            if (this.debug) {
                System.out.println("Writing file for projects that were not searched...");
            }
            if (!(rootfile = new File(this.reportLocation)).exists()) {
                rootfile.mkdirs();
            }
            if (!(file = new File(rootfile, "not_searched.xml")).exists()) {
                file.createNewFile();
            }
            Document doc = Util.newDocument();
            Element root = doc.createElement("components");
            root.setAttribute("ShowMissing", "false");
            doc.appendChild(root);
            Element comp = null;
            for (SkippedComponent component : notSearchedList) {
                comp = doc.createElement("component");
                comp.setAttribute("id", component.getComponentId());
                comp.setAttribute("version", component.getVersion());
                comp.setAttribute("details", component.getErrorDetails());
                root.appendChild(comp);
            }
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            writer.write(Util.serializeDocument((Document)doc));
            writer.flush();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (writer == null) return;
            try {
                writer.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (IOException iOException) {
            if (writer == null) return;
            try {
                writer.close();
                return;
            }
            catch (IOException iOException2) {}
            return;
        }
        catch (CoreException coreException) {
            if (writer == null) return;
            {
                catch (Throwable throwable) {
                    if (writer == null) throw throwable;
                    try {
                        writer.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                writer.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (writer == null) return;
        try {
            writer.close();
            return;
        }
        catch (IOException iOException) {}
    }

    private void insertAPIProblems(Element root, Document document, List<IApiProblem> problems) throws CoreException {
        Element apiProblems = document.createElement("api_problems");
        root.appendChild(apiProblems);
        Element element = null;
        Collections.sort(problems, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                IApiProblem p1 = (IApiProblem)o1;
                IApiProblem p2 = (IApiProblem)o2;
                return p1.getTypeName().compareTo(p2.getTypeName());
            }
        });
        for (IApiProblem problem : problems) {
            String[] messageArguments;
            int j;
            element = document.createElement("api_problem");
            element.setAttribute("typeName", String.valueOf(problem.getTypeName()));
            element.setAttribute("id", Integer.toString(problem.getId()));
            element.setAttribute("linenumber", Integer.toString(problem.getLineNumber()));
            element.setAttribute("charstart", Integer.toString(problem.getCharStart()));
            element.setAttribute("charend", Integer.toString(problem.getCharEnd()));
            element.setAttribute("elementkind", Integer.toString(problem.getElementKind()));
            element.setAttribute("element_type", ApiProblem.getProblemElementKind((int)problem.getCategory(), (int)problem.getElementKind()));
            element.setAttribute("category", ApiProblem.getProblemCategory((int)problem.getCategory()));
            element.setAttribute("severity", this.properties.getProperty(ApiProblemFactory.getProblemSeverityId((IApiProblem)problem)));
            element.setAttribute("kind", Integer.toString(problem.getKind()));
            element.setAttribute("flags", Integer.toString(problem.getFlags()));
            element.setAttribute("message", problem.getMessage());
            String[] extraMarkerAttributeIds = problem.getExtraMarkerAttributeIds();
            if (extraMarkerAttributeIds != null && extraMarkerAttributeIds.length != 0) {
                int length = extraMarkerAttributeIds.length;
                Object[] extraMarkerAttributeValues = problem.getExtraMarkerAttributeValues();
                Element extraArgumentsElement = document.createElement("extra_arguments");
                j = 0;
                while (j < length) {
                    Element extraArgumentElement = document.createElement("extra_argument");
                    extraArgumentElement.setAttribute("id", extraMarkerAttributeIds[j]);
                    extraArgumentElement.setAttribute("value", String.valueOf(extraMarkerAttributeValues[j]));
                    extraArgumentsElement.appendChild(extraArgumentElement);
                    ++j;
                }
                element.appendChild(extraArgumentsElement);
            }
            if ((messageArguments = problem.getMessageArguments()) != null && messageArguments.length != 0) {
                int length = messageArguments.length;
                Element messageArgumentsElement = document.createElement("message_arguments");
                j = 0;
                while (j < length) {
                    Element messageArgumentElement = document.createElement("message_argument");
                    messageArgumentElement.setAttribute("value", String.valueOf(messageArguments[j]));
                    messageArgumentsElement.appendChild(messageArgumentElement);
                    ++j;
                }
                element.appendChild(messageArgumentsElement);
            }
            apiProblems.appendChild(element);
        }
    }

    public void setDebug(boolean debugValue) {
        this.debug = debugValue;
    }

    public void setExcludeList(String excludeListLocation) {
        this.excludeListLocation = excludeListLocation;
    }

    public void setIncludeList(String includeListLocation) {
        this.includeListLocation = includeListLocation;
    }

    public void setPreferences(String preferencesLocation) {
        block15: {
            File preferencesFile = new File(preferencesLocation);
            if (!preferencesFile.exists()) {
                return;
            }
            BufferedInputStream inputStream = null;
            try {
                try {
                    inputStream = new BufferedInputStream(new FileInputStream(preferencesFile));
                    Properties temp = new Properties();
                    temp.load(inputStream);
                    this.properties = temp;
                }
                catch (IOException iOException) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setProfile(String baselineLocation) {
        this.currentBaselineLocation = baselineLocation;
    }

    public void setAPIUseScans(String apiUseScans) {
        this.apiUseScans = apiUseScans;
        this.usescans = apiUseScans.split(",");
    }

    public void setReport(String reportLocation) {
        this.reportLocation = reportLocation;
    }

    private static class Summary {
        String fComponentID;
        List<IApiProblem> fApiProblems;

        public Summary(String componentID, IApiProblem[] apiProblems) {
            this.fComponentID = componentID;
            this.fApiProblems = Arrays.asList(apiProblems);
        }
    }
}

