/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tasks;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.search.MigrationReportConvertor;
import org.eclipse.pde.api.tools.internal.tasks.CommonUtilsTask;
import org.eclipse.pde.api.tools.internal.tasks.Messages;
import org.eclipse.pde.api.tools.internal.util.Util;

public class ApiMigrationReportConversionTask
extends CommonUtilsTask {
    private String xmlReportsLocation = null;
    private String htmlReportsLocation = null;
    private String xsltFileLocation = null;
    private String[] filterPatterns = null;
    private String[] toPatterns = null;

    public void setDebug(String debugValue) {
        this.debug = Boolean.toString(true).equals(debugValue);
    }

    public void setHtmlFiles(String htmlFilesLocation) {
        this.htmlReportsLocation = htmlFilesLocation;
    }

    public void setXmlFiles(String xmlFilesLocation) {
        this.xmlReportsLocation = xmlFilesLocation;
    }

    public void setToFilterPatterns(String patterns) {
        this.toPatterns = this.parsePatterns(patterns);
    }

    public void setFilterPatterns(String patterns) {
        this.filterPatterns = this.parsePatterns(patterns);
    }

    public void setXSLTFile(String xsltFileLocation) {
        this.xsltFileLocation = xsltFileLocation;
    }

    public void execute() throws BuildException {
        if (this.debug) {
            System.out.println("XML report location: " + this.xmlReportsLocation);
            System.out.println("HTML report location: " + this.htmlReportsLocation);
            if (this.xsltFileLocation == null) {
                System.out.println("No XSLT file specified: using default");
            } else {
                System.out.println("XSLT file location: " + this.xsltFileLocation);
            }
        }
        try {
            Util.delete((File)new File(this.htmlReportsLocation));
            MigrationReportConvertor converter = new MigrationReportConvertor(this.htmlReportsLocation, this.xmlReportsLocation, this.toPatterns, this.filterPatterns);
            ApiPlugin.DEBUG_USE_REPORT_CONVERTER = this.debug;
            converter.convert(this.xsltFileLocation, null);
            File index = converter.getReportIndex();
            System.out.println(NLS.bind((String)Messages.ApiUseReportConversionTask_conversion_complete, (Object)index.getAbsolutePath()));
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

