/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tasks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.model.StubApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiComparator;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiScope;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaVisitor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiScope;
import org.eclipse.pde.api.tools.internal.tasks.CommonUtilsTask;
import org.eclipse.pde.api.tools.internal.tasks.FilterListDeltaVisitor;
import org.eclipse.pde.api.tools.internal.tasks.Messages;
import org.eclipse.pde.api.tools.internal.util.FilteredElements;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class APIFreezeTask
extends CommonUtilsTask {
    private boolean debug;
    private String eeFileLocation;
    private String excludeListLocation;
    private String includeListLocation;
    private boolean processUnresolvedBundles = true;
    private Map<String, ResolverError[]> resolverErrors = new HashMap<String, ResolverError[]>();

    public void execute() throws BuildException {
        IDelta delta;
        FilteredElements includedElements;
        FilteredElements excludedElements;
        long time;
        File outputFile;
        block52: {
            int index;
            if (this.referenceBaselineLocation == null || this.currentBaselineLocation == null || this.reportLocation == null) {
                StringWriter out = new StringWriter();
                PrintWriter writer = new PrintWriter(out);
                writer.println(NLS.bind((String)Messages.printArguments, (Object[])new String[]{this.referenceBaselineLocation, this.currentBaselineLocation, this.reportLocation}));
                writer.flush();
                writer.close();
                throw new BuildException(String.valueOf(out.getBuffer()));
            }
            if (this.debug) {
                System.out.println("reference : " + this.referenceBaselineLocation);
                System.out.println("baseline to compare : " + this.currentBaselineLocation);
                System.out.println("report location : " + this.reportLocation);
                if (this.excludeListLocation != null) {
                    System.out.println("exclude list location : " + this.excludeListLocation);
                } else {
                    System.out.println("No exclude list location");
                }
                if (this.includeListLocation != null) {
                    System.out.println("include list location : " + this.includeListLocation);
                } else {
                    System.out.println("No include list location");
                }
            }
            if ((outputFile = new File(this.reportLocation)).exists()) {
                if (outputFile.isDirectory()) {
                    throw new BuildException(NLS.bind((String)Messages.reportLocationHasToBeAFile, (Object)outputFile.getAbsolutePath()));
                }
            } else {
                File outputDir = outputFile.getParentFile();
                if (!outputDir.exists() && !outputDir.mkdirs()) {
                    throw new BuildException(NLS.bind((String)Messages.errorCreatingParentReportFile, (Object)outputDir.getAbsolutePath()));
                }
            }
            if ((index = this.reportLocation.lastIndexOf(46)) == -1 || !this.reportLocation.substring(index).toLowerCase().equals(".xml")) {
                throw new BuildException(Messages.deltaReportTask_xmlFileLocationShouldHaveAnXMLExtension);
            }
            time = 0L;
            if (this.debug) {
                time = System.currentTimeMillis();
            }
            File referenceInstallDir = this.extractSDK("referenceBaseline", this.referenceBaselineLocation);
            File baselineInstallDir = this.extractSDK("currentBaseline", this.currentBaselineLocation);
            if (this.debug) {
                System.out.println("Extraction of both archives : " + (System.currentTimeMillis() - time) + "ms");
                time = System.currentTimeMillis();
            }
            IApiBaseline referenceBaseline = this.createBaseline("reference_baseline", referenceInstallDir.getAbsolutePath(), this.eeFileLocation);
            IApiBaseline currentBaseline = this.createBaseline("current_baseline", baselineInstallDir.getAbsolutePath(), this.eeFileLocation);
            excludedElements = CommonUtilsTask.initializeFilteredElements(this.excludeListLocation, currentBaseline, this.debug);
            if (this.debug) {
                System.out.println("====================================================================================");
                System.out.println("Excluded elements list:");
                System.out.println(excludedElements);
            }
            includedElements = CommonUtilsTask.initializeFilteredElements(this.includeListLocation, currentBaseline, this.debug);
            if (this.debug) {
                System.out.println("====================================================================================");
                System.out.println("Included elements list:");
                System.out.println(includedElements);
            }
            delta = null;
            if (this.debug) {
                System.out.println("Creation of both baselines : " + (System.currentTimeMillis() - time) + "ms");
                time = System.currentTimeMillis();
            }
            try {
                try {
                    delta = ApiComparator.compare((IApiScope)this.getScope(currentBaseline), (IApiBaseline)referenceBaseline, (int)1, (boolean)true, (boolean)this.processUnresolvedBundles, null);
                }
                catch (CoreException coreException) {
                    if (this.debug) {
                        System.out.println("API freeze check : " + (System.currentTimeMillis() - time) + "ms");
                        time = System.currentTimeMillis();
                    }
                    referenceBaseline.dispose();
                    currentBaseline.dispose();
                    StubApiComponent.disposeAllCaches();
                    this.deleteBaseline(this.referenceBaselineLocation, referenceInstallDir);
                    this.deleteBaseline(this.currentBaselineLocation, baselineInstallDir);
                    if (this.debug) {
                        System.out.println("Cleanup : " + (System.currentTimeMillis() - time) + "ms");
                        time = System.currentTimeMillis();
                    }
                    break block52;
                }
            }
            catch (Throwable throwable) {
                if (this.debug) {
                    System.out.println("API freeze check : " + (System.currentTimeMillis() - time) + "ms");
                    time = System.currentTimeMillis();
                }
                referenceBaseline.dispose();
                currentBaseline.dispose();
                StubApiComponent.disposeAllCaches();
                this.deleteBaseline(this.referenceBaselineLocation, referenceInstallDir);
                this.deleteBaseline(this.currentBaselineLocation, baselineInstallDir);
                if (this.debug) {
                    System.out.println("Cleanup : " + (System.currentTimeMillis() - time) + "ms");
                    time = System.currentTimeMillis();
                }
                throw throwable;
            }
            if (this.debug) {
                System.out.println("API freeze check : " + (System.currentTimeMillis() - time) + "ms");
                time = System.currentTimeMillis();
            }
            referenceBaseline.dispose();
            currentBaseline.dispose();
            StubApiComponent.disposeAllCaches();
            this.deleteBaseline(this.referenceBaselineLocation, referenceInstallDir);
            this.deleteBaseline(this.currentBaselineLocation, baselineInstallDir);
            if (this.debug) {
                System.out.println("Cleanup : " + (System.currentTimeMillis() - time) + "ms");
                time = System.currentTimeMillis();
            }
        }
        if (delta == null) {
            throw new BuildException(Messages.errorInComparison);
        }
        if (delta != ApiComparator.NO_DELTA) {
            block53: {
                BufferedWriter writer = null;
                try {
                    String potentialExcludeList;
                    writer = new BufferedWriter(new FileWriter(outputFile));
                    FilterListDeltaVisitor visitor = new FilterListDeltaVisitor(excludedElements, includedElements, 2);
                    delta.accept((DeltaVisitor)visitor);
                    Document doc = visitor.getDocument();
                    if (this.processUnresolvedBundles) {
                        this.addResolverErrors(doc);
                    }
                    String serializedXml = Util.serializeDocument((Document)doc);
                    writer.write(serializedXml);
                    writer.flush();
                    if (this.debug && (potentialExcludeList = visitor.getPotentialExcludeList()).length() != 0) {
                        System.out.println("Potential exclude list:");
                        System.out.println(potentialExcludeList);
                    }
                }
                catch (IOException e) {
                    ApiPlugin.log((Throwable)e);
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        break block53;
                    }
                    catch (IOException iOException) {}
                    break block53;
                }
                catch (CoreException e) {
                    try {
                        ApiPlugin.log((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        break block53;
                    }
                    catch (IOException iOException) {}
                    break block53;
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (this.debug) {
                System.out.println("Report generation : " + (System.currentTimeMillis() - time) + "ms");
            }
        } else if (this.debug) {
            System.out.println("API freeze task complete.  No problems to report : " + (System.currentTimeMillis() - time) + "ms");
        }
    }

    private IApiScope getScope(IApiBaseline currentBaseline) {
        IApiComponent[] apiComponents = currentBaseline.getApiComponents();
        ApiScope scope = new ApiScope();
        int i = 0;
        int max = apiComponents.length;
        while (i < max) {
            block7: {
                IApiComponent apiComponent = apiComponents[i];
                try {
                    ResolverError[] errors = apiComponent.getErrors();
                    if (errors != null) {
                        if (this.debug) {
                            System.out.println("Resolver errors found for component : " + apiComponent.getSymbolicName());
                            int j = 0;
                            int max2 = errors.length;
                            while (j < max2) {
                                System.out.println(errors[j]);
                                ++j;
                            }
                        }
                        if (!this.processUnresolvedBundles) break block7;
                        this.resolverErrors.put(apiComponent.getSymbolicName(), errors);
                    }
                    scope.addElement((IApiElement)apiComponent);
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return scope;
    }

    public void setDebug(String debugValue) {
        this.debug = Boolean.toString(true).equals(debugValue);
    }

    public void setEEFile(String eeFileLocation) {
        this.eeFileLocation = eeFileLocation;
    }

    public void setExcludeList(String excludeListLocation) {
        this.excludeListLocation = excludeListLocation;
    }

    public void setIncludeList(String includeListLocation) {
        this.includeListLocation = includeListLocation;
    }

    public void setProfile(String baselineLocation) {
        this.currentBaselineLocation = baselineLocation;
    }

    public void setBaseline(String baselineLocation) {
        this.referenceBaselineLocation = baselineLocation;
    }

    public void setReport(String reportLocation) {
        this.reportLocation = reportLocation;
    }

    public void setProcessUnresolvedBundles(boolean processUnresolvedBundles) {
        this.processUnresolvedBundles = processUnresolvedBundles;
    }

    private void addResolverErrors(Document document) {
        if (this.resolverErrors != null && !this.resolverErrors.isEmpty()) {
            Element errorElement = document.createElement("resolver_errors");
            for (Map.Entry<String, ResolverError[]> entry : this.resolverErrors.entrySet()) {
                String componentID = entry.getKey();
                Element report = document.createElement("report");
                report.setAttribute("version", "1");
                report.setAttribute("componentID", componentID);
                errorElement.appendChild(report);
                ResolverError[] errors = entry.getValue();
                int j = 0;
                while (j < errors.length) {
                    Element error = document.createElement("resolver_error");
                    error.setAttribute("message", errors[j].toString());
                    report.appendChild(error);
                    ++j;
                }
            }
            NodeList rootNodes = document.getChildNodes();
            int i = 0;
            while (i < rootNodes.getLength()) {
                Node node = rootNodes.item(i);
                if (node.getNodeType() == 1) {
                    node.appendChild(errorElement);
                    break;
                }
                ++i;
            }
        }
    }
}

