/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers;

import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.AuthenticationControl;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers.VersionVerifier;
import org.eclipse.emf.emfstore.internal.server.connection.ServerKeyStoreManager;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.exceptions.ClientVersionOutOfDateException;
import org.eclipse.emf.emfstore.internal.server.exceptions.ServerKeyStoreException;
import org.eclipse.emf.emfstore.internal.server.model.AuthenticationInformation;
import org.eclipse.emf.emfstore.internal.server.model.ClientVersionInfo;
import org.eclipse.emf.emfstore.internal.server.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;

public abstract class AbstractAuthenticationControl
implements AuthenticationControl {
    private final String superuser = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.superuser", "super");
    private final String superuserpw = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.superuser.password", "super");

    public AuthenticationInformation logIn(ACUser resolvedUser, String username, String password, ClientVersionInfo clientVersionInfo) throws AccessControlException {
        this.checkClientVersion(clientVersionInfo);
        password = this.preparePassword(password);
        if (this.verifySuperUser(username, password) || this.verifyPassword(resolvedUser, username, password)) {
            return this.createAuthenticationInfo();
        }
        throw new AccessControlException();
    }

    protected AuthenticationInformation createAuthenticationInfo() {
        AuthenticationInformation authenticationInformation = ModelFactory.eINSTANCE.createAuthenticationInformation();
        authenticationInformation.setSessionId(ModelFactory.eINSTANCE.createSessionId());
        return authenticationInformation;
    }

    protected String preparePassword(String password) throws ServerKeyStoreException {
        return ServerKeyStoreManager.getInstance().decrypt(password);
    }

    protected boolean verifySuperUser(String username, String password) {
        return username.equals(this.superuser) && password.equals(this.superuserpw);
    }

    public void logout(SessionId sessionId) throws AccessControlException {
    }

    protected abstract boolean verifyPassword(ACUser var1, String var2, String var3) throws AccessControlException;

    protected void checkClientVersion(ClientVersionInfo clientVersionInfo) throws ClientVersionOutOfDateException {
        VersionVerifier.verify(ServerConfiguration.getSplittedProperty("emfstore.acceptedversions"), clientVersionInfo);
    }
}

