/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.internal.bridge.resolver.StructureResolver;
import org.eclipse.gmf.internal.bridge.ui.Plugin;
import org.eclipse.gmf.internal.bridge.wizards.Messages;
import org.eclipse.gmf.internal.bridge.wizards.WizardOperationMode;
import org.eclipse.gmf.internal.bridge.wizards.WizardUtil;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.DefinitionPage;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.DomainModelSelectionPage;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.DomainModelSourceImpl;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.StructureBuilder;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.ToolDefBuilder;
import org.eclipse.gmf.internal.common.URIUtil;
import org.eclipse.gmf.internal.common.ui.ModelSelectionPage;
import org.eclipse.gmf.internal.common.ui.ResourceLocationProvider;
import org.eclipse.gmf.tooldef.ToolRegistry;
import org.eclipse.gmf.tooldef.presentation.GMFToolModelWizard;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizardPage;

public class GMFToolSimpleModelWizard
extends GMFToolModelWizard {
    protected ModelSelectionPage toolingModelSelectionPage;
    protected DefinitionPage toolingDefinitionPage;
    protected WizardOperationMode mode = new WizardOperationMode("gmftool", "create");

    public void setMode(String mode) {
        this.mode.setMode(mode);
    }

    protected boolean isInReconcileMode() {
        return this.toolingModelSelectionPage != null && this.toolingModelSelectionPage.getResource() != null;
    }

    public boolean performFinish() {
        if (this.isInReconcileMode()) {
            this.reconcileModel();
            try {
                WizardUtil.saveModel(this.getContainer(), this.toolingModelSelectionPage.getResource());
            }
            catch (Exception exception) {
                Plugin.log(exception);
                return false;
            }
            IFile modelFile = this.getModelFile();
            if (modelFile != null) {
                WizardUtil.openEditor(modelFile);
            }
            return true;
        }
        return super.performFinish();
    }

    protected EObject createInitialModel() {
        ToolDefBuilder builder = new ToolDefBuilder(null);
        return builder.process(this.toolingDefinitionPage.getModel());
    }

    protected void reconcileModel() {
        ToolRegistry existingToolRegistry = null;
        for (EObject element : this.toolingModelSelectionPage.getResource().getContents()) {
            if (!(element instanceof ToolRegistry)) continue;
            existingToolRegistry = (ToolRegistry)element;
            break;
        }
        ToolDefBuilder builder = new ToolDefBuilder(existingToolRegistry);
        ToolRegistry toolRegistry = builder.process(this.toolingDefinitionPage.getModel());
        if (toolRegistry != null && existingToolRegistry != toolRegistry) {
            this.toolingModelSelectionPage.getResource().getContents().add((Object)toolRegistry);
        }
    }

    public void addPages() {
        ResourceLocationProvider rloc = new ResourceLocationProvider((ISelection)this.selection);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        if (this.mode.detectReconcile(rloc)) {
            this.toolingModelSelectionPage = new ModelSelectionPage("ToolingModelSelectionPage", rloc, (ResourceSet)resourceSet, "gmftool");
            this.toolingModelSelectionPage.setPageComplete(false);
            this.toolingModelSelectionPage.setModelRequired(true);
            this.toolingModelSelectionPage.setTitle(Messages.SimpleModelWizardToolModelSelectionPageTitle);
            this.toolingModelSelectionPage.setDescription(Messages.SimpleModelWizardToolModelSelectionPageDesc);
            this.addPage((IWizardPage)this.toolingModelSelectionPage);
        } else {
            Object selected;
            super.addPages();
            if (this.selection != null && !this.selection.isEmpty() && (selected = this.selection.getFirstElement()) instanceof IFile) {
                this.newFileCreationPage.setFileName(WizardUtil.getDefaultFileName((IFile)selected, "gmftool"));
            }
        }
        DomainModelSelectionPage domainModelSelectionPage = new DomainModelSelectionPage("DomainModelSelectionPage", rloc, (ResourceSet)resourceSet);
        domainModelSelectionPage.setTitle(Messages.SimpleModelWizardDomainModelSelectionPageTitle);
        domainModelSelectionPage.setDescription(Messages.SimpleModelWizardDomainModelSelectionPageDesc);
        this.addPage((IWizardPage)domainModelSelectionPage);
        this.toolingDefinitionPage = new DefinitionPage("ToolingDefinitionPage", new StructureBuilder(new StructureResolver(), false), domainModelSelectionPage){

            @Override
            protected DomainModelSourceImpl createDomainModelSource(EPackage contents, EClass diagramElement) {
                if (GMFToolSimpleModelWizard.this.isInReconcileMode()) {
                    return new DomainModelSourceImpl(contents, diagramElement){

                        @Override
                        public boolean isDisabled(EObject domainElement) {
                            return ToolDefBuilder.getCreationTool((Iterator<EObject>)(this).GMFToolSimpleModelWizard.this.toolingModelSelectionPage.getResource().getAllContents(), domainElement) != null;
                        }
                    };
                }
                return super.createDomainModelSource(contents, diagramElement);
            }
        };
        this.toolingDefinitionPage.setTitle(Messages.SimpleModelWizardToolDefinitionPageTitle);
        this.toolingDefinitionPage.setDescription(Messages.SimpleModelWizardToolDefinitionPageDesc);
        this.addPage((IWizardPage)this.toolingDefinitionPage);
    }

    public IFile getModelFile() {
        if (this.isInReconcileMode()) {
            return URIUtil.getFile((URI)this.toolingModelSelectionPage.getResource().getURI());
        }
        return super.getModelFile();
    }
}

