/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.util;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.util.GraphicsUtil;
import org.eclipse.nebula.visualization.xygraph.util.SingleSourceHelper2;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;

public class SingleSourceHelperImpl
extends SingleSourceHelper2 {
    @Override
    protected Cursor createInternalCursor(Display display, ImageData imageData, int width, int height, int style) {
        Cursor cursor = GraphicsUtil.createCursor((Device)display, imageData, width, height);
        XYGraphMediaFactory.getInstance().registerCursor(cursor.toString(), cursor);
        return cursor;
    }

    @Override
    protected Image createInternalVerticalTextImage(String text, Font font, RGB color, boolean upToDown) {
        Dimension titleSize = FigureUtilities.getTextExtents((String)text, (Font)font);
        int w = titleSize.height;
        int h = titleSize.width + 1;
        Image image = new Image((Device)Display.getCurrent(), w, h);
        GC gc = GraphicsUtil.createGC((Drawable)image);
        Color titleColor = new Color((Device)Display.getCurrent(), color);
        RGB transparentRGB = new RGB(240, 240, 240);
        gc.setBackground(XYGraphMediaFactory.getInstance().getColor(transparentRGB));
        gc.fillRectangle(image.getBounds());
        gc.setForeground(titleColor);
        gc.setFont(font);
        Transform tr = new Transform((Device)Display.getCurrent());
        if (!upToDown) {
            tr.translate(0.0f, (float)h);
            tr.rotate(-90.0f);
            GraphicsUtil.setTransform(gc, tr);
        } else {
            tr.translate((float)w, 0.0f);
            tr.rotate(90.0f);
            GraphicsUtil.setTransform(gc, tr);
        }
        gc.drawText(text, 0, 0);
        tr.dispose();
        gc.dispose();
        ImageData imageData = image.getImageData();
        image.dispose();
        titleColor.dispose();
        imageData.transparentPixel = imageData.palette.getPixel(transparentRGB);
        image = new Image((Device)Display.getCurrent(), imageData);
        return image;
    }

    @Override
    protected Image getInternalXYGraphSnapShot(IXYGraph xyGraph) {
        Rectangle bounds = xyGraph.getBounds();
        Image image = new Image(null, bounds.width + 6, bounds.height + 6);
        GC gc = GraphicsUtil.createGC((Drawable)image);
        SWTGraphics graphics = new SWTGraphics(gc);
        graphics.setClip(new Rectangle(0, 0, image.getBounds().width, image.getBounds().height));
        graphics.translate(-bounds.x + 3, -bounds.y + 3);
        graphics.setForegroundColor(xyGraph.getForegroundColor());
        graphics.setBackgroundColor(xyGraph.getBackgroundColor());
        xyGraph.paint((Graphics)graphics);
        gc.dispose();
        return image;
    }

    @Override
    protected String getInternalImageSavePath() {
        FileDialog dialog = new FileDialog(Display.getDefault().getShells()[0], 8192);
        dialog.setFilterNames(new String[]{"PNG Files", "All Files (*.*)"});
        dialog.setFilterExtensions(new String[]{"*.png", "*.*"});
        String path = dialog.open();
        return path;
    }

    @Override
    protected GC internalGetImageGC(Image image) {
        return GraphicsUtil.createGC((Drawable)image);
    }

    @Override
    protected void internalSetLineStyle_LINE_SOLID(Graphics graphics) {
        graphics.setLineStyle(1);
    }
}

