/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.internal.xygraph.undo;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.visualization.internal.xygraph.undo.IOperationsManagerListener;
import org.eclipse.nebula.visualization.internal.xygraph.undo.IUndoableCommand;
import org.eclipse.nebula.visualization.internal.xygraph.undo.SizeLimitedStack;

public class OperationsManager {
    private SizeLimitedStack<IUndoableCommand> undoStack = new SizeLimitedStack(30);
    private SizeLimitedStack<IUndoableCommand> redoStack = new SizeLimitedStack(30);
    private List<IOperationsManagerListener> listeners = new ArrayList<IOperationsManagerListener>();

    public void addCommand(IUndoableCommand command) {
        this.undoStack.push(command);
        this.redoStack.clear();
        this.fireOperationsHistoryChanged();
    }

    public void undoCommand(IUndoableCommand command) {
        IUndoableCommand temp;
        do {
            temp = this.undoStack.pop();
            temp.undo();
            this.redoStack.push(temp);
        } while (temp != command);
        this.fireOperationsHistoryChanged();
    }

    public void redoCommand(IUndoableCommand command) {
        IUndoableCommand temp;
        do {
            temp = this.redoStack.pop();
            temp.redo();
            this.undoStack.push(temp);
        } while (temp != command);
        this.fireOperationsHistoryChanged();
    }

    public void undo() {
        if (this.undoStack.size() > 0) {
            this.undoCommand(this.undoStack.peek());
        }
    }

    public void redo() {
        if (this.redoStack.size() > 0) {
            this.redoCommand(this.redoStack.peek());
        }
    }

    public Object[] getUndoCommands() {
        return this.undoStack.toArray();
    }

    public Object[] getRedoCommands() {
        return this.redoStack.toArray();
    }

    public void addListener(IOperationsManagerListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(IOperationsManagerListener listener) {
        return this.listeners.remove(listener);
    }

    private void fireOperationsHistoryChanged() {
        for (IOperationsManagerListener listener : this.listeners) {
            listener.operationsHistoryChanged(this);
        }
    }

    public int getUndoCommandsSize() {
        return this.undoStack.size();
    }

    public int getRedoCommandsSize() {
        return this.redoStack.size();
    }
}

