/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.figureparts;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.widgets.figureparts.PolarPoint;
import org.eclipse.nebula.visualization.widgets.figureparts.RoundScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.AbstractScale;
import org.eclipse.swt.graphics.Font;

public class RoundScaleTickLabels
extends Figure {
    private ArrayList<Double> tickLabelValues;
    private ArrayList<String> tickLabels;
    private ArrayList<Double> tickLabelPositions;
    private ArrayList<Boolean> tickLabelVisibilities;
    private ArrayList<Rectangle> tickLabelAreas;
    private int tickLabelMaxOutLength;
    private double gridStepInRadians;
    private RoundScale scale;

    protected RoundScaleTickLabels(RoundScale scale) {
        this.scale = scale;
        this.tickLabelValues = new ArrayList();
        this.tickLabels = new ArrayList();
        this.tickLabelPositions = new ArrayList();
        this.tickLabelVisibilities = new ArrayList();
        this.tickLabelAreas = new ArrayList();
        this.setFont(scale.getFont());
        this.setForegroundColor(scale.getForegroundColor());
    }

    public double getGridStepInRadians() {
        return this.gridStepInRadians;
    }

    public int getTickLabelMaxOutLength() {
        return this.tickLabelMaxOutLength;
    }

    public ArrayList<Double> getTickLabelPositions() {
        return this.tickLabelPositions;
    }

    public ArrayList<Boolean> getTickVisibilities() {
        return this.tickLabelVisibilities;
    }

    private void drawTickLabels(Graphics graphics) {
        graphics.setFont(this.scale.getFont());
        int i = 0;
        while (i < this.tickLabelPositions.size()) {
            if (this.tickLabelVisibilities.get(i).booleanValue()) {
                String text = this.tickLabels.get(i);
                graphics.drawText(text, this.tickLabelAreas.get((int)i).x, this.tickLabelAreas.get((int)i).y);
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private double getGridStep(int lengthInPixels, double minR, double maxR) {
        block24: {
            if ((int)this.scale.getMajorGridStep() != 0) {
                return this.scale.getMajorGridStep();
            }
            min = minR;
            max = maxR;
            if (lengthInPixels <= 0) {
                lengthInPixels = 1;
            }
            minBigger = false;
            if (min >= max) {
                if (max == min) {
                    max += 1.0;
                } else {
                    minBigger = true;
                    swap = min;
                    min = max;
                    max = swap;
                }
            }
            length = Math.abs(max - min);
            markStepHint = this.scale.getMajorTickMarkStepHint();
            if (markStepHint > (double)lengthInPixels) {
                markStepHint = lengthInPixels;
            }
            gridStepHint = length / (double)lengthInPixels * markStepHint;
            if (this.scale.isDateEnabled()) {
                timeStep = 60000L;
                if (this.scale.getTimeUnit() == 13) {
                    timeStep = 1000L;
                } else if (this.scale.getTimeUnit() == 12) {
                    timeStep = 60000L;
                } else if (this.scale.getTimeUnit() == 11) {
                    timeStep = 3600000L;
                } else if (this.scale.getTimeUnit() == 5) {
                    timeStep = 86400000L;
                } else if (this.scale.getTimeUnit() == 2) {
                    timeStep = 2592000000L;
                } else if (this.scale.getTimeUnit() == 1) {
                    timeStep = 31536000000L;
                }
                temp = gridStepHint + ((double)timeStep - gridStepHint % (double)timeStep);
                return temp;
            }
            mantissa = gridStepHint;
            exp = 0;
            if (!(mantissa < 1.0)) ** GOTO lbl53
            if (mantissa == 0.0) break block24;
            while (mantissa < 1.0) {
                mantissa *= 10.0;
                --exp;
            }
            break block24;
lbl-1000:
            // 1 sources

            {
                mantissa /= 10.0;
                ++exp;
lbl53:
                // 2 sources

                ** while (mantissa >= 10.0)
            }
        }
        gridStep = mantissa > 7.5 ? 10.0 * Math.pow(10.0, exp) : (mantissa > 3.5 ? 5.0 * Math.pow(10.0, exp) : (mantissa > 1.5 ? 2.0 * Math.pow(10.0, exp) : Math.pow(10.0, exp)));
        if (minBigger) {
            gridStep = -gridStep;
        }
        return gridStep;
    }

    private boolean hasSpaceToDraw(Rectangle previousLabelArea, Rectangle labelArea) {
        return labelArea.getIntersection(previousLabelArea).isEmpty();
    }

    private boolean isMajorTick(double tickValue) {
        if (!this.scale.isLogScaleEnabled()) {
            return true;
        }
        double log10 = Math.log10(tickValue);
        return log10 == Math.rint(log10);
    }

    private BigDecimal pow(double base, int expornent) {
        BigDecimal value = expornent > 0 ? new BigDecimal(new Double(base).toString()).pow(expornent) : BigDecimal.ONE.divide(new BigDecimal(new Double(base).toString()).pow(-expornent));
        return value;
    }

    private void updateTickLabelAreas() {
        this.tickLabelAreas.clear();
        int i = 0;
        while (i < this.tickLabelPositions.size()) {
            Dimension ls = FigureUtilities.getTextExtents((String)this.tickLabels.get(i), (Font)this.scale.getFont());
            int labelRadius = this.scale.getTickLabelSide() == AbstractScale.LabelSide.Primary ? (int)((double)(this.scale.getRadius() + 8 + 1) + (double)ls.width / 2.0 * Math.abs(Math.cos(this.tickLabelPositions.get(i))) + (double)ls.height / 2.0 * Math.abs(Math.sin(this.tickLabelPositions.get(i)))) : (int)((double)(this.scale.getRadius() - 8 - 1) - (double)ls.width / 2.0 * Math.abs(Math.cos(this.tickLabelPositions.get(i))) - (double)ls.height / 2.0 * Math.abs(Math.sin(this.tickLabelPositions.get(i))));
            Point lp = new PolarPoint(labelRadius, this.tickLabelPositions.get(i)).toRelativePoint(this.scale.getBounds());
            this.tickLabelAreas.add(new Rectangle(lp.x - ls.width / 2, lp.y - ls.height / 2, ls.width, ls.height));
            ++i;
        }
    }

    private void updateTickLabelForLinearScale(double lengthInDegrees, int lengthInPixels) {
        double min = this.scale.getRange().getLower();
        double max = this.scale.getRange().getUpper();
        boolean minBigger = max < min;
        double tickStep = this.getGridStep(lengthInPixels, min, max);
        this.gridStepInRadians = lengthInDegrees * (Math.PI / 180) * tickStep / (max - min);
        double firstPosition = min % tickStep <= 0.0 ? min - min % tickStep : min - min % tickStep + tickStep;
        if (min > firstPosition == minBigger) {
            this.tickLabelValues.add(min);
            if (this.scale.isDateEnabled()) {
                Date date = new Date((long)min);
                this.tickLabels.add(this.scale.format(date));
            } else {
                this.tickLabels.add(this.scale.format(min));
            }
            this.tickLabelPositions.add(this.scale.getStartAngle() * Math.PI / 180.0);
        }
        double b = firstPosition;
        while (!(max >= min ? !(b <= max) : !(b >= max))) {
            if (this.scale.isDateEnabled()) {
                Date date = new Date((long)b);
                this.tickLabels.add(this.scale.format(date));
            } else {
                this.tickLabels.add(this.scale.format(b));
            }
            this.tickLabelValues.add(b);
            double tickLabelPosition = this.scale.getStartAngle() - (b - min) / (max - min) * lengthInDegrees;
            tickLabelPosition = tickLabelPosition * Math.PI / 180.0;
            this.tickLabelPositions.add(tickLabelPosition);
            b += tickStep;
        }
        if (minBigger ? max < this.tickLabelValues.get(this.tickLabelValues.size() - 1) : max > this.tickLabelValues.get(this.tickLabelValues.size() - 1)) {
            this.tickLabelValues.add(max);
            if (this.scale.isDateEnabled()) {
                Date date = new Date((long)max);
                this.tickLabels.add(this.scale.format(date));
            } else {
                this.tickLabels.add(this.scale.format(max));
            }
            this.tickLabelPositions.add((this.scale.getStartAngle() - lengthInDegrees) * Math.PI / 180.0);
        }
    }

    private void updateTickLabelForLogScale(double lengthInDegrees) {
        BigDecimal tickStep;
        BigDecimal minDec;
        double min = this.scale.getRange().getLower();
        double max = this.scale.getRange().getUpper();
        if (min <= 0.0 || max <= 0.0) {
            throw new IllegalArgumentException("the range for log scale must be in positive range");
        }
        boolean minBigger = max < min;
        double minLog = Math.log10(min);
        int minLogDigit = (int)Math.ceil(minLog);
        int maxLogDigit = (int)Math.ceil(Math.log10(max));
        BigDecimal firstPosition = (minDec = new BigDecimal(new Double(min).toString())).remainder(tickStep = this.pow(10.0, minLogDigit - 1)).doubleValue() <= 0.0 ? minDec.subtract(minDec.remainder(tickStep)) : (minBigger ? minDec.subtract(minDec.remainder(tickStep)) : minDec.subtract(minDec.remainder(tickStep)).add(tickStep));
        if (minDec.compareTo(firstPosition) == (minBigger ? 1 : -1)) {
            this.tickLabelValues.add(min);
            if (this.scale.isDateEnabled()) {
                Date date = new Date((long)minDec.doubleValue());
                this.tickLabels.add(this.scale.format(date));
            } else {
                this.tickLabels.add(this.scale.format(minDec.doubleValue()));
            }
            this.tickLabelPositions.add(this.scale.getStartAngle() * Math.PI / 180.0);
        }
        int i = minLogDigit;
        while (!(minBigger ? i < maxLogDigit : i > maxLogDigit)) {
            double tickLabelPosition;
            if (Math.abs(maxLogDigit - minLogDigit) > 20) {
                BigDecimal v = this.pow(10.0, i);
                if (v.doubleValue() > max) break;
                if (this.scale.isDateEnabled()) {
                    Date date = new Date((long)v.doubleValue());
                    this.tickLabels.add(this.scale.format(date));
                } else {
                    this.tickLabels.add(this.scale.format(v.doubleValue()));
                }
                this.tickLabelValues.add(v.doubleValue());
                tickLabelPosition = this.scale.getStartAngle() - (Math.log10(v.doubleValue()) - minLog) / (Math.log10(max) - minLog) * lengthInDegrees;
                tickLabelPosition = tickLabelPosition * Math.PI / 180.0;
                this.tickLabelPositions.add(tickLabelPosition);
            } else {
                BigDecimal j = firstPosition;
                while (!(minBigger ? !(j.doubleValue() >= this.pow(10.0, i - 1).doubleValue()) : !(j.doubleValue() <= this.pow(10.0, i).doubleValue()))) {
                    if (!minBigger ? j.doubleValue() > max : j.doubleValue() < max) break;
                    if (this.scale.isDateEnabled()) {
                        Date date = new Date(j.longValue());
                        this.tickLabels.add(this.scale.format(date));
                    } else {
                        this.tickLabels.add(this.scale.format(j.doubleValue()));
                    }
                    this.tickLabelValues.add(j.doubleValue());
                    tickLabelPosition = this.scale.getStartAngle() - (Math.log10(j.doubleValue()) - minLog) / (Math.log10(max) - minLog) * lengthInDegrees;
                    tickLabelPosition = tickLabelPosition * Math.PI / 180.0;
                    this.tickLabelPositions.add(tickLabelPosition);
                    BigDecimal bigDecimal = j = minBigger ? j.subtract(tickStep) : j.add(tickStep);
                }
                tickStep = minBigger ? tickStep.divide(this.pow(10.0, 1)) : tickStep.multiply(this.pow(10.0, 1));
                firstPosition = minBigger ? this.pow(10.0, i - 1) : tickStep.add(this.pow(10.0, i));
            }
            i += minBigger ? -1 : 1;
        }
        if (max > this.tickLabelValues.get(this.tickLabelValues.size() - 1)) {
            this.tickLabelValues.add(max);
            if (this.scale.isDateEnabled()) {
                Date date = new Date((long)max);
                this.tickLabels.add(this.scale.format(date));
            } else {
                this.tickLabels.add(this.scale.format(max));
            }
            this.tickLabelPositions.add(this.scale.getEndAngle() * Math.PI / 180.0);
        }
    }

    private void updateTickLabelMaxOutLength() {
        int minLeft = 0;
        int maxRight = 0;
        int minUp = 0;
        int maxDown = 0;
        for (Rectangle rect : this.tickLabelAreas) {
            if (rect.x < minLeft) {
                minLeft = rect.x;
            }
            if (rect.x + rect.width > maxRight) {
                maxRight = rect.x + rect.width;
            }
            if (rect.y < minUp) {
                minUp = rect.y;
            }
            if (rect.y + rect.height <= maxDown) continue;
            maxDown = rect.y + rect.height;
        }
        this.tickLabelMaxOutLength = Math.max(Math.max(maxRight - this.scale.getBounds().width, -minLeft), Math.max(maxDown - this.scale.getBounds().height, -minUp));
    }

    private void updateTickLabelVisibility() {
        this.tickLabelVisibilities.clear();
        if (this.tickLabelPositions.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.tickLabelPositions.size()) {
            this.tickLabelVisibilities.add(Boolean.TRUE);
            ++i;
        }
        Rectangle previousArea = this.tickLabelAreas.get(0);
        String previousLabel = null;
        int i2 = 0;
        while (i2 < this.tickLabelPositions.size()) {
            String currentLabel;
            boolean hasSpaceToDraw = true;
            if (i2 != 0) {
                hasSpaceToDraw = i2 != this.tickLabelPositions.size() - 1 ? this.hasSpaceToDraw(previousArea, this.tickLabelAreas.get(i2)) && this.hasSpaceToDraw(this.tickLabelAreas.get(i2), this.tickLabelAreas.get(this.tickLabelPositions.size() - 1)) : this.hasSpaceToDraw(previousArea, this.tickLabelAreas.get(i2)) && this.hasSpaceToDraw(this.tickLabelAreas.get(0), this.tickLabelAreas.get(i2));
            }
            boolean isRepeatSameTickAndNotEnd = (currentLabel = this.tickLabels.get(i2)).equals(previousLabel) && i2 != 0 && i2 != this.tickLabelPositions.size() - 1;
            previousLabel = currentLabel;
            boolean isMajorTickOrEnd = true;
            if (this.scale.isLogScaleEnabled()) {
                boolean bl = isMajorTickOrEnd = this.isMajorTick(this.tickLabelValues.get(i2)) || i2 == 0 || i2 == this.tickLabelPositions.size() - 1;
            }
            if (!hasSpaceToDraw || isRepeatSameTickAndNotEnd || !isMajorTickOrEnd) {
                this.tickLabelVisibilities.set(i2, Boolean.FALSE);
            } else {
                previousArea = this.tickLabelAreas.get(i2);
            }
            ++i2;
        }
    }

    protected void paintClientArea(Graphics graphics) {
        graphics.translate(this.bounds.x, this.bounds.y);
        this.drawTickLabels(graphics);
        super.paintClientArea(graphics);
    }

    protected void update(double lengthInDegrees, int lengthInPixels) {
        this.tickLabelValues.clear();
        this.tickLabels.clear();
        this.tickLabelPositions.clear();
        if (this.scale.isLogScaleEnabled()) {
            this.updateTickLabelForLogScale(lengthInDegrees);
        } else {
            this.updateTickLabelForLinearScale(lengthInDegrees, lengthInPixels);
        }
        this.updateTickLabelAreas();
        this.updateTickLabelMaxOutLength();
        this.updateTickLabelVisibility();
    }
}

