/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.process;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.IChromatogramSelectionProcessSupplier;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.supplier.AbstractProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionContext;
import org.eclipse.chemclipse.xxd.process.ProcessConfiguration;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class ProcessProcessTypeSupplier
implements IProcessTypeSupplier {
    public String getCategory() {
        return "External Programs";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        return Collections.singleton(new ProcessProcessSupplier(this));
    }

    private static final class ProcessProcessSupplier
    extends AbstractProcessSupplier<ProcessConfiguration>
    implements IChromatogramSelectionProcessSupplier<ProcessConfiguration> {
        public ProcessProcessSupplier(IProcessTypeSupplier parent) {
            super("org.eclipse.chemclipse.xxd.process.ProcessProcessTypeSupplier.ProcessProcessSupplier", "Execute Operating System Command", "Executes an arbitrary native operation system command", ProcessConfiguration.class, parent, new DataCategory[]{DataCategory.MSD, DataCategory.WSD, DataCategory.CSD});
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, ProcessConfiguration processSettings, ProcessExecutionContext context) throws InterruptedException {
            block10: {
                if (processSettings == null) {
                    processSettings = new ProcessConfiguration();
                }
                ProcessBuilder processBuilder = this.getProcessBuilder(chromatogramSelection, processSettings);
                try {
                    Process process = processBuilder.start();
                    ExecutorService executor = Executors.newSingleThreadExecutor();
                    try {
                        Future<String> processOutput = executor.submit(() -> IOUtils.toString((InputStream)process.getInputStream(), (Charset)Charset.defaultCharset()));
                        if (process.waitFor(processSettings.getTimeout(), processSettings.getTimeoutUnit())) {
                            try {
                                String output = processOutput.get();
                                int exitValue = process.exitValue();
                                if (exitValue == processSettings.getSuccessCode()) {
                                    context.addMessage(this.getName(), "Executed sucessfull", output, null, MessageType.INFO);
                                    break block10;
                                }
                                context.addMessage(this.getName(), "Execution failed with code " + exitValue, output, null, MessageType.ERROR);
                            }
                            catch (ExecutionException e) {
                                context.addErrorMessage(this.getDescription(), "Fetching process output failed", (Throwable)e);
                            }
                            break block10;
                        }
                        process.destroyForcibly();
                        context.addErrorMessage(this.getName(), "Timeout elapsed");
                    }
                    finally {
                        executor.shutdownNow();
                    }
                }
                catch (IOException e) {
                    context.addErrorMessage(this.getDescription(), "Ecxecution of " + processSettings.getCommand() + " failed", (Throwable)e);
                }
            }
            return chromatogramSelection;
        }

        private ProcessBuilder getProcessBuilder(IChromatogramSelection<?, ?> chromatogramSelection, ProcessConfiguration processSettings) {
            String chromatogramName = chromatogramSelection.getChromatogram().getName();
            String command = processSettings.getCommand();
            StringTokenizer st = new StringTokenizer(command);
            ArrayList<String> commands = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                commands.add(st.nextToken().replace("{chromatogram_name}", chromatogramName));
            }
            return new ProcessBuilder(commands).directory(processSettings.getWorkingDirectory()).redirectErrorStream(true);
        }
    }
}

