/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.process;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.eclipse.chemclipse.support.settings.FileSettingProperty;
import org.eclipse.chemclipse.support.settings.SystemSettings;
import org.eclipse.chemclipse.support.settings.SystemSettingsStrategy;

@SystemSettings(value=SystemSettingsStrategy.NONE)
public class ProcessConfiguration {
    public static final String VARIABLE_CHROMATOGRAM_NAME = "{chromatogram_name}";
    @JsonProperty(value="Working Directory")
    @FileSettingProperty(onlyDirectory=true)
    private File workingDirectory;
    @JsonProperty(value="Command", defaultValue="")
    @JsonPropertyDescription(value="the system command to execute, the follwoing variables might be used: {chromatogram_name}")
    private String command = "";
    @JsonProperty(value="Sucess Exit Code", defaultValue="0")
    @JsonPropertyDescription(value="The exit code that is returned when the program was sucessfull")
    private int successCode = 0;
    @JsonProperty(value="Timeout", defaultValue="30")
    private long timeout = 30L;
    @JsonProperty(value="Unit", defaultValue="SECONDS")
    private TimeUnit timeoutUnit = TimeUnit.SECONDS;

    public ProcessConfiguration() {
        this.workingDirectory = new File(System.getProperty("java.io.tmpdir"));
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public int getSuccessCode() {
        return this.successCode;
    }

    public void setSuccessCode(int successCode) {
        this.successCode = successCode;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    public void setTimeoutUnit(TimeUnit timeoutUnit) {
        this.timeoutUnit = timeoutUnit;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

