/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.model.filter.peaks;

import java.util.Collection;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.filter.IPeakFilter;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.Processor;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.filter.CRUDListener;
import org.eclipse.chemclipse.processing.filter.Filter;
import org.eclipse.chemclipse.xxd.model.filter.peaks.MinimumNumberOfIonsFilterSettings;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IPeakFilter.class, Filter.class, Processor.class})
public class MinimumNumberOfIonsFilter
implements IPeakFilter<MinimumNumberOfIonsFilterSettings> {
    public String getName() {
        return "Minimum Number of m/z Filter";
    }

    public String getDescription() {
        return "Filter peaks that are below a given number of ions in the m/z";
    }

    public Class<MinimumNumberOfIonsFilterSettings> getConfigClass() {
        return MinimumNumberOfIonsFilterSettings.class;
    }

    public <X extends IPeak> void filterIPeaks(CRUDListener<X, IPeakModel> listener, MinimumNumberOfIonsFilterSettings configuration, MessageConsumer messageConsumer, IProgressMonitor monitor) throws IllegalArgumentException {
        Collection read = listener.read();
        if (configuration == null) {
            configuration = (MinimumNumberOfIonsFilterSettings)this.createConfiguration(read);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)read.size());
        int minIons = configuration.getMinNumberOfIons();
        for (IPeak peak : read) {
            if (peak instanceof IPeakMSD) {
                IPeakMassSpectrum massSpectrum = ((IPeakMSD)peak).getExtractedMassSpectrum();
                if (massSpectrum.getIons().size() < minIons) {
                    listener.delete((Object)peak);
                }
            } else {
                throw new IllegalArgumentException("invalid peak");
            }
            subMonitor.worked(1);
        }
    }

    public boolean acceptsIPeaks(Collection<? extends IPeak> items) {
        for (IPeak iPeak : items) {
            if (iPeak instanceof IPeakMSD) continue;
            return false;
        }
        return true;
    }

    public DataCategory[] getDataCategories() {
        return new DataCategory[]{DataCategory.MSD};
    }
}

