/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.model.filter.peaks;

import java.util.Collection;
import java.util.Set;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.filter.IPeakFilter;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.processing.Processor;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.filter.CRUDListener;
import org.eclipse.chemclipse.processing.filter.Filter;
import org.eclipse.chemclipse.xxd.model.filter.peaks.DisableClassifiedPeaksFilterConfig;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IPeakFilter.class, Filter.class, Processor.class})
public class DisableClassifiedPeaksFilter
implements IPeakFilter<DisableClassifiedPeaksFilterConfig> {
    public String getName() {
        return "Disable classified peaks";
    }

    public String getDescription() {
        return "Disables peaks with a given classification";
    }

    public Class<DisableClassifiedPeaksFilterConfig> getConfigClass() {
        return DisableClassifiedPeaksFilterConfig.class;
    }

    public <X extends IPeak> void filterIPeaks(CRUDListener<X, IPeakModel> listener, DisableClassifiedPeaksFilterConfig configuration, MessageConsumer messageConsumer, IProgressMonitor monitor) throws IllegalArgumentException {
        Collection read = listener.read();
        if (configuration == null) {
            configuration = (DisableClassifiedPeaksFilterConfig)this.createConfiguration(read);
        }
        Set<String> classifications = configuration.getClassificationSet();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)read.size());
        for (IPeak peak : read) {
            ILibraryInformation information;
            Set targets = peak.getTargets();
            IIdentificationTarget target = IIdentificationTarget.getBestIdentificationTarget((Set)targets);
            if (target != null && (information = target.getLibraryInformation()) != null) {
                boolean disable;
                if (classifications.isEmpty()) {
                    disable = information.getClassifier().size() > 0;
                } else {
                    disable = false;
                    for (String classifier : information.getClassifier()) {
                        if (!classifications.contains(classifier)) continue;
                        disable = true;
                        break;
                    }
                }
                if (disable) {
                    peak.setActiveForAnalysis(false);
                    listener.updated((Object)peak);
                }
            }
            subMonitor.worked(1);
        }
    }

    public boolean acceptsIPeaks(Collection<? extends IPeak> items) {
        return true;
    }
}

