/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.converter.supplier.jcampdx.converter;

import java.io.File;
import org.eclipse.chemclipse.converter.chromatogram.AbstractChromatogramExportConverter;
import org.eclipse.chemclipse.converter.chromatogram.IChromatogramExportConverter;
import org.eclipse.chemclipse.csd.converter.supplier.jcampdx.io.ChromatogramWriter;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.xxd.converter.supplier.jcampdx.internal.converter.SpecificationValidator;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramExportConverter
extends AbstractChromatogramExportConverter
implements IChromatogramExportConverter {
    private static final Logger logger = Logger.getLogger(ChromatogramExportConverter.class);
    private static final String DESCRIPTION = "JCAMP-DX Export Converter";

    public IProcessingInfo convert(File file, IChromatogram<? extends IPeak> chromatogram, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = super.validate(file = SpecificationValidator.validateSpecification(file, "JDX"));
        if (!processingInfo.hasErrorMessages() && chromatogram instanceof IChromatogramCSD) {
            IChromatogramCSD chromatogramCSD = (IChromatogramCSD)chromatogram;
            ChromatogramWriter writer = new ChromatogramWriter();
            monitor.subTask("Export Chromatogram");
            try {
                writer.writeChromatogram(file, chromatogramCSD, monitor);
                processingInfo.setProcessingResult((Object)file);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "Something has definitely gone wrong with the file: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }
}

