/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.quantitation;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.RetentionIndexType;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.quantitation.IQuantitationCompound;
import org.eclipse.chemclipse.model.quantitation.IQuantitationDatabase;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.model.quantitation.IQuantitationPeak;
import org.eclipse.chemclipse.model.quantitation.IQuantitationSignal;
import org.eclipse.chemclipse.model.quantitation.IQuantitationSignals;
import org.eclipse.chemclipse.model.quantitation.IResponseSignal;
import org.eclipse.chemclipse.model.quantitation.IResponseSignals;
import org.eclipse.chemclipse.model.quantitation.IRetentionIndexWindow;
import org.eclipse.chemclipse.model.quantitation.IRetentionTimeWindow;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonTransition;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.IRegularMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.quantitation.IDatabaseWriter;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class DatabaseWriter_1000
implements IDatabaseWriter {
    @Override
    public void convert(File file, IQuantitationDatabase quantitationDatabase, IProgressMonitor monitor) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        zipOutputStream.setLevel(PreferenceSupplier.getChromatogramCompressionLevel());
        zipOutputStream.setMethod(8);
        this.writeDatabase(zipOutputStream, "", quantitationDatabase, monitor);
        zipOutputStream.flush();
        zipOutputStream.close();
    }

    private void writeDatabase(ZipOutputStream zipOutputStream, String directoryPrefix, IQuantitationDatabase quantitationDatabase, IProgressMonitor monitor) throws IOException {
        this.writeVersion(zipOutputStream, directoryPrefix, monitor);
        this.writeDatabaseFolder(zipOutputStream, directoryPrefix, quantitationDatabase, monitor);
    }

    private void writeVersion(ZipOutputStream zipOutputStream, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "VERSION");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        String version = "0.0.0.1";
        dataOutputStream.writeInt(version.length());
        dataOutputStream.writeChars(version);
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeDatabaseFolder(ZipOutputStream zipOutputStream, String directoryPrefix, IQuantitationDatabase quantitationDatabase, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "QUANTDB/");
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.closeEntry();
        this.writeContent(zipOutputStream, directoryPrefix, quantitationDatabase, monitor);
    }

    private void writeContent(ZipOutputStream zipOutputStream, String directoryPrefix, IQuantitationDatabase quantitationDatabase, IProgressMonitor monitor) throws IOException {
        int size = quantitationDatabase.size();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Write Database", (int)size);
        try {
            ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "QUANTDB/QUANTITATION_DATABASE");
            zipOutputStream.putNextEntry(zipEntry);
            DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
            DatabaseWriter_1000.writeString(dataOutputStream, quantitationDatabase.getOperator());
            DatabaseWriter_1000.writeString(dataOutputStream, quantitationDatabase.getDescription());
            dataOutputStream.writeInt(size);
            for (IQuantitationCompound quantitationCompound : quantitationDatabase) {
                DatabaseWriter_1000.writeString(dataOutputStream, quantitationCompound.getName());
                DatabaseWriter_1000.writeString(dataOutputStream, quantitationCompound.getConcentrationUnit());
                DatabaseWriter_1000.writeString(dataOutputStream, quantitationCompound.getCalibrationMethod().toString());
                DatabaseWriter_1000.writeString(dataOutputStream, quantitationCompound.getChemicalClass());
                dataOutputStream.writeBoolean(quantitationCompound.isCrossZero());
                dataOutputStream.writeBoolean(quantitationCompound.isUseTIC());
                List quantitationPeaks = quantitationCompound.getQuantitationPeaks();
                DatabaseWriter_1000.writeQuantitationPeaks(dataOutputStream, quantitationPeaks);
                IResponseSignals concentrationResponseEntriesMSD = quantitationCompound.getResponseSignals();
                DatabaseWriter_1000.writeResponseSignals(dataOutputStream, concentrationResponseEntriesMSD);
                IQuantitationSignals quantitationSignalsMSD = quantitationCompound.getQuantitationSignals();
                DatabaseWriter_1000.writeQuantitationSignals(dataOutputStream, quantitationSignalsMSD);
                IRetentionIndexWindow retentionIndexWindow = quantitationCompound.getRetentionIndexWindow();
                DatabaseWriter_1000.writeRetentionIndexWindow(dataOutputStream, retentionIndexWindow);
                IRetentionTimeWindow retentionTimeWindow = quantitationCompound.getRetentionTimeWindow();
                DatabaseWriter_1000.writeRetentionTimeWindow(dataOutputStream, retentionTimeWindow);
                subMonitor.worked(1);
            }
            dataOutputStream.flush();
            zipOutputStream.closeEntry();
        }
        finally {
            SubMonitor.done((IProgressMonitor)subMonitor);
        }
    }

    private static void writeQuantitationPeaks(DataOutputStream dataOutputStream, List<IQuantitationPeak> quantitationPeaks) throws IOException {
        dataOutputStream.writeInt(quantitationPeaks.size());
        for (IQuantitationPeak quantitationPeak : quantitationPeaks) {
            dataOutputStream.writeDouble(quantitationPeak.getConcentration());
            DatabaseWriter_1000.writeString(dataOutputStream, quantitationPeak.getConcentrationUnit());
            IPeak peak = quantitationPeak.getReferencePeak();
            DatabaseWriter_1000.writePeak(dataOutputStream, peak);
        }
    }

    private static void writeResponseSignals(DataOutputStream dataOutputStream, IResponseSignals responseSignals) throws IOException {
        dataOutputStream.writeInt(responseSignals.size());
        for (IResponseSignal responseSignal : responseSignals) {
            dataOutputStream.writeDouble(responseSignal.getSignal());
            dataOutputStream.writeDouble(responseSignal.getConcentration());
            dataOutputStream.writeDouble(responseSignal.getResponse());
        }
    }

    private static void writeQuantitationSignals(DataOutputStream dataOutputStream, IQuantitationSignals quantitationSignals) throws IOException {
        dataOutputStream.writeInt(quantitationSignals.size());
        for (IQuantitationSignal quantitationSignal : quantitationSignals) {
            dataOutputStream.writeDouble(quantitationSignal.getSignal());
            dataOutputStream.writeFloat((float)quantitationSignal.getRelativeResponse());
            dataOutputStream.writeDouble(quantitationSignal.getUncertainty());
            dataOutputStream.writeBoolean(quantitationSignal.isUse());
        }
    }

    private static void writeRetentionIndexWindow(DataOutputStream dataOutputStream, IRetentionIndexWindow retentionIndexWindow) throws IOException {
        dataOutputStream.writeFloat(retentionIndexWindow.getAllowedNegativeDeviation());
        dataOutputStream.writeFloat(retentionIndexWindow.getAllowedPositiveDeviation());
        dataOutputStream.writeFloat(retentionIndexWindow.getRetentionIndex());
    }

    private static void writeRetentionTimeWindow(DataOutputStream dataOutputStream, IRetentionTimeWindow retentionTimeWindow) throws IOException {
        dataOutputStream.writeFloat(retentionTimeWindow.getAllowedNegativeDeviation());
        dataOutputStream.writeFloat(retentionTimeWindow.getAllowedPositiveDeviation());
        dataOutputStream.writeInt(retentionTimeWindow.getRetentionTime());
    }

    private static void writePeak(DataOutputStream dataOutputStream, IPeak peak) throws IOException {
        if (peak instanceof IPeakMSD) {
            IPeakMSD peakMSD = (IPeakMSD)peak;
            IPeakModelMSD peakModel = peakMSD.getPeakModel();
            DatabaseWriter_1000.writeString(dataOutputStream, peak.getDetectorDescription());
            DatabaseWriter_1000.writeString(dataOutputStream, peak.getQuantifierDescription());
            dataOutputStream.writeBoolean(peak.isActiveForAnalysis());
            DatabaseWriter_1000.writeString(dataOutputStream, peak.getIntegratorDescription());
            DatabaseWriter_1000.writeString(dataOutputStream, peak.getModelDescription());
            DatabaseWriter_1000.writeString(dataOutputStream, peak.getPeakType().toString());
            dataOutputStream.writeInt(peak.getSuggestedNumberOfComponents());
            dataOutputStream.writeFloat(peakModel.getBackgroundAbundance(peakModel.getStartRetentionTime()));
            dataOutputStream.writeFloat(peakModel.getBackgroundAbundance(peakModel.getStopRetentionTime()));
            IPeakMassSpectrum massSpectrum = peakModel.getPeakMassSpectrum();
            DatabaseWriter_1000.writeMassSpectrum(dataOutputStream, (IRegularMassSpectrum)massSpectrum);
            List retentionTimes = peakModel.getRetentionTimes();
            dataOutputStream.writeInt(retentionTimes.size());
            Iterator iterator = retentionTimes.iterator();
            while (iterator.hasNext()) {
                int retentionTime = (Integer)iterator.next();
                dataOutputStream.writeInt(retentionTime);
                dataOutputStream.writeFloat(peakModel.getPeakAbundance(retentionTime));
            }
            List integrationEntries = peak.getIntegrationEntries();
            DatabaseWriter_1000.writeIntegrationEntries(dataOutputStream, integrationEntries);
            Set peakTargets = peak.getTargets();
            dataOutputStream.writeInt(peakTargets.size());
            for (IIdentificationTarget peakTarget : peakTargets) {
                if (!(peakTarget instanceof IIdentificationTarget)) continue;
                IIdentificationTarget identificationEntry = peakTarget;
                DatabaseWriter_1000.writeIdentificationEntry(dataOutputStream, identificationEntry);
            }
            List quantitationEntries = peak.getQuantitationEntries();
            dataOutputStream.writeInt(quantitationEntries.size());
            for (IQuantitationEntry quantitationEntry : quantitationEntries) {
                dataOutputStream.writeDouble(quantitationEntry.getSignal());
                DatabaseWriter_1000.writeString(dataOutputStream, quantitationEntry.getName());
                DatabaseWriter_1000.writeString(dataOutputStream, quantitationEntry.getChemicalClass());
                dataOutputStream.writeDouble(quantitationEntry.getConcentration());
                DatabaseWriter_1000.writeString(dataOutputStream, quantitationEntry.getConcentrationUnit());
                dataOutputStream.writeDouble(quantitationEntry.getArea());
                DatabaseWriter_1000.writeString(dataOutputStream, quantitationEntry.getCalibrationMethod());
                dataOutputStream.writeBoolean(quantitationEntry.getUsedCrossZero());
                DatabaseWriter_1000.writeString(dataOutputStream, quantitationEntry.getDescription());
            }
            IScanMSD optimizedMassSpectrum = massSpectrum.getOptimizedMassSpectrum();
            if (optimizedMassSpectrum == null) {
                dataOutputStream.writeBoolean(false);
            } else {
                dataOutputStream.writeBoolean(true);
                DatabaseWriter_1000.writeNormalMassSpectrum(dataOutputStream, optimizedMassSpectrum);
            }
        }
    }

    private static void writeMassSpectrum(DataOutputStream dataOutputStream, IRegularMassSpectrum massSpectrum) throws IOException {
        dataOutputStream.writeShort(massSpectrum.getMassSpectrometer());
        dataOutputStream.writeShort(massSpectrum.getMassSpectrumType());
        dataOutputStream.writeDouble(massSpectrum.getPrecursorIon());
        DatabaseWriter_1000.writeNormalMassSpectrum(dataOutputStream, (IScanMSD)massSpectrum);
    }

    private static void writeNormalMassSpectrum(DataOutputStream dataOutputStream, IScanMSD massSpectrum) throws IOException {
        dataOutputStream.writeInt(massSpectrum.getRetentionTime());
        dataOutputStream.writeInt(massSpectrum.getRetentionTimeColumn1());
        dataOutputStream.writeInt(massSpectrum.getRetentionTimeColumn2());
        dataOutputStream.writeFloat(massSpectrum.getRetentionIndex());
        dataOutputStream.writeBoolean(massSpectrum.hasAdditionalRetentionIndices());
        if (massSpectrum.hasAdditionalRetentionIndices()) {
            Map retentionIndicesTyped = massSpectrum.getRetentionIndicesTyped();
            dataOutputStream.writeInt(retentionIndicesTyped.size());
            for (Map.Entry retentionIndexTyped : retentionIndicesTyped.entrySet()) {
                DatabaseWriter_1000.writeString(dataOutputStream, ((RetentionIndexType)retentionIndexTyped.getKey()).toString());
                dataOutputStream.writeFloat(((Float)retentionIndexTyped.getValue()).floatValue());
            }
        }
        dataOutputStream.writeInt(massSpectrum.getTimeSegmentId());
        dataOutputStream.writeInt(massSpectrum.getCycleNumber());
        List ions = massSpectrum.getIons();
        DatabaseWriter_1000.writeMassSpectrumIons(dataOutputStream, ions);
        dataOutputStream.writeInt(massSpectrum.getTargets().size());
        for (IIdentificationTarget identificationTarget : massSpectrum.getTargets()) {
            DatabaseWriter_1000.writeIdentificationEntry(dataOutputStream, identificationTarget);
        }
    }

    private static void writeMassSpectrumIons(DataOutputStream dataOutputStream, List<IIon> ions) throws IOException {
        dataOutputStream.writeInt(ions.size());
        for (IIon ion : ions) {
            dataOutputStream.writeDouble(ion.getIon());
            dataOutputStream.writeFloat(ion.getAbundance());
            IIonTransition ionTransition = ion.getIonTransition();
            if (ionTransition == null) {
                dataOutputStream.writeInt(0);
                continue;
            }
            dataOutputStream.writeInt(1);
            DatabaseWriter_1000.writeString(dataOutputStream, ionTransition.getCompoundName());
            dataOutputStream.writeDouble(ionTransition.getQ1StartIon());
            dataOutputStream.writeDouble(ionTransition.getQ1StopIon());
            dataOutputStream.writeDouble(ionTransition.getQ3StartIon());
            dataOutputStream.writeDouble(ionTransition.getQ3StopIon());
            dataOutputStream.writeDouble(ionTransition.getCollisionEnergy());
            dataOutputStream.writeDouble(ionTransition.getQ1Resolution());
            dataOutputStream.writeDouble(ionTransition.getQ3Resolution());
            dataOutputStream.writeInt(ionTransition.getTransitionGroup());
            dataOutputStream.writeInt(ionTransition.getDwell());
        }
    }

    private static void writeIntegrationEntries(DataOutputStream dataOutputStream, List<? extends IIntegrationEntry> integrationEntries) throws IOException {
        dataOutputStream.writeInt(integrationEntries.size());
        for (IIntegrationEntry iIntegrationEntry : integrationEntries) {
            dataOutputStream.writeDouble(iIntegrationEntry.getSignal());
            dataOutputStream.writeDouble(iIntegrationEntry.getIntegratedArea());
        }
    }

    private static void writeIdentificationEntry(DataOutputStream dataOutputStream, IIdentificationTarget identificationEntry) throws IOException {
        ILibraryInformation libraryInformation = identificationEntry.getLibraryInformation();
        IComparisonResult comparisonResult = identificationEntry.getComparisonResult();
        DatabaseWriter_1000.writeString(dataOutputStream, identificationEntry.getIdentifier());
        dataOutputStream.writeBoolean(identificationEntry.isManuallyVerified());
        DatabaseWriter_1000.writeString(dataOutputStream, libraryInformation.getCasNumber());
        DatabaseWriter_1000.writeString(dataOutputStream, libraryInformation.getComments());
        DatabaseWriter_1000.writeString(dataOutputStream, libraryInformation.getReferenceIdentifier());
        DatabaseWriter_1000.writeString(dataOutputStream, libraryInformation.getMiscellaneous());
        DatabaseWriter_1000.writeString(dataOutputStream, libraryInformation.getDatabase());
        DatabaseWriter_1000.writeString(dataOutputStream, libraryInformation.getContributor());
        DatabaseWriter_1000.writeString(dataOutputStream, libraryInformation.getName());
        Set synonyms = libraryInformation.getSynonyms();
        int numberOfSynonyms = synonyms.size();
        dataOutputStream.writeInt(numberOfSynonyms);
        for (String synonym : synonyms) {
            DatabaseWriter_1000.writeString(dataOutputStream, synonym);
        }
        DatabaseWriter_1000.writeString(dataOutputStream, libraryInformation.getFormula());
        DatabaseWriter_1000.writeString(dataOutputStream, libraryInformation.getSmiles());
        DatabaseWriter_1000.writeString(dataOutputStream, libraryInformation.getInChI());
        dataOutputStream.writeDouble(libraryInformation.getMolWeight());
        dataOutputStream.writeFloat(comparisonResult.getMatchFactor());
        dataOutputStream.writeFloat(comparisonResult.getMatchFactorDirect());
        dataOutputStream.writeFloat(comparisonResult.getReverseMatchFactor());
        dataOutputStream.writeFloat(comparisonResult.getReverseMatchFactorDirect());
        dataOutputStream.writeFloat(comparisonResult.getProbability());
        dataOutputStream.writeBoolean(comparisonResult.isMatch());
    }

    private static void writeString(DataOutputStream dataOutputStream, String value) throws IOException {
        dataOutputStream.writeInt(value.length());
        dataOutputStream.writeChars(value);
    }
}

