/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.methods;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.methods.IMethodWriter;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractMethodWriter
implements IMethodWriter {
    private final String version;

    public AbstractMethodWriter(String version) {
        this.version = version;
    }

    @Override
    public void convert(File file, IProcessMethod processMethod, MessageConsumer messages, IProgressMonitor monitor) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        zipOutputStream.setLevel(PreferenceSupplier.getMethodCompressionLevel());
        zipOutputStream.setMethod(8);
        this.writeProcessMethod(zipOutputStream, processMethod, monitor);
        zipOutputStream.flush();
        zipOutputStream.close();
    }

    public void writeProcessMethod(ZipOutputStream zipOutputStream, IProcessMethod processMethod, IProgressMonitor monitor) throws IOException {
        this.writeVersion(zipOutputStream, monitor);
        this.writeData(zipOutputStream, processMethod, monitor);
    }

    private void writeVersion(ZipOutputStream zipOutputStream, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry("VERSION");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        AbstractMethodWriter.writeString(dataOutputStream, this.version);
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeData(ZipOutputStream zipOutputStream, IProcessMethod processMethod, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry("PROCESS_METHOD");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        this.serializeData(processMethod, dataOutputStream);
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    protected abstract void serializeData(IProcessMethod var1, DataOutputStream var2) throws IOException;

    protected static void writeString(DataOutputStream dataOutputStream, String value) throws IOException {
        dataOutputStream.writeInt(value.length());
        dataOutputStream.writeChars(value);
    }

    @Override
    public void convert(OutputStream stream, String nameHint, IProcessMethod processMethod, MessageConsumer messages, IProgressMonitor monitor) throws IOException {
        messages.addErrorMessage(this.getClass().getName(), "Writing to stream is not supported by this converter");
    }
}

