/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.converter.supplier.chemclipse;

import java.io.File;
import java.io.IOException;
import org.eclipse.chemclipse.converter.chromatogram.IChromatogramExportConverter;
import org.eclipse.chemclipse.converter.chromatogram.IChromatogramImportConverter;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.converter.ChromatogramImportConverter;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.selection.ChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.procedures.Procedure;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionConsumer;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionContext;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.converter.ChromatogramExportConverter;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.ChromatogramSelectionWSD;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.ChromatogramProcedureSettings;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={Procedure.class})
public class ChromatogramProcedure
implements Procedure<ChromatogramProcedureSettings> {
    private static final String NAME = "Copy Chromatogram Selection";
    private final IChromatogramImportConverter<IChromatogramMSD> MSD_IMPORT = new org.eclipse.chemclipse.msd.converter.supplier.chemclipse.converter.ChromatogramImportConverter();
    private final IChromatogramImportConverter<IChromatogramCSD> CSD_IMPORT = new ChromatogramImportConverter();
    private final IChromatogramImportConverter<IChromatogramWSD> WSD_IMPORT = new org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.converter.ChromatogramImportConverter();
    private final IChromatogramExportConverter MSD_EXPORT = new org.eclipse.chemclipse.msd.converter.supplier.chemclipse.converter.ChromatogramExportConverter();
    private final IChromatogramExportConverter CSD_EXPORT = new org.eclipse.chemclipse.csd.converter.supplier.chemclipse.converter.ChromatogramExportConverter();
    private final IChromatogramExportConverter WSD_EXPORT = new ChromatogramExportConverter();

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return "Creates a deep copy of the current Chromatogram Selection for doing some sub-processing";
    }

    public Class<ChromatogramProcedureSettings> getConfigClass() {
        return ChromatogramProcedureSettings.class;
    }

    public <ResultType> ProcessExecutionConsumer<ResultType> createConsumer(ChromatogramProcedureSettings settings, ProcessExecutionConsumer<ResultType> currentConsumer, ProcessExecutionContext context) {
        Object result = currentConsumer.getResult();
        if (result instanceof IChromatogramSelection) {
            ChromatogramSelectionMSD copiedSelection;
            IChromatogramSelection originalSelection = (IChromatogramSelection)result;
            IChromatogram chromatogram = originalSelection.getChromatogram();
            if (chromatogram instanceof IChromatogramMSD) {
                IChromatogramMSD chromatogramMSD = ChromatogramProcedure.copyChromatogram(chromatogram, this.MSD_EXPORT, this.MSD_IMPORT, context);
                if (chromatogramMSD == null) {
                    return null;
                }
                copiedSelection = new ChromatogramSelectionMSD(chromatogramMSD);
            } else if (chromatogram instanceof IChromatogramCSD) {
                IChromatogramCSD chromatogramCSD = ChromatogramProcedure.copyChromatogram(chromatogram, this.CSD_EXPORT, this.CSD_IMPORT, context);
                if (chromatogramCSD == null) {
                    return null;
                }
                copiedSelection = new ChromatogramSelectionCSD(chromatogramCSD);
            } else if (chromatogram instanceof IChromatogramWSD) {
                IChromatogramWSD chromatogramWSD = ChromatogramProcedure.copyChromatogram(chromatogram, this.WSD_EXPORT, this.WSD_IMPORT, context);
                if (chromatogramWSD == null) {
                    return null;
                }
                copiedSelection = new ChromatogramSelectionWSD(chromatogramWSD);
            } else {
                context.addErrorMessage(NAME, "Unsupported chromatogramtype: " + chromatogram.getClass().getSimpleName());
                return null;
            }
            IChromatogram copiedChromatogram = copiedSelection.getChromatogram();
            if (settings.isAddAsReferenceChromatogram()) {
                chromatogram.addReferencedChromatogram(copiedChromatogram);
            }
            if (settings.isCopyChromatogramSelectionRange()) {
                copiedSelection.setRangeRetentionTime(originalSelection.getStartRetentionTime(), originalSelection.getStopRetentionTime());
            }
            copiedChromatogram.setFile(null);
            copiedChromatogram.setDataName(settings.getName().replace("${chromatogram_name}", chromatogram.getName()));
            return currentConsumer.withResult((Object)copiedSelection);
        }
        return null;
    }

    private static <T extends IChromatogram<?>> T copyChromatogram(IChromatogram<?> chromatogram, IChromatogramExportConverter exporter, IChromatogramImportConverter<T> importer, ProcessExecutionContext context) {
        IProcessingInfo info;
        block5: {
            File tempFile;
            SubMonitor subMonitor;
            block4: {
                subMonitor = SubMonitor.convert((IProgressMonitor)context.getProgressMonitor(), (int)100);
                try {
                    tempFile = File.createTempFile(chromatogram.getName(), ".ocb");
                    tempFile.deleteOnExit();
                    IProcessingInfo convert = exporter.convert(tempFile, chromatogram, (IProgressMonitor)subMonitor.split(50));
                    if (!convert.hasErrorMessages()) break block4;
                    context.addMessages((MessageProvider)convert);
                }
                catch (IOException e) {
                    context.addErrorMessage(NAME, "Cloning has failed", (Throwable)e);
                    return null;
                }
                return null;
            }
            info = importer.convert(tempFile, (IProgressMonitor)subMonitor.split(50));
            if (!info.hasErrorMessages()) break block5;
            context.addMessages((MessageProvider)info);
            return null;
        }
        return (T)((IChromatogram)info.getProcessingResult());
    }

    public DataCategory[] getDataCategories() {
        return new DataCategory[]{DataCategory.WSD, DataCategory.CSD, DataCategory.MSD};
    }
}

