/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.converter.io.AbstractChromatogramWriter;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.internal.io.ChromatogramWriter_1005;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.internal.io.ChromatogramWriter_1006;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.internal.io.ChromatogramWriter_1007;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.internal.io.ChromatogramWriter_1100;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.internal.io.ChromatogramWriter_1300;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.internal.io.ChromatogramWriter_1301;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.io.IChromatogramWSDZipWriter;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramWriterWSD
extends AbstractChromatogramWriter
implements IChromatogramWSDZipWriter {
    public void writeChromatogram(File file, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        IChromatogramWSDZipWriter chromatogramWriter = this.getChromatogramWriter(chromatogram, monitor);
        chromatogramWriter.writeChromatogram(file, chromatogram, monitor);
    }

    @Override
    public void writeChromatogram(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        IChromatogramWSDZipWriter chromatogramWriter = this.getChromatogramWriter(chromatogram, monitor);
        chromatogramWriter.writeChromatogram(zipOutputStream, "", chromatogram, monitor);
    }

    private IChromatogramWSDZipWriter getChromatogramWriter(IChromatogramWSD chromatogram, IProgressMonitor monitor) {
        String versionSave = PreferenceSupplier.getChromatogramVersionSave();
        AbstractChromatogramWriter chromatogramWriter = versionSave.equals("1.0.0.5") ? new ChromatogramWriter_1005() : (versionSave.equals("1.0.0.6") ? new ChromatogramWriter_1006() : (versionSave.equals("1.0.0.7") ? new ChromatogramWriter_1007() : (versionSave.equals("1.1.0.0") ? new ChromatogramWriter_1100() : (versionSave.equals("1.3.0.0") ? new ChromatogramWriter_1300() : new ChromatogramWriter_1301()))));
        return chromatogramWriter;
    }
}

