/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.converter;

import java.io.File;
import org.eclipse.chemclipse.converter.chromatogram.AbstractChromatogramImportConverter;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.io.ChromatogramReaderWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.SpecificationValidator;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramImportConverter
extends AbstractChromatogramImportConverter<IChromatogramWSD> {
    private static final Logger logger = Logger.getLogger(ChromatogramImportConverter.class);

    public IProcessingInfo<IChromatogramWSD> convert(File file, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = super.validate(file);
        if (!processingInfo.hasErrorMessages()) {
            file = SpecificationValidator.validateSpecification(file);
            ChromatogramReaderWSD reader = new ChromatogramReaderWSD();
            try {
                IChromatogramWSD chromatogram = reader.read(file, monitor);
                processingInfo.setProcessingResult((Object)chromatogram);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage("Import Converter", "Something has definitely gone wrong with the file: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }

    public IProcessingInfo convertOverview(File file, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = super.validate(file);
        if (!processingInfo.hasErrorMessages()) {
            file = SpecificationValidator.validateSpecification(file);
            ChromatogramReaderWSD reader = new ChromatogramReaderWSD();
            try {
                IChromatogramOverview chromatogramOverview = reader.readOverview(file, monitor);
                processingInfo.setProcessingResult((Object)chromatogramOverview);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage("Import Converter", "Something has definitely gone wrong with the file: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }
}

