/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.model.xwc;

import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignal;
import org.eclipse.chemclipse.model.signals.TotalScanSignalExtractor;
import org.eclipse.chemclipse.model.signals.TotalScanSignals;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.chemclipse.wsd.model.xwc.ITotalWavelengthSignalExtractor;

@Deprecated
public class TotalWavelengthSignalExtractor
extends TotalScanSignalExtractor
implements ITotalWavelengthSignalExtractor {
    private IChromatogramWSD chromatogram;

    public TotalWavelengthSignalExtractor(IChromatogramWSD chromatogram) throws ChromatogramIsNullException {
        super((IChromatogram)chromatogram);
        this.chromatogram = chromatogram;
    }

    @Override
    public ITotalScanSignals getTotalWavelengthSignals(IChromatogramSelectionWSD chromatogramSelection) {
        if (chromatogramSelection == null || chromatogramSelection.getChromatogram() != this.chromatogram) {
            return new TotalScanSignals(0, (IChromatogram)this.chromatogram);
        }
        int startScan = this.chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = this.chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        ITotalScanSignals signals = this.initializeTotalWavelenghtSignals(startScan, stopScan);
        return signals;
    }

    private ITotalScanSignals initializeTotalWavelenghtSignals(int startScan, int stopScan) {
        assert (startScan <= stopScan) : "The startScan must be lower or equal the stop scan.";
        if (startScan < 1 || startScan > this.chromatogram.getNumberOfScans() || stopScan < 1 || stopScan > this.chromatogram.getNumberOfScans()) {
            return new TotalScanSignals(0, (IChromatogram)this.chromatogram);
        }
        TotalScanSignals signals = new TotalScanSignals(startScan, stopScan, (IChromatogram)this.chromatogram);
        int scan = startScan;
        while (scan <= stopScan) {
            IScanWSD scanWSD = this.chromatogram.getSupplierScan(scan);
            TotalScanSignal totalWavelengthSignal = new TotalScanSignal(scanWSD.getRetentionTime(), scanWSD.getRetentionIndex(), scanWSD.getTotalSignal());
            signals.add((ITotalScanSignal)totalWavelengthSignal);
            ++scan;
        }
        return signals;
    }
}

