/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.model.comparator;

import java.io.Serializable;
import java.util.Comparator;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.chemclipse.wsd.model.comparator.WavelengthAbundanceComparator;
import org.eclipse.chemclipse.wsd.model.comparator.WavelengthComparatorMode;
import org.eclipse.chemclipse.wsd.model.comparator.WavelengthValueComparator;
import org.eclipse.chemclipse.wsd.model.core.IScanSignalWSD;

public class WavelengthCombinedComparator
implements Comparator<IScanSignalWSD>,
Serializable {
    private static final long serialVersionUID = -109573471700765379L;
    private final Comparator<IScanSignalWSD> firstComparator;
    private final Comparator<IScanSignalWSD> secondComparator;

    public WavelengthCombinedComparator(WavelengthComparatorMode wavelengthComparatorMode) {
        this(wavelengthComparatorMode, SortOrder.ASC);
    }

    public WavelengthCombinedComparator(WavelengthComparatorMode ionComparatorMode, SortOrder sortOrder) {
        switch (ionComparatorMode) {
            case ABUNDANCE_FIRST: {
                this.firstComparator = new WavelengthAbundanceComparator(sortOrder);
                this.secondComparator = new WavelengthValueComparator(sortOrder);
                break;
            }
            case WAVELENGTH_FIRST: {
                this.firstComparator = new WavelengthValueComparator(sortOrder);
                this.secondComparator = new WavelengthAbundanceComparator(sortOrder);
                break;
            }
            default: {
                this.firstComparator = new WavelengthAbundanceComparator(sortOrder);
                this.secondComparator = new WavelengthValueComparator(sortOrder);
            }
        }
    }

    @Override
    public int compare(IScanSignalWSD scanSignal1, IScanSignalWSD scanSignal2) {
        int result = this.firstComparator.compare(scanSignal1, scanSignal2);
        if (result != 0) {
            return result;
        }
        result = this.secondComparator.compare(scanSignal1, scanSignal2);
        return result;
    }
}

