/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.wizards;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.swt.ControlBuilder;
import org.eclipse.chemclipse.support.ui.swt.columns.ColumnDefinition;
import org.eclipse.chemclipse.support.ui.swt.columns.SimpleColumnDefinition;
import org.eclipse.chemclipse.support.ui.wizards.SinglePageWizard;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.SelectableTargetDisplaySettings;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.TargetDisplaySettings;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.TargetReference;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.VisibilityTargetDisplaySettings;
import org.eclipse.chemclipse.ux.extension.xxd.ui.wizards.TargetDisplaySettingsWizardListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TargetDisplaySettingsWizard {
    public static final int DEFAULT_WIDTH = 1000;
    public static final int DEFAULT_HEIGHT = 600;

    public static boolean openWizard(Shell shell, Collection<? extends TargetReference> identifications, TargetDisplaySettingsWizardListener listener, TargetDisplaySettings settings) {
        TargetDisplaySettingsPage page = new TargetDisplaySettingsPage(identifications, settings, listener);
        SinglePageWizard wizard = new SinglePageWizard("Target Label Settings", false, (WizardPage)page);
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
        wizardDialog.setMinimumPageSize(1000, 600);
        wizardDialog.setPageSize(1000, 600);
        if (wizardDialog.open() == 0) {
            if (settings instanceof SelectableTargetDisplaySettings) {
                ((SelectableTargetDisplaySettings)settings).setSelectedSettings(page.selectedSettings.base);
            }
            page.selectedSettings.copyTo(page.selectedSettings.base);
            return true;
        }
        return false;
    }

    private static void createToolbarActions(ToolBarManager manager, final TableViewer tableViewer, final WizardTargetDisplaySettings wizardSettings, final Runnable listener) {
        manager.add((IAction)new Action("Enable All", ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/selected.gif", "16x16")){

            public void run() {
                TableItem[] tableItemArray = tableViewer.getTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    Object data = item.getData();
                    if (data instanceof TargetReference) {
                        TargetReference target = (TargetReference)data;
                        wizardSettings.setVisible(target, true);
                        tableViewer.refresh((Object)target);
                    }
                    ++n2;
                }
                listener.run();
            }
        });
        manager.add((IAction)new Action("Disable All", ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/deselected.gif", "16x16")){

            public void run() {
                TableItem[] tableItemArray = tableViewer.getTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    Object data = item.getData();
                    if (data instanceof TargetReference) {
                        TargetReference target = (TargetReference)data;
                        wizardSettings.setVisible(target, false);
                        tableViewer.refresh((Object)target);
                    }
                    ++n2;
                }
                listener.run();
            }
        });
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new ControlContribution("searchbar"){

            protected Control createControl(Composite parent) {
                Composite container = ControlBuilder.createContainer((Composite)parent, (int)3);
                final Text text = (Text)ControlBuilder.fill((Control)new Text(container, 896));
                ControlBuilder.gridData((Control)text).horizontalIndent = 3;
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        final String filterText = text.getText();
                        if (filterText == null || filterText.isEmpty()) {
                            tableViewer.resetFilters();
                            wizardSettings.predicate = always -> true;
                        } else {
                            wizardSettings.predicate = new Predicate<TargetReference>(){

                                @Override
                                public boolean test(TargetReference target) {
                                    String label = target.getTargetLabel(wizardSettings.getField());
                                    return label != null && label.toLowerCase().contains(filterText.toLowerCase());
                                }
                            };
                            tableViewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

                                public boolean select(Viewer viewer, Object parentElement, Object element) {
                                    if (element instanceof TargetReference) {
                                        TargetReference target = (TargetReference)element;
                                        return wizardSettings.predicate.test(target);
                                    }
                                    return true;
                                }
                            }});
                        }
                        listener.run();
                    }
                });
                return container;
            }

            protected int computeWidth(Control control) {
                return Math.max(super.computeWidth(control), 500);
            }
        });
    }

    private static final class TargetDisplaySettingsPage
    extends WizardPage {
        WizardTargetDisplaySettings selectedSettings;
        final WizardTargetDisplaySettings[] wizardSettings;
        private final Collection<? extends TargetReference> identifications;
        private final TargetDisplaySettingsWizardListener listener;

        protected TargetDisplaySettingsPage(Collection<? extends TargetReference> identifications, TargetDisplaySettings settings, TargetDisplaySettingsWizardListener listener) {
            super(TargetDisplaySettingsPage.class.getName());
            this.identifications = identifications;
            this.listener = listener;
            this.setImageDescriptor(ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/labels.png", "64x64"));
            this.setTitle("Manage target labels to display");
            this.setDescription("Here you can select what target labels should be displayed in the chromatogram");
            Set<Map.Entry<String, TargetDisplaySettings>> entrySet = settings instanceof SelectableTargetDisplaySettings ? ((SelectableTargetDisplaySettings)settings).getSettings().entrySet() : Collections.singletonMap("Settings", settings).entrySet();
            this.wizardSettings = new WizardTargetDisplaySettings[entrySet.size()];
            int index = 0;
            for (Map.Entry<String, TargetDisplaySettings> entry : entrySet) {
                this.wizardSettings[index] = new WizardTargetDisplaySettings(entry.getValue(), entry.getKey(), listener);
                if (settings instanceof SelectableTargetDisplaySettings) {
                    if (((SelectableTargetDisplaySettings)settings).isSelectedSettings(entry.getValue())) {
                        this.selectedSettings = this.wizardSettings[index];
                    }
                } else {
                    this.selectedSettings = this.wizardSettings[index];
                }
                ++index;
            }
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            final Button[] radioButtons = new Button[this.wizardSettings.length];
            final TargetSettingEditor[] editors = new TargetSettingEditor[this.wizardSettings.length];
            SelectionListener buttonListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int i = 0;
                    while (i < radioButtons.length) {
                        Button radiobutton = radioButtons[i];
                        if (radiobutton == null) {
                            editors[i].setEnabled(true);
                        } else if (radiobutton.getSelection()) {
                            editors[i].setEnabled(true);
                            if (selectedSettings != wizardSettings[i]) {
                                selectedSettings = wizardSettings[i];
                                this.notifyListener();
                            }
                        } else {
                            editors[i].setEnabled(false);
                        }
                        ++i;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            };
            int i = 0;
            while (i < radioButtons.length) {
                WizardTargetDisplaySettings settings = this.wizardSettings[i];
                if (radioButtons.length > 1) {
                    radioButtons[i] = ControlBuilder.radiobutton((Composite)composite, (String)("Use " + settings.name), (settings == this.selectedSettings ? 1 : 0) != 0);
                    radioButtons[i].addSelectionListener(buttonListener);
                }
                editors[i] = new TargetSettingEditor(ControlBuilder.indentedContainer((Composite)composite, (int)25), settings, this, this.identifications);
                ControlBuilder.separator((Composite)composite);
                ++i;
            }
            buttonListener.widgetSelected(null);
            if (this.listener != null) {
                boolean preview = this.listener.isShowPreview();
                final Button previewCheckbox = ControlBuilder.checkbox((Composite)composite, (String)"Show preview in editor", (boolean)preview);
                previewCheckbox.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        listener.setShowPreview(previewCheckbox.getSelection());
                        this.notifyListener();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                if (preview) {
                    this.notifyListener();
                }
            }
            this.setControl((Control)composite);
        }

        private void notifyListener() {
            if (this.listener != null) {
                if (this.listener.isShowPreview()) {
                    this.listener.setPreviewSettings(this.selectedSettings, this.selectedSettings.predicate);
                } else {
                    this.listener.setPreviewSettings(null, t -> true);
                }
            }
        }

        private static TableViewer createTargetTable(Composite parent, final WizardTargetDisplaySettings wizardSettings, final Runnable updateListener) {
            final TableViewer tableViewer = ControlBuilder.createTable((Composite)parent, (boolean)false);
            ControlBuilder.createColumn((TableViewer)tableViewer, (ColumnDefinition)new SimpleColumnDefinition("", 18, (CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return "";
                }

                public Image getImage(Object element) {
                    if (element instanceof TargetReference) {
                        TargetReference identificationTarget = (TargetReference)element;
                        if (wizardSettings.isVisible(identificationTarget)) {
                            return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/selected.gif", "16x16");
                        }
                        return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/deselected.gif", "16x16");
                    }
                    return super.getImage(element);
                }
            }).minWidth(18).resizable(false)).setEditingSupport(new EditingSupport((ColumnViewer)tableViewer){
                CheckboxCellEditor cellEditor;
                {
                    super($anonymous0);
                    this.cellEditor = new CheckboxCellEditor((Composite)tableViewer2.getTable());
                }

                protected void setValue(Object element, Object value) {
                    wizardSettings.setVisible((TargetReference)element, (Boolean)value);
                    tableViewer.refresh(element);
                    updateListener.run();
                }

                protected Object getValue(Object element) {
                    return wizardSettings.isVisible((TargetReference)element);
                }

                protected CellEditor getCellEditor(Object element) {
                    return this.cellEditor;
                }

                protected boolean canEdit(Object element) {
                    return element instanceof TargetReference;
                }
            });
            ControlBuilder.createColumn((TableViewer)tableViewer, (ColumnDefinition)new SimpleColumnDefinition(wizardSettings.settingsListener != null ? wizardSettings.settingsListener.getIDLabel() : "ID", 80, TargetReference::getName));
            ControlBuilder.createColumn((TableViewer)tableViewer, (ColumnDefinition)new SimpleColumnDefinition("Type", 50, TargetReference::getType));
            TargetDisplaySettings.LibraryField[] libraryFieldArray = TargetDisplaySettings.LibraryField.values();
            int n = libraryFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                final TargetDisplaySettings.LibraryField field = libraryFieldArray[n2];
                ControlBuilder.createColumn((TableViewer)tableViewer, (ColumnDefinition)new SimpleColumnDefinition(field.toString(), 100, (CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        if (element instanceof TargetReference) {
                            TargetReference reference = (TargetReference)element;
                            return reference.getTargetLabel(field);
                        }
                        return "";
                    }
                }));
                ++n2;
            }
            return tableViewer;
        }

        private static final class TargetSettingEditor {
            private final Button peakLabels;
            private final Button scanLabels;
            private final Label fieldLabel;
            private final ComboViewer fieldComboViewer;
            private final Label rotationLabel;
            private final Scale scale;
            private final Label collisionLabel;
            private final ComboViewer collisionComboViewer;
            private TableViewer listUI;
            private ToolBarManager toolbarManager;
            private final Collection<? extends TargetReference> identifications;

            public TargetSettingEditor(Composite parent, final WizardTargetDisplaySettings editorSettings, final TargetDisplaySettingsPage page, Collection<? extends TargetReference> identifications) {
                this.identifications = identifications;
                Composite showLabelsContainer = ControlBuilder.createDefault((Composite)parent, (int)7);
                this.peakLabels = ControlBuilder.checkbox((Composite)showLabelsContainer, (String)"Show Peak Labels", (boolean)editorSettings.isShowPeakLabels());
                this.peakLabels.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        editorSettings.setShowPeakLabels(peakLabels.getSelection());
                        page.notifyListener();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                this.scanLabels = ControlBuilder.checkbox((Composite)showLabelsContainer, (String)"Show Scan Labels", (boolean)editorSettings.isShowScanLables());
                this.scanLabels.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        editorSettings.setShowScanLables(scanLabels.getSelection());
                        page.notifyListener();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                new Label(showLabelsContainer, 0).setText(" | ");
                this.fieldLabel = ControlBuilder.label((String)"Display Field", (Composite)showLabelsContainer);
                this.fieldComboViewer = new ComboViewer(showLabelsContainer, 8);
                this.fieldComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
                this.fieldComboViewer.setInput((Object)TargetDisplaySettings.LibraryField.values());
                this.fieldComboViewer.setSelection((ISelection)new StructuredSelection((Object)editorSettings.getField()));
                this.fieldComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        editorSettings.setField((TargetDisplaySettings.LibraryField)((Object)fieldComboViewer.getStructuredSelection().getFirstElement()));
                        page.notifyListener();
                    }
                });
                this.collisionLabel = ControlBuilder.label((String)"Collision Detection Depth", (Composite)showLabelsContainer);
                this.collisionComboViewer = new ComboViewer(showLabelsContainer);
                this.collisionComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
                this.collisionComboViewer.setInput((Object)new Object[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
                this.collisionComboViewer.setSelection((ISelection)new StructuredSelection((Object)editorSettings.getCollisionDetectionDepth()));
                this.collisionComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        editorSettings.setCollisionDetectionDepth((Integer)collisionComboViewer.getStructuredSelection().getFirstElement());
                        page.notifyListener();
                    }
                });
                Composite container = ControlBuilder.createLabelContainer((Composite)parent);
                this.rotationLabel = ControlBuilder.label((String)this.getRotationText(editorSettings.getRotation()), (Composite)container);
                this.scale = (Scale)ControlBuilder.fill((Control)new Scale(container, 256));
                this.scale.setMinimum(0);
                this.scale.setMaximum(90);
                this.scale.setIncrement(1);
                this.scale.setPageIncrement(15);
                this.scale.setSelection(editorSettings.getRotation());
                this.scale.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        int selection = scale.getSelection();
                        editorSettings.setRotation(selection);
                        rotationLabel.setText(this.getRotationText(selection));
                        page.notifyListener();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                if (editorSettings.base instanceof VisibilityTargetDisplaySettings) {
                    ControlBuilder.maximize((Control)parent);
                    this.toolbarManager = new ToolBarManager();
                    ControlBuilder.fill((Control)this.toolbarManager.createControl(parent));
                    this.listUI = TargetDisplaySettingsPage.createTargetTable(parent, editorSettings, () -> TargetDisplaySettingsPage.access$0(page));
                    ControlBuilder.maximize((Control)this.listUI.getControl());
                    TargetDisplaySettingsWizard.createToolbarActions(this.toolbarManager, this.listUI, editorSettings, () -> TargetDisplaySettingsPage.access$0(page));
                    this.toolbarManager.update(true);
                    ISelectionChangedListener comboListener = new ISelectionChangedListener(){
                        private TargetDisplaySettings.LibraryField currentField;

                        public void selectionChanged(SelectionChangedEvent event) {
                            TargetDisplaySettings.LibraryField field = editorSettings.getField();
                            if (field != this.currentField && page.selectedSettings == editorSettings) {
                                this.currentField = field;
                                listUI.refresh();
                                page.notifyListener();
                            }
                        }
                    };
                    this.fieldComboViewer.addSelectionChangedListener(comboListener);
                }
            }

            private String getRotationText(int value) {
                StringBuilder sb = new StringBuilder();
                sb.append("Rotation (");
                if (value < 10) {
                    sb.append(' ');
                }
                sb.append(value);
                sb.append("\u00b0)  ");
                return sb.toString();
            }

            public void setEnabled(boolean enabled) {
                this.peakLabels.setEnabled(enabled);
                this.scanLabels.setEnabled(enabled);
                this.fieldLabel.setEnabled(enabled);
                this.collisionLabel.setEnabled(enabled);
                this.rotationLabel.setEnabled(enabled);
                this.fieldComboViewer.getControl().setEnabled(enabled);
                this.collisionComboViewer.getControl().setEnabled(enabled);
                this.scale.setEnabled(enabled);
                if (this.listUI != null) {
                    if (enabled && this.listUI.getInput() == null) {
                        this.listUI.setInput(this.identifications);
                    }
                    this.listUI.getControl().setEnabled(enabled);
                }
                if (this.toolbarManager != null) {
                    this.toolbarManager.getControl().setEnabled(enabled);
                }
            }
        }
    }

    private static final class WizardTargetDisplaySettings
    implements TargetDisplaySettings,
    VisibilityTargetDisplaySettings {
        private boolean showPeakLabels;
        private boolean showScanLables;
        private TargetDisplaySettings.LibraryField libraryField;
        private final Map<TargetReference, Boolean> visibleMap = new HashMap<TargetReference, Boolean>();
        private final TargetDisplaySettings base;
        private int rotation;
        private int depth;
        private final String name;
        private final TargetDisplaySettingsWizardListener settingsListener;
        public Predicate<TargetReference> predicate = always -> true;

        public WizardTargetDisplaySettings(TargetDisplaySettings base, String name, TargetDisplaySettingsWizardListener listener) {
            this.base = base;
            this.name = name;
            this.settingsListener = listener;
            this.showPeakLabels = base.isShowPeakLabels();
            this.showScanLables = base.isShowScanLables();
            this.libraryField = base.getField();
            this.rotation = base.getRotation();
            this.depth = base.getCollisionDetectionDepth();
        }

        public void copyTo(TargetDisplaySettings other) {
            other.setField(this.libraryField);
            other.setShowPeakLabels(this.showPeakLabels);
            other.setShowScanLables(this.showScanLables);
            other.setRotation(this.rotation);
            other.setCollisionDetectionDepth(this.depth);
            if (other instanceof VisibilityTargetDisplaySettings) {
                VisibilityTargetDisplaySettings visibilityTargetDisplaySettings = (VisibilityTargetDisplaySettings)other;
                for (Map.Entry<TargetReference, Boolean> entry : this.visibleMap.entrySet()) {
                    visibilityTargetDisplaySettings.setVisible(entry.getKey(), entry.getValue());
                }
            }
        }

        @Override
        public boolean isShowPeakLabels() {
            return this.showPeakLabels;
        }

        @Override
        public boolean isShowScanLables() {
            return this.showScanLables;
        }

        @Override
        public void setShowPeakLabels(boolean showPeakLabels) {
            this.showPeakLabels = showPeakLabels;
        }

        @Override
        public void setShowScanLables(boolean showScanLables) {
            this.showScanLables = showScanLables;
        }

        @Override
        public TargetDisplaySettings.LibraryField getField() {
            return this.libraryField;
        }

        @Override
        public void setField(TargetDisplaySettings.LibraryField libraryField) {
            this.libraryField = libraryField;
        }

        @Override
        public boolean isVisible(TargetReference reference) {
            if (reference == null) {
                return false;
            }
            return this.visibleMap.computeIfAbsent(reference, t -> {
                if (this.base instanceof VisibilityTargetDisplaySettings) {
                    VisibilityTargetDisplaySettings v = (VisibilityTargetDisplaySettings)this.base;
                    return v.isVisible((TargetReference)t);
                }
                return true;
            });
        }

        @Override
        public void setVisible(TargetReference reference, boolean visible) {
            this.visibleMap.put(reference, visible);
        }

        @Override
        public void setRotation(int degree) {
            this.rotation = degree;
        }

        @Override
        public int getRotation() {
            return this.rotation;
        }

        @Override
        public int getCollisionDetectionDepth() {
            return this.depth;
        }

        @Override
        public void setCollisionDetectionDepth(int depth) {
            this.depth = depth;
        }
    }
}

