/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.wizards;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.converter.ISupplierFileIdentifier;
import org.eclipse.chemclipse.ux.extension.ui.swt.DataExplorerTreeUI;
import org.eclipse.chemclipse.ux.extension.ui.swt.MultiDataExplorerTreeUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.wizards.InputWizardSettings;
import org.eclipse.chemclipse.xxd.process.files.SupplierFileIdentifierCache;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;

public class InputEntriesWizardPage
extends WizardPage {
    private final InputWizardSettings inputWizardSettings;
    private DataExplorerTreeUI.DataExplorerTreeRoot treeSelection = DataExplorerTreeUI.DataExplorerTreeRoot.NONE;
    private final Map<File, Map<ISupplierFileIdentifier, Collection<ISupplier>>> selectedItems = new HashMap<File, Map<ISupplierFileIdentifier, Collection<ISupplier>>>();
    private MultiDataExplorerTreeUI explorerTreeUI;

    public InputEntriesWizardPage(InputWizardSettings inputWizardSettings) {
        super(InputEntriesWizardPage.class.getName());
        this.inputWizardSettings = inputWizardSettings;
        this.setTitle(inputWizardSettings.getTitle());
        this.setDescription(inputWizardSettings.getDescription());
        this.validate();
    }

    private void validate() {
        if (this.selectedItems.isEmpty()) {
            this.setPageComplete(false);
            this.setErrorMessage("Please select at least one valid data item");
        } else {
            this.setPageComplete(true);
            this.setErrorMessage(null);
        }
    }

    public Map<File, Map<ISupplierFileIdentifier, Collection<ISupplier>>> getSelectedItems() {
        return this.selectedItems;
    }

    public void createControl(Composite parent) {
        this.explorerTreeUI = new WizardMultiDataExplorerTreeUI(parent, this.inputWizardSettings.getSupplierCache(), this.inputWizardSettings.getPreferenceStore(), this);
        this.explorerTreeUI.expandLastDirectoryPath();
        this.setControl(this.explorerTreeUI.getControl());
    }

    public DataExplorerTreeUI.DataExplorerTreeRoot getTreeSelection() {
        return this.treeSelection;
    }

    public void savePath() {
        this.explorerTreeUI.saveLastDirectoryPath();
    }

    private final class WizardMultiDataExplorerTreeUI
    extends MultiDataExplorerTreeUI {
        private InputEntriesWizardPage page;

        private WizardMultiDataExplorerTreeUI(Composite parent, SupplierFileIdentifierCache identifierCache, IPreferenceStore preferenceStore, InputEntriesWizardPage page) {
            super(parent, identifierCache, preferenceStore);
            this.page = page;
        }

        protected void handleSelection(File[] files, DataExplorerTreeUI treeUI) {
            InputEntriesWizardPage.this.treeSelection = treeUI.getRoot();
            InputEntriesWizardPage.this.selectedItems.clear();
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                Map identifier = (Map)this.getIdentifierSupplier().apply(file);
                if (!identifier.isEmpty()) {
                    InputEntriesWizardPage.this.selectedItems.put(file, identifier);
                }
                ++n2;
            }
            InputEntriesWizardPage.this.validate();
        }

        protected String getUserLocationPreferenceKey() {
            String key = InputEntriesWizardPage.this.inputWizardSettings.getUserLocationPreferenceKey();
            if (key != null) {
                return key;
            }
            return super.getUserLocationPreferenceKey();
        }

        protected void handleDoubleClick(File file, DataExplorerTreeUI treeUI) {
            IWizardContainer container = this.page.getContainer();
            try {
                Method method = container.getClass().getDeclaredMethod("buttonPressed", Integer.TYPE);
                boolean accessible = method.isAccessible();
                try {
                    method.setAccessible(true);
                    method.invoke((Object)container, 16);
                }
                finally {
                    method.setAccessible(accessible);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

