/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.List;
import org.eclipse.chemclipse.pcr.model.core.IWell;
import org.eclipse.chemclipse.support.ui.provider.ListContentProvider;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.WellDataEditingSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.WellDataLabelProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.WellDataListFilter;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.WellDataTableComparator;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;

public class WellDataListUI
extends ExtendedTableViewer {
    private WellDataTableComparator tableComparator = new WellDataTableComparator();
    private WellDataListFilter listFilter = new WellDataListFilter();
    private WellDataLabelProvider labelProvider = new WellDataLabelProvider();
    private String[] titles = WellDataLabelProvider.TITLES;
    private int[] bounds = WellDataLabelProvider.BOUNDS;
    private IWell well = null;

    public WellDataListUI(Composite parent, int style) {
        super(parent, style);
        this.createColumns();
    }

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.listFilter.setSearchText(searchText, caseSensitive);
        this.refresh();
    }

    public void setInput(IWell well) {
        this.well = well;
        if (well != null) {
            super.setInput((Object)well.getData());
        } else {
            this.clear();
        }
    }

    public void clear() {
        super.setInput(null);
    }

    public void sortTable() {
        int column = 0;
        int sortOrder = -1;
        this.tableComparator.setColumn(column);
        this.tableComparator.setDirection(sortOrder);
        this.refresh();
    }

    public IWell getWell() {
        return this.well;
    }

    private void createColumns() {
        this.createColumns(this.titles, this.bounds);
        this.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.setContentProvider((IContentProvider)new ListContentProvider());
        this.setComparator((ViewerComparator)this.tableComparator);
        this.setFilters(new ViewerFilter[]{this.listFilter});
        this.setEditingSupport();
    }

    private void setEditingSupport() {
        List tableViewerColumns = this.getTableViewerColumns();
        int i = 0;
        while (i < tableViewerColumns.size()) {
            TableViewerColumn tableViewerColumn = (TableViewerColumn)tableViewerColumns.get(i);
            String label = tableViewerColumn.getColumn().getText();
            if (label.equals("Value")) {
                tableViewerColumn.setEditingSupport((EditingSupport)new WellDataEditingSupport(this, label));
            }
            ++i;
        }
    }
}

