/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.List;
import org.eclipse.chemclipse.support.ui.provider.ListContentProvider;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.TargetListFilter;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.TargetsComparator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.TargetsEditingSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.TargetsLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;

public class TargetsListUI
extends ExtendedTableViewer {
    private static final String[] TITLES = TargetsLabelProvider.TITLES;
    private static final int[] BOUNDS = TargetsLabelProvider.BOUNDS;
    private final TargetsLabelProvider labelProvider = new TargetsLabelProvider();
    private final TargetsComparator targetsTableComparator = new TargetsComparator();
    private final TargetListFilter targetListFilter = new TargetListFilter();

    public TargetsListUI(Composite parent, int style) {
        this(parent, TITLES, style);
    }

    public TargetsListUI(Composite parent, String[] alternativeTitles, int style) {
        super(parent, style | 2 | 0x100 | 0x200 | 0x10000);
        this.createColumns(alternativeTitles, BOUNDS);
        this.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.setContentProvider((IContentProvider)new ListContentProvider());
        this.setComparator((ViewerComparator)this.targetsTableComparator);
        this.setFilters(new ViewerFilter[]{this.targetListFilter});
    }

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.targetListFilter.setSearchText(searchText, caseSensitive);
        this.refresh();
    }

    public void clear() {
        this.setInput(null);
    }

    public void sortTable() {
        int column = 0;
        int sortOrder = -1;
        this.targetsTableComparator.setColumn(column);
        this.targetsTableComparator.setDirection(sortOrder);
        this.refresh();
        this.targetsTableComparator.setDirection(1 - sortOrder);
        this.targetsTableComparator.setColumn(column);
    }

    public void setEditingSupport() {
        List tableViewerColumns = this.getTableViewerColumns();
        int i = 0;
        while (i < tableViewerColumns.size()) {
            TableViewerColumn tableViewerColumn = (TableViewerColumn)tableViewerColumns.get(i);
            String label = tableViewerColumn.getColumn().getText();
            if (label.equals("Verified (manually)")) {
                tableViewerColumn.setEditingSupport((EditingSupport)new TargetsEditingSupport(this, label));
            } else if (label.equals("Name")) {
                tableViewerColumn.setEditingSupport((EditingSupport)new TargetsEditingSupport(this, label));
            } else if (label.equals("CAS")) {
                tableViewerColumn.setEditingSupport((EditingSupport)new TargetsEditingSupport(this, label));
            } else if (label.equals("Comments")) {
                tableViewerColumn.setEditingSupport((EditingSupport)new TargetsEditingSupport(this, label));
            } else if (label.equals("Formula")) {
                tableViewerColumn.setEditingSupport((EditingSupport)new TargetsEditingSupport(this, label));
            } else if (label.equals("SMILES")) {
                tableViewerColumn.setEditingSupport((EditingSupport)new TargetsEditingSupport(this, label));
            } else if (label.equals("InChI")) {
                tableViewerColumn.setEditingSupport((EditingSupport)new TargetsEditingSupport(this, label));
            } else if (label.equals("Contributor")) {
                tableViewerColumn.setEditingSupport((EditingSupport)new TargetsEditingSupport(this, label));
            } else if (label.equals("Reference ID")) {
                tableViewerColumn.setEditingSupport((EditingSupport)new TargetsEditingSupport(this, label));
            }
            ++i;
        }
    }
}

