/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonTransition;
import org.eclipse.chemclipse.msd.model.core.IRegularMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.Fonts;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.charts.BarSeriesValue;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.charts.BarSeriesYComparator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.support.SignalType;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ScanChartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ScanDataSupport;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.barcharts.IBarSeriesData;
import org.eclipse.swtchart.extensions.barcharts.IBarSeriesSettings;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IAxisSettings;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.RangeRestriction;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.customcharts.MassSpectrumChart;
import org.eclipse.swtchart.extensions.exceptions.SeriesException;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;

public class ScanChartUI
extends ScrollableChart {
    private static final int LENGTH_HINT_DATA_POINTS = 5000;
    private static final int COMPRESS_TO_LENGTH = Integer.MAX_VALUE;
    private int labelHighestIntensities = 5;
    private boolean addModuloLabels = false;
    private DecimalFormat defaultDecimalFormat = ValueFormat.getDecimalFormatEnglish();
    private DecimalFormat decimalFormatQ3 = ValueFormat.getDecimalFormatEnglish((String)"0.0");
    private BarSeriesYComparator barSeriesIntensityComparator = new BarSeriesYComparator();
    private Map<Double, String> customLabels = new HashMap<Double, String>();
    private LabelPaintListener labelPaintListenerX = new LabelPaintListener(true);
    private LabelPaintListener labelPaintListenerY = new LabelPaintListener(false);
    private MassSpectrumChart.LabelOption labelOption;
    private DataType dataType;
    private SignalType signalType;
    private DecimalFormat decimalFormatNormalIntensity = ValueFormat.getDecimalFormatEnglish((String)"0");
    private DecimalFormat decimalFormatLowIntensity = ValueFormat.getDecimalFormatEnglish((String)"0.0000");
    private ScanChartSupport scanChartSupport = new ScanChartSupport();
    private Font font = DisplayUtils.getDisplay().getSystemFont();
    private ScanDataSupport scanDataSupport = new ScanDataSupport();

    public ScanChartUI() {
        this.setDefaultDataAndSignalType();
    }

    public ScanChartUI(Composite parent, int style) {
        super(parent, style);
        this.setDefaultDataAndSignalType();
    }

    public void setInput(IScan scan) {
        this.prepareChart();
        if (scan != null) {
            this.extractCustomLabels(scan);
            DataType usedDataType = this.determineDataType(scan);
            SignalType usedSignalType = this.determineSignalType(scan);
            this.modifyChart(usedDataType);
            this.determineLabelOption(usedDataType);
            this.modifyChart(scan, null);
            IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
            Color colorScan1 = Colors.getColor((String)preferenceStore.getString("colorScan1"));
            if (usedSignalType.equals((Object)SignalType.PROFILE)) {
                ArrayList<ILineSeriesData> lineSeriesDataList = new ArrayList<ILineSeriesData>();
                ILineSeriesData lineSeriesData = this.scanChartSupport.getLineSeriesData(scan, "", false);
                lineSeriesData.getSettings().setLineColor(colorScan1);
                lineSeriesDataList.add(lineSeriesData);
                this.addLineSeriesData(lineSeriesDataList);
            } else {
                ArrayList<IBarSeriesData> barSeriesDataList = new ArrayList<IBarSeriesData>();
                IBarSeriesData barSeriesData = this.scanChartSupport.getBarSeriesData(scan, "", false);
                barSeriesData.getSettings().setBarColor(colorScan1);
                barSeriesDataList.add(barSeriesData);
                this.addBarSeriesData(barSeriesDataList);
            }
        }
    }

    public void setInput(IScan scan1, IScan scan2, boolean mirrored) {
        this.prepareChart();
        if (scan1 != null) {
            this.extractCustomLabels(scan1);
            DataType usedDataType = this.determineDataType(scan1);
            SignalType usedSignalType = this.determineSignalType(scan1);
            this.modifyChart(usedDataType);
            this.determineLabelOption(usedDataType);
            this.modifyChart(mirrored);
            this.modifyChart(scan1, scan2);
            String labelScan1 = "scan1";
            String labelScan2 = "scan2";
            IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
            Color colorScan1 = Colors.getColor((String)preferenceStore.getString("colorScan1"));
            Color colorScan2 = Colors.getColor((String)preferenceStore.getString("colorScan2"));
            if (usedSignalType.equals((Object)SignalType.PROFILE)) {
                ArrayList<ILineSeriesData> lineSeriesDataList = new ArrayList<ILineSeriesData>();
                ILineSeriesData lineSeriesDataScan1 = this.scanChartSupport.getLineSeriesData(scan1, labelScan1, false);
                ILineSeriesData lineSeriesDataScan2 = this.scanChartSupport.getLineSeriesData(scan2, labelScan2, mirrored);
                lineSeriesDataScan1.getSettings().setLineColor(colorScan1);
                lineSeriesDataScan2.getSettings().setLineColor(colorScan2);
                lineSeriesDataList.add(lineSeriesDataScan1);
                lineSeriesDataList.add(lineSeriesDataScan2);
                this.addLineSeriesData(lineSeriesDataList);
            } else {
                ArrayList<IBarSeriesData> barSeriesDataList = new ArrayList<IBarSeriesData>();
                IBarSeriesData barSeriesDataScan1 = this.scanChartSupport.getBarSeriesData(scan1, labelScan1, false);
                IBarSeriesData barSeriesDataScan2 = this.scanChartSupport.getBarSeriesData(scan2, labelScan2, mirrored);
                IBarSeriesSettings barSeriesSettings1 = barSeriesDataScan1.getSettings();
                IBarSeriesSettings barSeriesSettings2 = barSeriesDataScan2.getSettings();
                barSeriesSettings1.setBarColor(colorScan1);
                barSeriesSettings1.setBarOverlay(true);
                barSeriesSettings2.setBarColor(colorScan2);
                barSeriesSettings2.setBarOverlay(true);
                barSeriesDataList.add(barSeriesDataScan1);
                barSeriesDataList.add(barSeriesDataScan2);
                this.addBarSeriesData(barSeriesDataList);
            }
        }
    }

    private void prepareChart() {
        this.customLabels.clear();
        this.deleteSeries();
    }

    private void modifyChart(IScan scan1, IScan scan2) {
        boolean forceZeroY = this.isForceZeroMinY(scan1);
        if (!forceZeroY && scan2 != null) {
            forceZeroY = this.isForceZeroMinY(scan2);
        }
        IChartSettings chartSettings = this.getChartSettings();
        RangeRestriction rangeRestriction = chartSettings.getRangeRestriction();
        rangeRestriction.setForceZeroMinY(forceZeroY);
        this.applySettings(chartSettings);
    }

    private boolean isForceZeroMinY(IScan scan) {
        boolean forceZeroY = false;
        if (scan instanceof IScanMSD) {
            IScanMSD scanMSD = (IScanMSD)scan;
            forceZeroY = scanMSD.getNumberOfIons() == 1;
        } else if (scan instanceof IScanCSD) {
            forceZeroY = true;
        } else if (scan instanceof IScanWSD) {
            IScanWSD scanWSD = (IScanWSD)scan;
            forceZeroY = scanWSD.getNumberOfScanSignals() == 1;
        }
        return forceZeroY;
    }

    private void modifyChart(boolean mirrored) {
        IChartSettings chartSettings = this.getChartSettings();
        RangeRestriction rangeRestriction = chartSettings.getRangeRestriction();
        rangeRestriction.setZeroY(!mirrored);
        rangeRestriction.setForceZeroMinY(mirrored);
        rangeRestriction.setExtendTypeY(RangeRestriction.ExtendType.RELATIVE);
        rangeRestriction.setExtendMinY(mirrored ? 0.25 : 0.0);
        rangeRestriction.setExtendMaxY(0.25);
        this.applySettings(chartSettings);
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public void setSignalType(SignalType signalType) {
        this.signalType = signalType;
    }

    private void setDefaultDataAndSignalType() {
        this.dataType = DataType.AUTO_DETECT;
        this.signalType = SignalType.AUTO_DETECT;
        this.modifyChart(DataType.MSD_NOMINAL);
    }

    private DataType determineDataType(IScan scan) {
        IScanMSD scanMSD;
        DataType usedDataType = this.dataType.equals((Object)DataType.AUTO_DETECT) ? (scan instanceof IScanMSD ? ((scanMSD = (IScanMSD)scan).isTandemMS() ? DataType.MSD_TANDEM : (scanMSD.isHighResolutionMS() ? DataType.MSD_HIGHRES : DataType.MSD_NOMINAL)) : (scan instanceof IScanCSD ? DataType.CSD : (scan instanceof IScanWSD ? DataType.WSD : DataType.MSD_NOMINAL))) : this.dataType;
        return usedDataType;
    }

    private SignalType determineSignalType(IScan scan) {
        SignalType usedSignalType;
        if (this.signalType.equals((Object)SignalType.AUTO_DETECT)) {
            usedSignalType = SignalType.CENTROID;
            if (scan instanceof IRegularMassSpectrum) {
                IRegularMassSpectrum massSpectrum = (IRegularMassSpectrum)scan;
                if (massSpectrum.getMassSpectrumType() == 1) {
                    usedSignalType = SignalType.PROFILE;
                }
            } else if (scan instanceof IScanWSD) {
                IScanWSD scanWSD = (IScanWSD)scan;
                usedSignalType = scanWSD.getNumberOfScanSignals() > 1 ? SignalType.PROFILE : SignalType.CENTROID;
            }
        } else {
            usedSignalType = this.signalType;
        }
        return usedSignalType;
    }

    private void determineLabelOption(DataType dataType) {
        switch (dataType) {
            case MSD_NOMINAL: {
                this.labelOption = MassSpectrumChart.LabelOption.NOMIMAL;
                break;
            }
            case MSD_TANDEM: {
                this.labelOption = MassSpectrumChart.LabelOption.CUSTOM;
                break;
            }
            case MSD_HIGHRES: {
                this.labelOption = MassSpectrumChart.LabelOption.EXACT;
                break;
            }
            case CSD: {
                this.labelOption = MassSpectrumChart.LabelOption.NOMIMAL;
                break;
            }
            case WSD: {
                this.labelOption = MassSpectrumChart.LabelOption.NOMIMAL;
                break;
            }
            default: {
                this.labelOption = MassSpectrumChart.LabelOption.NOMIMAL;
            }
        }
    }

    private void extractCustomLabels(IScan scan) {
        IScanMSD scanMSD;
        if (scan instanceof IScanMSD && (scanMSD = (IScanMSD)scan).isTandemMS()) {
            for (IIon ion : scanMSD.getIons()) {
                IIonTransition ionTransition = ion.getIonTransition();
                if (ionTransition != null) {
                    this.customLabels.put(ion.getIon(), String.valueOf(ionTransition.getQ1Ion()) + " > " + this.decimalFormatQ3.format(ion.getIon()) + " @" + (int)ionTransition.getCollisionEnergy());
                    continue;
                }
                this.customLabels.put(ion.getIon(), Double.toString(ion.getIon()));
            }
        }
    }

    private void modifyChart(DataType dataType) {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        String name = preferenceStore.getString("scanLabelFontName");
        int height = preferenceStore.getInt("scanLabelFontSize");
        int style = preferenceStore.getInt("scanLabelFontStyle");
        this.font = Fonts.getCachedFont((Device)this.getBaseChart().getDisplay(), (String)name, (int)height, (int)style);
        this.labelHighestIntensities = preferenceStore.getInt("scanLabelHighestIntensities");
        this.addModuloLabels = preferenceStore.getBoolean("scanLabelModuloIntensities");
        boolean enableCompress = preferenceStore.getBoolean("scanChartEnableCompress");
        IChartSettings chartSettings = this.getChartSettings();
        chartSettings.setCreateMenu(true);
        chartSettings.setEnableCompress(enableCompress);
        RangeRestriction rangeRestriction = chartSettings.getRangeRestriction();
        rangeRestriction.setRestrictZoom(true);
        rangeRestriction.setExtendTypeX(RangeRestriction.ExtendType.ABSOLUTE);
        rangeRestriction.setExtendMinX(2.0);
        rangeRestriction.setExtendMaxX(2.0);
        rangeRestriction.setExtendTypeY(RangeRestriction.ExtendType.RELATIVE);
        rangeRestriction.setExtendMinY(0.0);
        rangeRestriction.setExtendMaxY(0.25);
        rangeRestriction.setForceZeroMinY(false);
        rangeRestriction.setZeroY(true);
        LabelPaintListener labelPaintListener = this.labelPaintListenerX;
        switch (dataType) {
            case MSD_NOMINAL: {
                this.scanDataSupport.setDataTypeMSD(chartSettings);
                break;
            }
            case MSD_TANDEM: {
                this.scanDataSupport.setDataTypeMSD(chartSettings);
                break;
            }
            case MSD_HIGHRES: {
                this.scanDataSupport.setDataTypeMSD(chartSettings);
                break;
            }
            case CSD: {
                labelPaintListener = this.labelPaintListenerY;
                rangeRestriction.setExtendTypeX(RangeRestriction.ExtendType.RELATIVE);
                rangeRestriction.setExtendMinX(0.1);
                rangeRestriction.setExtendMaxX(0.1);
                rangeRestriction.setZeroY(false);
                this.scanDataSupport.setDataTypeCSD(chartSettings);
                break;
            }
            case WSD: {
                this.scanDataSupport.setDataTypeWSD(chartSettings);
                rangeRestriction.setZeroY(false);
                break;
            }
            default: {
                this.scanDataSupport.setDataTypeMSD(chartSettings);
            }
        }
        this.applySettings(chartSettings);
        this.addSeriesLabelMarker(labelPaintListener);
    }

    private void addBarSeriesData(List<IBarSeriesData> barSeriesDataList) {
        if (barSeriesDataList != null && barSeriesDataList.size() > 0) {
            BaseChart baseChart = this.getBaseChart();
            baseChart.suspendUpdate(true);
            for (IBarSeriesData barSeriesData : barSeriesDataList) {
                try {
                    ISeriesData seriesData = barSeriesData.getSeriesData();
                    ISeriesData optimizedSeriesData = this.calculateSeries(seriesData, Integer.MAX_VALUE);
                    IBarSeriesSettings barSeriesSettings = barSeriesData.getSettings();
                    barSeriesSettings.getSeriesSettingsHighlight();
                    IBarSeries barSeries = (IBarSeries)this.createSeries(optimizedSeriesData, (ISeriesSettings)barSeriesSettings);
                    barSeriesSettings.setBarOverlay(true);
                    baseChart.applyBarSeriesSettings(barSeries, barSeriesSettings);
                    if (this.isLargeDataSet(optimizedSeriesData.getXSeries(), optimizedSeriesData.getYSeries(), 5000)) {
                        barSeries.setBarWidthStyle(IBarSeries.BarWidthStyle.STRETCHED);
                        continue;
                    }
                    barSeries.setBarWidthStyle(barSeriesSettings.getBarWidthStyle());
                }
                catch (SeriesException seriesException) {
                    // empty catch block
                }
            }
            baseChart.suspendUpdate(false);
            this.adjustRange(true);
            baseChart.redraw();
        }
    }

    private void addLineSeriesData(List<ILineSeriesData> lineSeriesDataList) {
        if (lineSeriesDataList != null && lineSeriesDataList.size() > 0) {
            BaseChart baseChart = this.getBaseChart();
            baseChart.suspendUpdate(true);
            for (ILineSeriesData lineSeriesData : lineSeriesDataList) {
                try {
                    ISeriesData seriesData = lineSeriesData.getSeriesData();
                    ISeriesData optimizedSeriesData = this.calculateSeries(seriesData, Integer.MAX_VALUE);
                    ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
                    lineSeriesSettings.getSeriesSettingsHighlight();
                    ILineSeries lineSeries = (ILineSeries)this.createSeries(optimizedSeriesData, (ISeriesSettings)lineSeriesSettings);
                    baseChart.applyLineSeriesSettings(lineSeries, lineSeriesSettings);
                }
                catch (SeriesException seriesException) {
                    // empty catch block
                }
            }
            baseChart.suspendUpdate(false);
            this.adjustRange(true);
            baseChart.redraw();
        }
    }

    private void addSeriesLabelMarker(LabelPaintListener labelPaintListener) {
        IPlotArea plotArea = this.getBaseChart().getPlotArea();
        plotArea.removeCustomPaintListener((ICustomPaintListener)this.labelPaintListenerX);
        plotArea.removeCustomPaintListener((ICustomPaintListener)this.labelPaintListenerY);
        plotArea.addCustomPaintListener((ICustomPaintListener)labelPaintListener);
    }

    private void printLabel(BarSeriesValue barSeriesValue, boolean useX, PaintEvent e) {
        Font currentFont = e.gc.getFont();
        e.gc.setFont(this.font);
        Point point = barSeriesValue.getPoint();
        String label = useX ? this.getLabel(barSeriesValue.getX()) : this.getLabel(barSeriesValue.getY());
        boolean negative = barSeriesValue.getY() < 0.0;
        Point labelSize = e.gc.textExtent(label);
        int x = (int)((double)point.x + 0.5 - (double)labelSize.x / 2.0);
        int y = point.y;
        if (!negative) {
            y = point.y - labelSize.y;
        }
        e.gc.drawText(label, x, y, true);
        e.gc.setFont(currentFont);
    }

    private String getLabel(double value) {
        String label;
        switch (this.labelOption) {
            case NOMIMAL: {
                if (value > -1.0 && value < 0.0 || value > 0.0 && value < 1.0) {
                    label = this.decimalFormatLowIntensity.format(value);
                    break;
                }
                label = this.decimalFormatNormalIntensity.format(value);
                break;
            }
            case EXACT: {
                DecimalFormat decimalFormat = this.getDecimalFormatValue();
                label = decimalFormat.format(value);
                break;
            }
            case CUSTOM: {
                label = this.customLabels.get(value);
                if (label != null) break;
                label = "";
                break;
            }
            default: {
                label = "";
            }
        }
        return label;
    }

    private List<BarSeriesValue> getBarSeriesValuesList() {
        ISeries[] series;
        ArrayList<BarSeriesValue> barSeriesIons = new ArrayList<BarSeriesValue>();
        int widthPlotArea = this.getBaseChart().getPlotArea().getSize().x;
        ISeries[] iSeriesArray = series = this.getBaseChart().getSeriesSet().getSeries();
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries barSeries = iSeriesArray[n2];
            if (barSeries != null) {
                double[] xSeries = barSeries.getXSeries();
                double[] ySeries = barSeries.getYSeries();
                int size = barSeries.getXSeries().length;
                int i = 0;
                while (i < size) {
                    Point point = barSeries.getPixelCoordinates(i);
                    if (point.x >= 0 && point.x <= widthPlotArea) {
                        barSeriesIons.add(new BarSeriesValue(xSeries[i], ySeries[i], point));
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return barSeriesIons;
    }

    private DecimalFormat getDecimalFormatValue() {
        IAxisSettings axisSettings = this.getBaseChart().getXAxisSettings(0);
        if (axisSettings != null) {
            return axisSettings.getDecimalFormat();
        }
        return this.defaultDecimalFormat;
    }

    private class LabelPaintListener
    implements ICustomPaintListener {
        private boolean useX;

        public LabelPaintListener(boolean useX) {
            this.useX = useX;
        }

        public void paintControl(PaintEvent e) {
            List barSeriesValues = ScanChartUI.this.getBarSeriesValuesList();
            Collections.sort(barSeriesValues, ScanChartUI.this.barSeriesIntensityComparator);
            this.printHighestLabelsNormal(barSeriesValues, e);
            this.printHighestLabelsMirrored(barSeriesValues, e);
        }

        private void printHighestLabelsNormal(List<BarSeriesValue> barSeriesValues, PaintEvent e) {
            int size = barSeriesValues.size();
            int modulo = size / ScanChartUI.this.labelHighestIntensities;
            int limit = ScanChartUI.this.labelHighestIntensities < size ? ScanChartUI.this.labelHighestIntensities : size;
            int i = 0;
            while (i < size) {
                BarSeriesValue barSeriesValue;
                if (i < limit) {
                    barSeriesValue = barSeriesValues.get(i);
                    ScanChartUI.this.printLabel(barSeriesValue, this.useX, e);
                } else if (ScanChartUI.this.addModuloLabels && i % modulo == 0) {
                    barSeriesValue = barSeriesValues.get(i);
                    ScanChartUI.this.printLabel(barSeriesValue, this.useX, e);
                }
                ++i;
            }
        }

        private void printHighestLabelsMirrored(List<BarSeriesValue> barSeriesValues, PaintEvent e) {
            int size = barSeriesValues.size();
            int limit = size - ScanChartUI.this.labelHighestIntensities;
            limit = limit < 0 ? 0 : limit;
            int modulo = size / ScanChartUI.this.labelHighestIntensities;
            int i = size - 1;
            while (i >= 0) {
                BarSeriesValue barSeriesValue;
                if (i >= limit) {
                    barSeriesValue = barSeriesValues.get(i);
                    if (barSeriesValue.getY() < 0.0) {
                        ScanChartUI.this.printLabel(barSeriesValue, this.useX, e);
                    }
                } else if (ScanChartUI.this.addModuloLabels && i % modulo == 0 && (barSeriesValue = barSeriesValues.get(i)).getY() < 0.0) {
                    ScanChartUI.this.printLabel(barSeriesValue, this.useX, e);
                }
                --i;
            }
        }

        public boolean drawBehindSeries() {
            return false;
        }
    }
}

