/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.pcr.model.core.IChannel;
import org.eclipse.chemclipse.pcr.model.core.IWell;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.charts.ChartPCR;
import org.eclipse.chemclipse.ux.extension.xxd.ui.model.ColorCode;
import org.eclipse.chemclipse.ux.extension.xxd.ui.model.ColorCodes;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePagePCR;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.SeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.linecharts.LineSeriesData;

public class ExtendedWellChartUI {
    private static final Logger logger = Logger.getLogger(ExtendedWellChartUI.class);
    private Label labelInfo;
    private Composite toolbarInfo;
    private Combo comboChannels;
    private ChartPCR chartPCR;
    private IWell well = null;
    private IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();

    @Inject
    public ExtendedWellChartUI(Composite parent) {
        this.initialize(parent);
    }

    public void update(IWell well) {
        this.well = well;
        this.updateLabel();
        this.updateChannelCombo();
        this.updateChartData();
    }

    private void updateLabel() {
        if (this.well != null) {
            this.labelInfo.setText(this.well.getLabel());
        } else {
            this.labelInfo.setText("No well data available.");
        }
    }

    private void updateChannelCombo() {
        if (this.well != null) {
            if (this.well.isEmptyMeasurement()) {
                this.comboChannels.setItems(new String[0]);
            } else {
                this.comboChannels.setItems(this.getComboItems(this.well));
                IChannel channel = this.well.getActiveChannel();
                if (channel != null) {
                    String name = channel.getDetectionName();
                    String[] items = this.comboChannels.getItems();
                    int i = 0;
                    while (i < items.length) {
                        if (items[i].equals(name)) {
                            this.comboChannels.select(i);
                            break;
                        }
                        ++i;
                    }
                } else {
                    this.comboChannels.select(0);
                }
            }
        } else {
            this.comboChannels.setItems(new String[]{""});
        }
    }

    private void updateChartData() {
        this.chartPCR.deleteSeries();
        if (this.well != null && !this.well.isEmptyMeasurement()) {
            this.updateChart();
        }
    }

    private String[] getComboItems(IWell well) {
        if (well != null) {
            ArrayList<String> items = new ArrayList<String>();
            items.add("All Channels");
            for (IChannel channel : well.getChannels().values()) {
                items.add(channel.getDetectionName());
            }
            return items.toArray(new String[items.size()]);
        }
        return new String[0];
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.toolbarInfo = this.createToolbarInfo(parent);
        this.comboChannels = this.createComboChannels(parent);
        this.chartPCR = this.createChart(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfo, (boolean)true);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(4, false));
        this.createButtonToggleToolbarInfo(composite);
        this.createToggleChartLegendButton(composite);
        this.createResetButton(composite);
        this.createSettingsButton(composite);
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedWellChartUI.this.toolbarInfo);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private void createToggleChartLegendButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the chart legend");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/tag.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedWellChartUI.this.chartPCR.toggleSeriesLegendVisibility();
            }
        });
    }

    private void createResetButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset the Chart");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedWellChartUI.this.updateChart();
            }
        });
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePagePCR preferencePage = new PreferencePagePCR();
                preferencePage.setTitle("PCR");
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)preferencePage));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedWellChartUI.this.updateChart();
                    }
                    catch (Exception e1) {
                        logger.warn((Object)e1);
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the chart settings.");
                    }
                }
            }
        });
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelInfo = new Label(composite, 0);
        this.labelInfo.setText("");
        this.labelInfo.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Combo createComboChannels(Composite parent) {
        Combo combo = new Combo(parent, 8);
        combo.setLayoutData((Object)new GridData(768));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedWellChartUI.this.updateChart();
            }
        });
        return combo;
    }

    private ChartPCR createChart(Composite parent) {
        ChartPCR chart = new ChartPCR(parent, 0);
        chart.setLayoutData(new GridData(1808));
        return chart;
    }

    private void updateChart() {
        this.chartPCR.deleteSeries();
        if (this.well != null) {
            ColorCodes colorCodes = new ColorCodes();
            colorCodes.load(this.preferenceStore.getString("pcrColorCodes"));
            Color color = this.getWellColor(this.well, colorCodes);
            ArrayList<ILineSeriesData> lineSeriesDataList = new ArrayList<ILineSeriesData>();
            int index = this.comboChannels.getSelectionIndex();
            if (index == 0) {
                for (IChannel channel : this.well.getChannels().values()) {
                    this.addChannelData(channel, lineSeriesDataList, color);
                }
            } else {
                try {
                    IChannel channel = (IChannel)this.well.getChannels().get(index - 1);
                    this.addChannelData(channel, lineSeriesDataList, color);
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)e);
                }
            }
            this.chartPCR.addSeriesData(lineSeriesDataList);
        }
    }

    private Color getWellColor(IWell well, ColorCodes colorCodes) {
        String sampleSubset = well.getSampleSubset();
        String targetName = well.getTargetName();
        if (colorCodes.containsKey(sampleSubset)) {
            return ((ColorCode)colorCodes.get(sampleSubset)).getColor();
        }
        if (colorCodes.containsKey(targetName)) {
            return ((ColorCode)colorCodes.get(targetName)).getColor();
        }
        return Colors.getColor((String)this.preferenceStore.getString("pcrDefaultColor"));
    }

    private void addChannelData(IChannel channel, List<ILineSeriesData> lineSeriesDataList, Color color) {
        ILineSeriesData crossingPoint;
        ILineSeriesData channelCurve = this.getChannelCurve(channel, color);
        if (channelCurve != null) {
            lineSeriesDataList.add(channelCurve);
        }
        if ((crossingPoint = this.getCrossingPoint(channel, color)) != null) {
            lineSeriesDataList.add(crossingPoint);
        }
    }

    private ILineSeriesData getChannelCurve(IChannel channel, Color color) {
        LineSeriesData lineSeriesData = null;
        if (channel != null) {
            List pointList = channel.getPoints();
            double[] points = new double[pointList.size()];
            int index = 0;
            while (index < pointList.size()) {
                points[index] = (Double)pointList.get(index);
                ++index;
            }
            SeriesData seriesData = new SeriesData(points, "Channel " + channel.getId());
            lineSeriesData = new LineSeriesData((ISeriesData)seriesData);
            ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
            lineSeriesSettings.setLineColor(color);
            lineSeriesSettings.setSymbolColor(color);
            lineSeriesSettings.setSymbolSize(2);
            lineSeriesSettings.setSymbolType(ILineSeries.PlotSymbolType.CIRCLE);
            lineSeriesSettings.setEnableArea(false);
        }
        return lineSeriesData;
    }

    private ILineSeriesData getCrossingPoint(IChannel channel, Color color) {
        IPoint crossingPoint;
        LineSeriesData lineSeriesData = null;
        if (channel != null && (crossingPoint = channel.getCrossingPoint()) != null) {
            double[] xSeries = new double[]{crossingPoint.getX()};
            double[] ySeries = new double[]{crossingPoint.getY()};
            SeriesData seriesData = new SeriesData(xSeries, ySeries, "Crossing Point " + channel.getId());
            lineSeriesData = new LineSeriesData((ISeriesData)seriesData);
            ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
            lineSeriesSettings.setSymbolColor(color);
            lineSeriesSettings.setSymbolSize(8);
            lineSeriesSettings.setSymbolType(ILineSeries.PlotSymbolType.CROSS);
            lineSeriesSettings.setEnableArea(false);
        }
        return lineSeriesData;
    }
}

