/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.ITargetSupplier;
import org.eclipse.chemclipse.model.identifier.ComparisonResult;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.LibraryInformation;
import org.eclipse.chemclipse.model.implementation.IdentificationTarget;
import org.eclipse.chemclipse.model.targets.ITarget;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.support.ui.events.IKeyEventProcessor;
import org.eclipse.chemclipse.support.ui.menu.ITableMenuEntry;
import org.eclipse.chemclipse.support.ui.swt.ControlBuilder;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.support.ui.swt.IColumnMoveListener;
import org.eclipse.chemclipse.support.ui.swt.ITableSettings;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.support.util.TargetListUtil;
import org.eclipse.chemclipse.support.validators.TargetValidator;
import org.eclipse.chemclipse.swt.ui.components.ISearchListener;
import org.eclipse.chemclipse.swt.ui.components.SearchSupportUI;
import org.eclipse.chemclipse.swt.ui.preferences.PreferencePageSWT;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.ListSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageLists;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageTargets;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.TargetsListUI;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ExtendedTargetsUI {
    private static final String IDENTIFIER_MANUAL = "Manual";
    private static final String MENU_CATEGORY_TARGETS = "Targets";
    private Label labelTargetOption;
    private Label labelInfo;
    private Composite toolbarInfo;
    private Composite toolbarSearch;
    private Composite toolbarModify;
    private Label labelInputErrors;
    private Combo comboTargetName;
    private Button buttonAddTarget;
    private Button buttonDeleteTarget;
    private TargetsListUI targetListUI;
    private final TargetListUtil targetListUtil;
    private TargetValidator targetValidator;
    private ControlDecoration targetControlDecoration;
    private Object object;
    private final Map<String, Object> map;
    private boolean showChromatogramTargets = false;
    private final ListSupport listSupport = new ListSupport();

    @Inject
    public ExtendedTargetsUI(Composite parent) {
        this.targetListUtil = new TargetListUtil();
        this.map = new HashMap<String, Object>();
        this.initialize(parent);
    }

    @Focus
    public void setFocus() {
        this.updateTargets();
    }

    public void update(Object object) {
        if (object instanceof IChromatogram) {
            if (this.showChromatogramTargets) {
                this.object = object;
                this.updateTargets();
            }
        } else if (object != null) {
            if (!this.showChromatogramTargets) {
                this.object = object;
                this.updateTargets();
            }
        } else {
            this.object = object;
            this.updateTargets();
        }
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.toolbarInfo = this.createToolbarInfo(parent);
        this.toolbarSearch = this.createToolbarSearch(parent);
        this.toolbarModify = this.createToolbarModify(parent);
        this.targetListUI = this.createTargetTable(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfo, (boolean)true);
        PartSupport.setCompositeVisibility((Composite)this.toolbarSearch, (boolean)false);
        PartSupport.setCompositeVisibility((Composite)this.toolbarModify, (boolean)false);
        this.targetListUI.setEditEnabled(false);
        this.clearLabelInputErrors();
        this.applySettings();
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(7, false));
        this.createTargetOptionLabel(composite);
        this.createButtonToggleToolbarInfo(composite);
        this.createButtonToggleOptionTargets(composite);
        this.createButtonToggleToolbarSearch(composite);
        this.createButtonToggleToolbarModify(composite);
        this.createButtonToggleEditModus(composite);
        this.createSettingsButton(composite);
        this.updateTargetOptionLabel();
    }

    private void createTargetOptionLabel(Composite parent) {
        this.labelTargetOption = new Label(parent, 0);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.labelTargetOption.setLayoutData((Object)gridData);
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedTargetsUI.this.toolbarInfo);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleOptionTargets(Composite parent) {
        final Image imageChromatogram = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/chromatogram.gif", "16x16");
        final Image imageScan = ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/massSpectrum.gif", "16x16");
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle whether to display chromatogram or scan/peak targets.");
        button.setText("");
        button.setImage(this.showChromatogramTargets ? imageChromatogram : imageScan);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedTargetsUI.this.showChromatogramTargets = !ExtendedTargetsUI.this.showChromatogramTargets;
                button.setImage(ExtendedTargetsUI.this.showChromatogramTargets ? imageChromatogram : imageScan);
                ExtendedTargetsUI.this.updateTargetOptionLabel();
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarSearch(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle search toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedTargetsUI.this.toolbarSearch);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarModify(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle modify toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedTargetsUI.this.toolbarModify);
                if (visible) {
                    ExtendedTargetsUI.this.setComboTargetNameItems();
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editActive.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleEditModus(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Enable/disable to edit the table.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editEntryDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean editEnabled = !ExtendedTargetsUI.this.targetListUI.isEditEnabled();
                ExtendedTargetsUI.this.targetListUI.setEditEnabled(editEnabled);
                button.setImage(ApplicationImageFactory.getInstance().getImage(editEnabled ? "org.eclipse.chemclipse.rcp.ui.icons/editEntryActive.gif" : "org.eclipse.chemclipse.rcp.ui.icons/editEntryDefault.gif", "16x16"));
                ExtendedTargetsUI.this.updateInput();
            }
        });
        return button;
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePageSWT preferencePageSWT = new PreferencePageSWT();
                preferencePageSWT.setTitle("Settings (SWT)");
                PreferencePageTargets preferencePageTargets = new PreferencePageTargets();
                preferencePageTargets.setTitle("Target Settings");
                PreferencePageLists preferencePageLists = new PreferencePageLists();
                preferencePageLists.setTitle("Lists");
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)preferencePageTargets));
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("2", (IPreferencePage)preferencePageSWT));
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("3", (IPreferencePage)preferencePageLists));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedTargetsUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the settings.");
                    }
                }
            }
        });
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelInfo = new Label(composite, 0);
        this.labelInfo.setText("");
        this.labelInfo.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Composite createToolbarSearch(Composite parent) {
        SearchSupportUI searchSupportUI = new SearchSupportUI(parent, 0);
        searchSupportUI.setLayoutData((Object)new GridData(768));
        searchSupportUI.setSearchListener(new ISearchListener(){

            public void performSearch(String searchText, boolean caseSensitive) {
                ExtendedTargetsUI.this.targetListUI.setSearchText(searchText, caseSensitive);
            }
        });
        return searchSupportUI;
    }

    private Composite createToolbarModify(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        int columns = 3;
        composite.setLayout((Layout)new GridLayout(columns, false));
        this.labelInputErrors = this.createLabel(composite, columns);
        this.comboTargetName = this.createComboTarget(composite);
        this.buttonAddTarget = this.createButtonAdd(composite);
        this.buttonDeleteTarget = this.createButtonDelete(composite);
        return composite;
    }

    private void setEditWidgetStatus(boolean enabled) {
        this.labelInputErrors.setEnabled(enabled);
        this.comboTargetName.setEnabled(enabled);
        this.buttonAddTarget.setEnabled(enabled);
        this.buttonDeleteTarget.setEnabled(enabled);
    }

    private Label createLabel(Composite parent, int horizontalSpan) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = horizontalSpan;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private Combo createComboTarget(Composite parent) {
        final Combo combo = new Combo(parent, 0);
        combo.setText("");
        combo.setToolTipText("Select a target or type in a new substance name.");
        combo.setLayoutData((Object)new GridData(768));
        this.targetValidator = new TargetValidator();
        this.targetControlDecoration = new ControlDecoration((Control)combo, 16512);
        combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ExtendedTargetsUI.this.validate((IValidator)ExtendedTargetsUI.this.targetValidator, ExtendedTargetsUI.this.targetControlDecoration, combo);
                if (e.keyCode == 10 || e.keyCode == 13 || e.keyCode == 0x1000050) {
                    ExtendedTargetsUI.this.addTarget(e.display.getActiveShell());
                }
            }
        });
        this.enableAuotComplete(combo);
        return combo;
    }

    private void enableAuotComplete(final Combo combo) {
        IContentProposalProvider proposalProvider = new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                ArrayList<ContentProposal> list = new ArrayList<ContentProposal>();
                if (contents != null) {
                    String[] items;
                    String[] stringArray = items = combo.getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String item = stringArray[n2];
                        if (item.toLowerCase().contains(contents.toLowerCase())) {
                            list.add(new ContentProposal(item));
                        }
                        ++n2;
                    }
                }
                return list.toArray(new IContentProposal[0]);
            }
        };
        ControlBuilder.autoComplete((Combo)combo, (IContentProposalProvider)proposalProvider);
    }

    private Button createButtonAdd(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Add the target.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedTargetsUI.this.addTarget(e.display.getActiveShell());
            }
        });
        return button;
    }

    private Button createButtonDelete(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Delete the selected target(s).");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedTargetsUI.this.deleteTargets(e.display.getActiveShell());
            }
        });
        return button;
    }

    private TargetsListUI createTargetTable(Composite parent) {
        TargetsListUI listUI = new TargetsListUI(parent, 2048);
        listUI.setEditingSupport();
        final Table table = listUI.getTable();
        table.setLayoutData((Object)new GridData(1808));
        listUI.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ExtendedTargetsUI.this.propagateTarget();
            }
        });
        final IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        final String preferenceName = "columnOrderTargetList";
        this.listSupport.setColumnOrder(table, preferenceStore.getString(preferenceName));
        listUI.addColumnMoveListener(new IColumnMoveListener(){

            public void handle() {
                String columnOrder = ExtendedTargetsUI.this.listSupport.getColumnOrder(table);
                preferenceStore.setValue(preferenceName, columnOrder);
            }
        });
        Shell shell = listUI.getTable().getShell();
        ITableSettings tableSettings = listUI.getTableSettings();
        this.addDeleteMenuEntry(shell, tableSettings);
        this.addVerifyTargetsMenuEntry(tableSettings);
        this.addUnverifyTargetsMenuEntry(tableSettings);
        this.addKeyEventProcessors(shell, tableSettings);
        listUI.applySettings(tableSettings);
        return listUI;
    }

    private void addDeleteMenuEntry(final Shell shell, ITableSettings tableSettings) {
        tableSettings.addMenuEntry(new ITableMenuEntry(){

            public String getName() {
                return "Delete Target(s)";
            }

            public String getCategory() {
                return ExtendedTargetsUI.MENU_CATEGORY_TARGETS;
            }

            public void execute(ExtendedTableViewer extendedTableViewer) {
                ExtendedTargetsUI.this.deleteTargets(shell);
            }
        });
    }

    private void addVerifyTargetsMenuEntry(ITableSettings tableSettings) {
        tableSettings.addMenuEntry(new ITableMenuEntry(){

            public String getName() {
                return "Verify Target(s) Check";
            }

            public String getCategory() {
                return ExtendedTargetsUI.MENU_CATEGORY_TARGETS;
            }

            public void execute(ExtendedTableViewer extendedTableViewer) {
                ExtendedTargetsUI.this.verifyTargets(true);
            }
        });
    }

    private void addUnverifyTargetsMenuEntry(ITableSettings tableSettings) {
        tableSettings.addMenuEntry(new ITableMenuEntry(){

            public String getName() {
                return "Verify Target(s) Uncheck";
            }

            public String getCategory() {
                return ExtendedTargetsUI.MENU_CATEGORY_TARGETS;
            }

            public void execute(ExtendedTableViewer extendedTableViewer) {
                ExtendedTargetsUI.this.verifyTargets(false);
            }
        });
    }

    private void addKeyEventProcessors(final Shell shell, ITableSettings tableSettings) {
        tableSettings.addKeyEventProcessor(new IKeyEventProcessor(){

            public void handleEvent(ExtendedTableViewer extendedTableViewer, KeyEvent e) {
                if (e.keyCode == 127) {
                    ExtendedTargetsUI.this.deleteTargets(shell);
                } else if (e.keyCode == 105 && (e.stateMask & 0x40000) == 262144) {
                    if ((e.stateMask & 0x10000) == 65536) {
                        ExtendedTargetsUI.this.verifyTargets(false);
                    } else {
                        ExtendedTargetsUI.this.verifyTargets(true);
                    }
                } else {
                    ExtendedTargetsUI.this.propagateTarget();
                }
            }
        });
    }

    private void verifyTargets(boolean verified) {
        for (Object object : this.targetListUI.getStructuredSelection()) {
            if (!(object instanceof IIdentificationTarget)) continue;
            IIdentificationTarget identificationTarget = (IIdentificationTarget)object;
            identificationTarget.setManuallyVerified(verified);
        }
        this.updateTargets();
    }

    private void propagateTarget() {
        TableItem tableItem;
        Object object;
        Table table = this.targetListUI.getTable();
        int index = table.getSelectionIndex();
        if (index >= 0 && (object = (tableItem = table.getItem(index)).getData()) instanceof IIdentificationTarget) {
            final IEventBroker eventBroker = ModelSupportAddon.getEventBroker();
            final IScanMSD massSpectrum = this.getMassSpectrum();
            final IIdentificationTarget target = (IIdentificationTarget)object;
            DisplayUtils.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    eventBroker.send("identification/target/update", (Object)target);
                }
            });
            if (massSpectrum != null) {
                DisplayUtils.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ExtendedTargetsUI.this.map.clear();
                        IIdentificationTarget identificationTarget = (IIdentificationTarget)object;
                        ExtendedTargetsUI.this.map.put("MassSpectrumUnknown", massSpectrum);
                        ExtendedTargetsUI.this.map.put("IdentificationTarget", identificationTarget);
                        eventBroker.send("identification/target/update/massspectrum/unknown", (Object)ExtendedTargetsUI.this.map);
                    }
                });
            }
        }
    }

    private void applySettings() {
        this.setComboTargetNameItems();
    }

    private void setComboTargetNameItems() {
        Object[] items;
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        boolean useTargetList = preferenceStore.getBoolean("useTargetList");
        if (useTargetList) {
            items = this.targetListUtil.parseString(preferenceStore.getString("targetList"));
            Arrays.sort(items);
        } else {
            items = new String[]{};
        }
        this.comboTargetName.setItems((String[])items);
    }

    private void updateTargets() {
        this.updateInput();
        this.updateWidgets();
        this.targetListUI.sortTable();
        Table table = this.targetListUI.getTable();
        if (table.getItemCount() > 0) {
            table.setSelection(0);
            IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
            boolean propagateTargetOnUpdate = preferenceStore.getBoolean("propagateTargetOnUpdate");
            if (propagateTargetOnUpdate) {
                DisplayUtils.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ExtendedTargetsUI.this.propagateTarget();
                    }
                });
            }
        }
    }

    private void updateInput() {
        if (this.object instanceof ITargetSupplier) {
            String editInformation = this.targetListUI.isEditEnabled() ? "Edit is enabled." : "Edit is disabled.";
            this.labelInfo.setText("Targets - " + editInformation);
            ITargetSupplier targetSupplier = (ITargetSupplier)this.object;
            this.targetListUI.setInput(targetSupplier.getTargets());
            this.setEditWidgetStatus(true);
        } else {
            this.labelInfo.setText("No target data has been selected yet.");
            this.targetListUI.clear();
            this.setEditWidgetStatus(false);
            PartSupport.setCompositeVisibility((Composite)this.toolbarModify, (boolean)false);
        }
    }

    private void updateWidgets() {
        boolean enabled = this.object != null;
        this.comboTargetName.setEnabled(enabled);
        this.buttonAddTarget.setEnabled(enabled);
        this.buttonDeleteTarget.setEnabled(enabled);
    }

    private void deleteTargets(Shell shell) {
        MessageBox messageBox = new MessageBox(shell, 196);
        messageBox.setText("Delete Target(s)");
        messageBox.setMessage("Would you like to delete the selected target(s)?");
        if (messageBox.open() == 64) {
            for (Object object : this.targetListUI.getStructuredSelection()) {
                if (!(object instanceof ITarget)) continue;
                this.deleteTarget((ITarget)object);
            }
            this.updateTargets();
        }
    }

    private void deleteTarget(ITarget target) {
        if (this.object instanceof ITargetSupplier) {
            ITargetSupplier targetSupplier = (ITargetSupplier)this.object;
            targetSupplier.getTargets().remove(target);
        }
    }

    private void addTarget(Shell shell) {
        boolean isInputValid = this.validate((IValidator)this.targetValidator, this.targetControlDecoration, this.comboTargetName);
        if (isInputValid) {
            this.setTarget(this.targetValidator);
        } else {
            MessageDialog.openError((Shell)shell, (String)"Add Target", (String)"The given target is invalid.");
        }
    }

    private void setTarget(TargetValidator targetValidator) {
        LibraryInformation libraryInformation = new LibraryInformation();
        libraryInformation.setName(targetValidator.getName());
        libraryInformation.setCasNumber(targetValidator.getCasNumber());
        libraryInformation.setComments(targetValidator.getComments());
        libraryInformation.setContributor(targetValidator.getContributor());
        libraryInformation.setReferenceIdentifier(targetValidator.getReferenceId());
        ComparisonResult comparisonResult = ComparisonResult.createBestMatchComparisonResult();
        IdentificationTarget identificationTarget = new IdentificationTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
        this.setIdentifier((IIdentificationTarget)identificationTarget);
        if (this.object instanceof ITargetSupplier) {
            ITargetSupplier targetSupplier = (ITargetSupplier)this.object;
            targetSupplier.getTargets().add(identificationTarget);
        }
        this.comboTargetName.setText("");
        this.updateTargets();
    }

    private IScanMSD getMassSpectrum() {
        if (this.object instanceof IScanMSD) {
            return (IScanMSD)this.object;
        }
        if (this.object instanceof IPeakMSD) {
            IPeakMSD peakMSD = (IPeakMSD)this.object;
            return peakMSD.getExtractedMassSpectrum();
        }
        return null;
    }

    private void setIdentifier(IIdentificationTarget identificationTarget) {
        identificationTarget.setIdentifier(IDENTIFIER_MANUAL);
    }

    private void updateTargetOptionLabel() {
        String text = this.showChromatogramTargets ? "Chromatogram Targets (Active)" : "Targets (Active)";
        this.labelTargetOption.setText(text);
    }

    private boolean validate(IValidator validator, ControlDecoration controlDecoration, Combo combo) {
        IStatus status = validator.validate((Object)combo.getText());
        if (status.isOK()) {
            controlDecoration.hide();
            this.clearLabelInputErrors();
            return true;
        }
        this.setLabelInputError(status.getMessage());
        controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        controlDecoration.showHoverText("Input Error");
        controlDecoration.show();
        return false;
    }

    private void clearLabelInputErrors() {
        this.labelInputErrors.setText("Example: Styrene | 100-42-5 | comment | contributor | referenceId");
        this.labelInputErrors.setBackground(null);
    }

    private void setLabelInputError(String message) {
        this.labelInputErrors.setText(message);
        this.labelInputErrors.setBackground(Colors.YELLOW);
    }
}

