/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import javax.inject.Inject;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.model.support.FilterSupport;
import org.eclipse.chemclipse.msd.swt.ui.support.DatabaseFileSupport;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageScans;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageSubtract;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ScanDataSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.EditListener;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ExtendedScanChartUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ExtendedScanTableUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ScanChartUI;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ExtendedSubtractScanUI {
    private static final Logger logger = Logger.getLogger(ExtendedScanChartUI.class);
    private TabFolder tabFolder;
    private ScanChartUI scanChartUI;
    private ExtendedScanTableUI extendedScanTableUI;
    private IScanMSD scanMSD = null;
    private IChromatogramSelectionMSD chromatogramSelectionMSD = null;

    @Inject
    public ExtendedSubtractScanUI(Composite parent) {
        this.initialize(parent);
    }

    @Focus
    public void setFocus() {
        this.updateScanData(this.scanMSD);
    }

    public void update(Object object) {
        if (object instanceof IChromatogramSelectionMSD) {
            this.chromatogramSelectionMSD = (IChromatogramSelectionMSD)object;
        } else if (object instanceof IScanMSD) {
            this.scanMSD = (IScanMSD)object;
        }
        this.updateScanData(this.scanMSD);
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.createScanTabFolderSection(parent);
        this.loadSessionMassSpectrum(parent.getDisplay());
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(6, false));
        this.createAddSelectedScanButton(composite);
        this.createAddCombinedScanButton(composite);
        this.createClearSessionButton(composite);
        this.createButtonCopyTracesClipboard(composite);
        this.createSaveButton(composite);
        this.createSettingsButton(composite);
    }

    private void createScanTabFolderSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, true));
        this.tabFolder = new TabFolder(composite, 1024);
        this.tabFolder.setBackground(Colors.WHITE);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedSubtractScanUI.this.updateScanData(ExtendedSubtractScanUI.this.scanMSD);
            }
        });
        this.createScanChart(this.tabFolder);
        this.createScanTable(this.tabFolder);
    }

    private void createScanChart(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Chart");
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        tabItem.setControl((Control)composite);
        this.scanChartUI = new ScanChartUI(composite, 2048);
        this.scanChartUI.setLayoutData(new GridData(1808));
    }

    private void createScanTable(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Table");
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setBackground(Colors.WHITE);
        composite.setLayout((Layout)new GridLayout(1, true));
        tabItem.setControl((Control)composite);
        this.extendedScanTableUI = new ExtendedScanTableUI(composite);
        this.extendedScanTableUI.forceEnableEditModus(true);
        this.extendedScanTableUI.setFireUpdate(false);
        this.extendedScanTableUI.addEditListener(new EditListener(){

            @Override
            public void modify() {
                ExtendedSubtractScanUI.this.saveSessionMassSpectrum(null, ExtendedSubtractScanUI.this.scanMSD);
            }
        });
    }

    private void createAddSelectedScanButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Add selected scan to subtract spectrum.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/subtractFilterAddSelectedScan.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExtendedSubtractScanUI.this.chromatogramSelectionMSD != null && ExtendedSubtractScanUI.this.chromatogramSelectionMSD.getSelectedScan() != null) {
                    IScanMSD massSpectrum1 = PreferenceSupplier.getSessionSubtractMassSpectrum();
                    IVendorMassSpectrum massSpectrum2 = ExtendedSubtractScanUI.this.chromatogramSelectionMSD.getSelectedScan();
                    boolean useNormalize = PreferenceSupplier.isUseNormalizedScan();
                    IScanMSD subtractMassSpectrum = FilterSupport.getCombinedMassSpectrum((IScanMSD)massSpectrum1, (IScanMSD)massSpectrum2, null, (boolean)useNormalize);
                    ExtendedSubtractScanUI.this.saveSessionMassSpectrum(e.display, subtractMassSpectrum);
                }
            }
        });
    }

    private void createAddCombinedScanButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Add combined scan to subtract spectrum.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/subtractFilterAddCombinedScan.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExtendedSubtractScanUI.this.chromatogramSelectionMSD != null) {
                    boolean useNormalize = PreferenceSupplier.isUseNormalizedScan();
                    IScanMSD massSpectrum1 = PreferenceSupplier.getSessionSubtractMassSpectrum();
                    IScanMSD massSpectrum2 = FilterSupport.getCombinedMassSpectrum((IChromatogramSelectionMSD)ExtendedSubtractScanUI.this.chromatogramSelectionMSD, null, (boolean)useNormalize);
                    IScanMSD subtractMassSpectrum = FilterSupport.getCombinedMassSpectrum((IScanMSD)massSpectrum1, (IScanMSD)massSpectrum2, null, (boolean)useNormalize);
                    ExtendedSubtractScanUI.this.saveSessionMassSpectrum(e.display, subtractMassSpectrum);
                }
            }
        });
    }

    private void createClearSessionButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Clear the session spectrum.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/subtractFilterClearSessionMassSpectrum.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox messageBox = new MessageBox(e.display.getActiveShell(), 196);
                messageBox.setText("Clear Session");
                messageBox.setMessage("Would you like to clear the session subtract scan?");
                if (messageBox.open() == 64) {
                    ExtendedSubtractScanUI.this.scanMSD = null;
                    ExtendedSubtractScanUI.this.updateScanData(ExtendedSubtractScanUI.this.scanMSD);
                    ExtendedSubtractScanUI.this.saveSessionMassSpectrum(e.display, null);
                }
            }
        });
    }

    private Button createButtonCopyTracesClipboard(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Copy the traces to clipboard.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/copy-clipboard.png", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScanDataSupport scanDataSupport = new ScanDataSupport();
                int maxCopyTraces = PreferenceSupplier.getMaxCopyTraces();
                String traces = scanDataSupport.extractTracesText(ExtendedSubtractScanUI.this.scanMSD, maxCopyTraces);
                TextTransfer textTransfer = TextTransfer.getInstance();
                Object[] data = new Object[]{traces};
                Transfer[] dataTypes = new Transfer[]{textTransfer};
                Clipboard clipboard = new Clipboard(e.widget.getDisplay());
                clipboard.setContents(data, dataTypes);
            }
        });
        return button;
    }

    private Button createSaveButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Save the subtract scan.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/saveas.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (ExtendedSubtractScanUI.this.scanMSD != null) {
                        DatabaseFileSupport.saveMassSpectrum((Shell)e.display.getActiveShell(), (IScanMSD)ExtendedSubtractScanUI.this.scanMSD, (String)"SubtractMS");
                    }
                }
                catch (NoConverterAvailableException e1) {
                    logger.warn((Object)e1);
                }
            }
        });
        return button;
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePageScans()));
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("2", (IPreferencePage)new PreferencePageSubtract()));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedSubtractScanUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the chart settings.");
                    }
                }
            }
        });
    }

    private void applySettings() {
        this.updateScanData(this.scanMSD);
    }

    private void updateScanData(IScanMSD scanMSD) {
        if (this.tabFolder != null && this.scanChartUI != null) {
            if (scanMSD == null) {
                this.scanChartUI.deleteSeries();
                this.scanChartUI.getBaseChart().redraw();
            } else {
                this.scanChartUI.setInput((IScan)scanMSD);
            }
            if (this.extendedScanTableUI.isVisible()) {
                this.extendedScanTableUI.update(scanMSD);
            }
        }
    }

    private void loadSessionMassSpectrum(Display display) {
        PreferenceSupplier.loadSessionSubtractMassSpectrum();
        this.fireUpdateEvent(display);
    }

    private void saveSessionMassSpectrum(Display display, IScanMSD scanMSD) {
        PreferenceSupplier.setSessionSubtractMassSpectrum((IScanMSD)scanMSD);
        PreferenceSupplier.storeSessionSubtractMassSpectrum();
        if (display != null) {
            this.fireUpdateEvent(display);
        }
    }

    private void fireUpdateEvent(Display display) {
        final IEventBroker eventBroker = Activator.getDefault().getEventBroker();
        if (eventBroker != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    eventBroker.send("filter/supplier/subtract/update/session/subtractmassspectrum", (Object)true);
                }
            });
        }
    }
}

