/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.ILibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.swt.ui.support.DatabaseFileSupport;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.events.IKeyEventProcessor;
import org.eclipse.chemclipse.support.ui.menu.ITableMenuEntry;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.support.ui.swt.ITableSettings;
import org.eclipse.chemclipse.swt.ui.components.ISearchListener;
import org.eclipse.chemclipse.swt.ui.components.SearchSupportUI;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.parts.ScanTablePart;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageScans;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ScanDataSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.EditListener;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ScanTableUI;
import org.eclipse.chemclipse.wsd.model.core.IPeakWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanSignalWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.chemclipse.wsd.model.core.implementation.ScanSignalWSD;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ExtendedScanTableUI {
    private static final Logger logger = Logger.getLogger(ScanTablePart.class);
    private Composite toolbarInfoTop;
    private Label labelInfoTop;
    private Composite toolbarInfoBottom;
    private Label labelInfoBottom;
    private Composite toolbarEdit;
    private Composite toolbarSearch;
    private Button buttonSaveScan;
    private Button buttonOptimizedScan;
    private Button buttonToggleToolbarEdit;
    private Label labelX;
    private Text textX;
    private Label labelY;
    private Text textY;
    private ScanTableUI scanTableUI;
    private Object object;
    private IScanMSD optimizedMassSpectrum;
    private DeleteMenuEntry deleteMenuEntry;
    private DeleteKeyEventProcessor deleteKeyEventProcessor;
    private boolean forceEnableEditModus = false;
    private boolean fireUpdate = true;
    private ScanDataSupport scanDataSupport = new ScanDataSupport();
    private EditListener editListener = null;

    @Inject
    public ExtendedScanTableUI(Composite parent) {
        this.initialize(parent);
    }

    @Focus
    public void setFocus() {
        this.updateObject();
    }

    public void update(Object object) {
        this.object = object;
        this.updateObject();
    }

    public boolean isVisible() {
        return this.scanTableUI.getTable().isVisible();
    }

    public void addEditListener(EditListener editListener) {
        this.editListener = editListener;
    }

    protected void setFireUpdate(boolean fireUpdate) {
        this.fireUpdate = fireUpdate;
    }

    protected void forceEnableEditModus(boolean forceEnableEditModus) {
        this.forceEnableEditModus = forceEnableEditModus;
    }

    private void enableEditModus(boolean enabled) {
        this.buttonToggleToolbarEdit.setEnabled(enabled);
        PartSupport.setControlVisibility((Control)this.buttonToggleToolbarEdit, (boolean)enabled);
        if (!enabled) {
            PartSupport.setCompositeVisibility((Composite)this.toolbarEdit, (boolean)false);
        }
        this.scanTableUI.setEditEnabled(enabled);
        ITableSettings tableSettings = this.scanTableUI.getTableSettings();
        if (enabled) {
            tableSettings.addMenuEntry((ITableMenuEntry)this.deleteMenuEntry);
            tableSettings.addKeyEventProcessor((IKeyEventProcessor)this.deleteKeyEventProcessor);
        } else {
            tableSettings.removeMenuEntry((ITableMenuEntry)this.deleteMenuEntry);
            tableSettings.removeKeyEventProcessor((IKeyEventProcessor)this.deleteKeyEventProcessor);
        }
        this.scanTableUI.applySettings(tableSettings);
    }

    private void updateObject() {
        IScan scan = this.getScan();
        boolean isLibraryMassSpectrum = this.enableEditModus();
        this.setInfoTop(scan, isLibraryMassSpectrum);
        this.setInfoBottom(scan);
        this.scanTableUI.setInput(scan);
        this.modifyEditFields();
        this.optimizedMassSpectrum = null;
        this.buttonOptimizedScan.setEnabled(this.scanDataSupport.containsOptimizedScan(scan));
        this.buttonSaveScan.setEnabled(this.isSaveEnabled());
    }

    private void modifyEditFields() {
        List tableViewerColumns = this.scanTableUI.getTableViewerColumns();
        if (tableViewerColumns.size() >= 2) {
            String titleX = ((TableViewerColumn)tableViewerColumns.get(0)).getColumn().getText();
            this.labelX.setText(String.valueOf(titleX) + ":");
            this.textX.setToolTipText(titleX);
            String titleY = ((TableViewerColumn)tableViewerColumns.get(1)).getColumn().getText();
            this.labelY.setText(String.valueOf(titleY) + ":");
            this.textY.setToolTipText(titleY);
            this.toolbarEdit.layout(true);
        }
    }

    private boolean enableEditModus() {
        boolean isLibraryMassSpectrum = false;
        this.enableEditModus(false);
        if (this.object instanceof IScan) {
            isLibraryMassSpectrum = this.object instanceof ILibraryMassSpectrum;
            if (this.forceEnableEditModus || isLibraryMassSpectrum) {
                this.enableEditModus(true);
            }
        }
        return isLibraryMassSpectrum;
    }

    private IScan getScan() {
        IScan scan = null;
        if (this.object instanceof IScan) {
            scan = (IScan)this.object;
        } else if (this.object instanceof IPeak) {
            IPeak peak = (IPeak)this.object;
            scan = peak.getPeakModel().getPeakMaximum();
        }
        return scan;
    }

    private void setInfoTop(IScan scan, boolean isLibraryMassSpectrum) {
        if (this.forceEnableEditModus || isLibraryMassSpectrum) {
            String editInformation = this.scanTableUI.isEditEnabled() ? "Edit is enabled." : "Edit is disabled.";
            this.labelInfoTop.setText(String.valueOf(this.scanDataSupport.getScanLabel(scan)) + " - " + editInformation);
        } else {
            this.labelInfoTop.setText(this.scanDataSupport.getScanLabel(scan));
        }
    }

    private void setInfoBottom(IScan scan) {
        String signals;
        if (scan instanceof IScanCSD) {
            signals = "1";
        } else if (scan instanceof IScanMSD) {
            IScanMSD scanMSD = (IScanMSD)scan;
            signals = Integer.toString(scanMSD.getNumberOfIons());
        } else if (scan instanceof IScanWSD) {
            IScanWSD scanWSD = (IScanWSD)scan;
            signals = Integer.toString(scanWSD.getNumberOfScanSignals());
        } else {
            signals = "--";
        }
        this.labelInfoBottom.setText("Signals: " + signals);
    }

    private boolean isSaveEnabled() {
        if (this.object instanceof IScanMSD) {
            return true;
        }
        return this.object instanceof IPeakMSD;
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.deleteMenuEntry = new DeleteMenuEntry();
        this.deleteKeyEventProcessor = new DeleteKeyEventProcessor();
        this.createToolbarMain(parent);
        this.toolbarInfoTop = this.createToolbarInfoTop(parent);
        this.toolbarEdit = this.createToolbarEdit(parent);
        this.toolbarSearch = this.createToolbarSearch(parent);
        this.createTable(parent);
        this.toolbarInfoBottom = this.createToolbarInfoBottom(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfoTop, (boolean)true);
        PartSupport.setCompositeVisibility((Composite)this.toolbarEdit, (boolean)false);
        PartSupport.setCompositeVisibility((Composite)this.toolbarSearch, (boolean)false);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfoBottom, (boolean)true);
        this.enableEditModus(false);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(7, false));
        this.createButtonToggleToolbarInfo(composite);
        this.buttonToggleToolbarEdit = this.createButtonToggleToolbarEdit(composite);
        this.createButtonToggleToolbarSearch(composite);
        this.createResetButton(composite);
        this.buttonSaveScan = this.createSaveButton(composite);
        this.buttonOptimizedScan = this.createOptimizedScanButton(composite);
        this.createSettingsButton(composite);
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedScanTableUI.this.toolbarInfoTop);
                PartSupport.toggleCompositeVisibility((Composite)ExtendedScanTableUI.this.toolbarInfoBottom);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarEdit(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle edit toolbar.");
        button.setText("");
        button.setLayoutData((Object)new GridData());
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedScanTableUI.this.toolbarEdit);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editActive.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarSearch(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle search toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedScanTableUI.this.toolbarSearch);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private void createResetButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset the scan chart.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedScanTableUI.this.reset();
            }
        });
    }

    private Button createSaveButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Save the scan.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/saveas.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (ExtendedScanTableUI.this.object instanceof IScanMSD) {
                        IScanMSD massSpectrum = null;
                        if (ExtendedScanTableUI.this.optimizedMassSpectrum != null) {
                            massSpectrum = ExtendedScanTableUI.this.optimizedMassSpectrum;
                        } else if (ExtendedScanTableUI.this.object instanceof IScanMSD) {
                            massSpectrum = (IScanMSD)ExtendedScanTableUI.this.object;
                        } else if (ExtendedScanTableUI.this.object instanceof IPeakMSD) {
                            IPeakMSD peakMSD = (IPeakMSD)ExtendedScanTableUI.this.object;
                            massSpectrum = peakMSD.getExtractedMassSpectrum();
                        }
                        if (massSpectrum != null) {
                            DatabaseFileSupport.saveMassSpectrum((Shell)e.display.getActiveShell(), (IScanMSD)massSpectrum, (String)("Scan" + massSpectrum.getScanNumber()));
                        }
                    }
                }
                catch (NoConverterAvailableException e1) {
                    logger.warn((Object)e1);
                }
            }
        });
        return button;
    }

    private Button createOptimizedScanButton(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Show optimized scan.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/plus.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExtendedScanTableUI.this.object instanceof IScanMSD) {
                    IScanMSD scanMSD = (IScanMSD)ExtendedScanTableUI.this.object;
                    ExtendedScanTableUI.this.optimizedMassSpectrum = scanMSD.getOptimizedMassSpectrum();
                    if (ExtendedScanTableUI.this.optimizedMassSpectrum != null) {
                        ExtendedScanTableUI.this.scanTableUI.setInput((IScan)ExtendedScanTableUI.this.optimizedMassSpectrum);
                        ExtendedScanTableUI.this.labelInfoTop.setText(ExtendedScanTableUI.this.scanDataSupport.getScanLabel((IScan)ExtendedScanTableUI.this.optimizedMassSpectrum));
                        ExtendedScanTableUI.this.labelInfoBottom.setText("Signals: " + ExtendedScanTableUI.this.optimizedMassSpectrum.getNumberOfIons());
                        button.setEnabled(false);
                    }
                }
            }
        });
        return button;
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePageScans preferencePage = new PreferencePageScans();
                preferencePage.setTitle("Scan Settings");
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)preferencePage));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedScanTableUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the chart settings.");
                    }
                }
            }
        });
    }

    private Composite createToolbarInfoTop(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelInfoTop = new Label(composite, 0);
        this.labelInfoTop.setText("");
        this.labelInfoTop.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Composite createToolbarInfoBottom(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelInfoBottom = new Label(composite, 0);
        this.labelInfoBottom.setText("");
        this.labelInfoBottom.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Composite createToolbarEdit(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(6, false));
        this.labelX = this.createLabelX(composite);
        this.textX = this.createTextX(composite);
        this.labelY = this.createLabelY(composite);
        this.textY = this.createTextY(composite);
        this.createButtonAdd(composite);
        this.createButtonDelete(composite);
        return composite;
    }

    private Composite createToolbarSearch(Composite parent) {
        SearchSupportUI searchSupportUI = new SearchSupportUI(parent, 0);
        searchSupportUI.setLayoutData((Object)new GridData(768));
        searchSupportUI.setSearchListener(new ISearchListener(){

            public void performSearch(String searchText, boolean caseSensitive) {
                ExtendedScanTableUI.this.scanTableUI.setSearchText(searchText, caseSensitive);
            }
        });
        return searchSupportUI;
    }

    private Label createLabelX(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("");
        return label;
    }

    private Text createTextX(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setText("");
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private Label createLabelY(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("");
        return label;
    }

    private Text createTextY(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setText("");
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private void createButtonAdd(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Add the scan signal.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExtendedScanTableUI.this.object != null) {
                    ExtendedScanTableUI.this.addSignal(e.display.getActiveShell());
                    ExtendedScanTableUI.this.scanTableUI.updateScan();
                    ExtendedScanTableUI.this.fireEditEvent();
                } else {
                    MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Add Signal", (String)"Please load a scan first.");
                }
            }
        });
    }

    private void createButtonDelete(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Delete the scan signal(s).");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedScanTableUI.this.deleteSignals(e.display.getActiveShell());
                ExtendedScanTableUI.this.scanTableUI.updateScan();
                ExtendedScanTableUI.this.fireEditEvent();
            }
        });
    }

    private void createTable(Composite parent) {
        this.scanTableUI = new ScanTableUI(parent, 268503810);
        this.scanTableUI.getTable().setLayoutData((Object)new GridData(1808));
        Table table = this.scanTableUI.getTable();
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ExtendedScanTableUI.this.fireEditEvent();
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                ExtendedScanTableUI.this.fireEditEvent();
            }
        });
    }

    private void applySettings() {
        this.updateObject();
    }

    private void reset() {
        this.updateObject();
    }

    private void deleteSignals(Shell shell) {
        MessageBox messageBox = new MessageBox(shell, 196);
        messageBox.setText("Delete Signal(s)");
        messageBox.setMessage("Would you like to delete the selected signal(s)?");
        if (messageBox.open() == 64) {
            for (Object object : this.scanTableUI.getStructuredSelection()) {
                this.deleteSignal(object);
            }
            this.scanTableUI.refresh();
            this.fireScanUpdate();
        }
    }

    private void deleteSignal(Object signal) {
        if (this.object instanceof IScanMSD) {
            IScanMSD scanMSD = (IScanMSD)this.object;
            if (signal instanceof IIon) {
                scanMSD.removeIon((IIon)signal);
            }
        } else if (this.object instanceof IScanCSD) {
            IScanCSD scanCSD = (IScanCSD)this.object;
            scanCSD.adjustTotalSignal(0.0f);
        } else if (this.object instanceof IScanWSD) {
            IScanWSD scanWSD = (IScanWSD)this.object;
            if (signal instanceof IScanSignalWSD) {
                scanWSD.removeScanSignal((IScanSignalWSD)signal);
            }
        } else if (this.object instanceof IPeakMSD) {
            IPeakMSD peakMSD = (IPeakMSD)this.object;
            if (signal instanceof IIon) {
                peakMSD.getExtractedMassSpectrum().removeIon((IIon)signal);
            }
        } else if (this.object instanceof IPeakCSD) {
            IScan scan;
            IPeakCSD peakCSD = (IPeakCSD)this.object;
            if (signal instanceof IScanCSD && (scan = peakCSD.getPeakModel().getPeakMaximum()) instanceof IScanCSD) {
                IScanCSD scanCSD = (IScanCSD)scan;
                scanCSD.adjustTotalSignal(0.0f);
            }
        } else if (this.object instanceof IPeakWSD) {
            IScan scan;
            IPeakWSD peakWSD = (IPeakWSD)this.object;
            if (signal instanceof IScanSignalWSD && (scan = peakWSD.getPeakModel().getPeakMaximum()) instanceof IScanWSD) {
                IScanWSD scanWSD = (IScanWSD)scan;
                if (signal instanceof IScanSignalWSD) {
                    scanWSD.removeScanSignal((IScanSignalWSD)signal);
                }
            }
        }
    }

    private void addSignal(Shell shell) {
        String x = this.textX.getText().trim();
        String y = this.textY.getText().trim();
        if ("".equals(x) || "".equals(y)) {
            MessageDialog.openError((Shell)shell, (String)"Add Signal", (String)"The values must be not empty.");
        } else {
            try {
                IPeakWSD peakWSD;
                IScan scan;
                double valueX = Double.parseDouble(x);
                float valueY = Float.parseFloat(y);
                if (this.object instanceof IScanMSD) {
                    IScanMSD scanMSD = (IScanMSD)this.object;
                    scanMSD.addIon((IIon)new Ion(valueX, valueY));
                } else if (this.object instanceof IScanCSD) {
                    IScanCSD scanCSD = (IScanCSD)this.object;
                    scanCSD.adjustTotalSignal(valueY);
                } else if (this.object instanceof IScanWSD) {
                    IScanWSD scanWSD = (IScanWSD)this.object;
                    scanWSD.addScanSignal((IScanSignalWSD)new ScanSignalWSD(valueX, valueY));
                } else if (this.object instanceof IPeakMSD) {
                    IPeakMSD peakMSD = (IPeakMSD)this.object;
                    peakMSD.getExtractedMassSpectrum().addIon((IIon)new Ion(valueX, valueY));
                } else if (this.object instanceof IPeakCSD) {
                    IPeakCSD peakCSD = (IPeakCSD)this.object;
                    IScan scan2 = peakCSD.getPeakModel().getPeakMaximum();
                    if (scan2 instanceof IScanCSD) {
                        IScanCSD scanCSD = (IScanCSD)scan2;
                        scanCSD.adjustTotalSignal(valueY);
                    }
                } else if (this.object instanceof IPeakWSD && (scan = (peakWSD = (IPeakWSD)this.object).getPeakModel().getPeakMaximum()) instanceof IScanWSD) {
                    IScanWSD scanWSD = (IScanWSD)scan;
                    scanWSD.addScanSignal((IScanSignalWSD)new ScanSignalWSD(valueX, valueY));
                }
                this.textX.setText("");
                this.textY.setText("");
                this.scanTableUI.refresh();
                this.fireScanUpdate();
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)shell, (String)"Add Signal", (String)"Something has gone wrong to add the signal.");
            }
        }
    }

    private void fireScanUpdate() {
        IEventBroker eventBroker;
        if (this.fireUpdate && (eventBroker = Activator.getDefault().getEventBroker()) != null) {
            if (this.object instanceof IScan) {
                eventBroker.send("scan/xxd/update/selection", this.object);
            } else if (this.object instanceof IPeak) {
                eventBroker.send("peak/xxd/update/selection", this.object);
            }
        }
    }

    private void fireEditEvent() {
        if (this.editListener != null) {
            this.editListener.modify();
        }
    }

    private class DeleteKeyEventProcessor
    implements IKeyEventProcessor {
        private DeleteKeyEventProcessor() {
        }

        public void handleEvent(ExtendedTableViewer extendedTableViewer, KeyEvent e) {
            if (e.keyCode == 127) {
                ExtendedScanTableUI.this.deleteSignals(e.display.getActiveShell());
            }
        }
    }

    private class DeleteMenuEntry
    implements ITableMenuEntry {
        private DeleteMenuEntry() {
        }

        public String getName() {
            return "Delete Signal(s)";
        }

        public String getCategory() {
            return "";
        }

        public void execute(ExtendedTableViewer extendedTableViewer) {
            ExtendedScanTableUI.this.deleteSignals(extendedTableViewer.getTable().getShell());
        }
    }
}

