/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.chemclipse.model.core.IComplexSignalMeasurement;
import org.eclipse.chemclipse.nmr.model.core.SpectrumMeasurement;
import org.eclipse.chemclipse.nmr.model.selection.IDataNMRSelection;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IColorScheme;
import org.eclipse.chemclipse.ux.extension.ui.editors.IScanEditorNMR;
import org.eclipse.chemclipse.ux.extension.xxd.ui.charts.ChartNMR;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageOverlay;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.linecharts.LineChart;
import org.eclipse.swtchart.extensions.linecharts.LineSeriesData;

public class ExtendedNMROverlayUI
implements Observer {
    private ChartNMR chartNMR;
    private AtomicReference<Map<IScanEditorNMR, OverlayDataNMRSelection>> dataNMREditors = new AtomicReference(Collections.emptyMap());
    private EPartService partservice;
    private IColorScheme colorSchemeNormal;
    private IPreferenceStore preferenceStore;
    private Mode mode = Mode.OVERLAY;

    public ExtendedNMROverlayUI(Composite parent, EPartService partservice, IPreferenceStore preferenceStore) {
        this.partservice = partservice;
        this.preferenceStore = preferenceStore;
        this.colorSchemeNormal = preferenceStore != null ? Colors.getColorScheme((String)preferenceStore.getString("colorSchemeDisplayOverlay")) : Colors.getColorScheme((String)"Red");
        this.initialize(parent);
    }

    public void update() {
        Map<IScanEditorNMR, OverlayDataNMRSelection> oldEditors = this.dataNMREditors.get();
        LinkedHashMap<IScanEditorNMR, OverlayDataNMRSelection> newEditors = new LinkedHashMap<IScanEditorNMR, OverlayDataNMRSelection>();
        Collection parts = this.partservice.getParts();
        for (MPart part : parts) {
            Object object = part.getObject();
            if (!(object instanceof IScanEditorNMR)) continue;
            IScanEditorNMR editor = (IScanEditorNMR)object;
            OverlayDataNMRSelection oldSelection = oldEditors.get(editor);
            if (oldSelection == null) {
                OverlayDataNMRSelection initialSelection = new OverlayDataNMRSelection(editor);
                initialSelection.addObserver(this);
                newEditors.put(editor, initialSelection);
                continue;
            }
            newEditors.put(editor, oldSelection);
        }
        this.dataNMREditors.compareAndSet(oldEditors, Collections.unmodifiableMap(newEditors));
        this.refreshUpdateOverlayChart();
    }

    public Collection<IDataNMRSelection> getSelections() {
        return Collections.unmodifiableCollection(this.dataNMREditors.get().values());
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.createOverlayChart(parent);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(5, false));
        this.createModeButtons(composite);
        this.createToggleChartLegendButton(composite);
        this.createResetButton(composite);
        this.createSettingsButton(composite);
    }

    private void createModeButtons(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Stacked Mode");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/chromatogramOverlayMirrored.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExtendedNMROverlayUI.this.mode != Mode.STACKED) {
                    ExtendedNMROverlayUI.this.mode = Mode.STACKED;
                    ExtendedNMROverlayUI.this.refreshUpdateOverlayChart();
                }
            }
        });
        button = new Button(parent, 8);
        button.setToolTipText("Overlay Mode");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/chromatogramOverlay.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExtendedNMROverlayUI.this.mode != Mode.OVERLAY) {
                    ExtendedNMROverlayUI.this.mode = Mode.OVERLAY;
                    ExtendedNMROverlayUI.this.refreshUpdateOverlayChart();
                }
            }
        });
    }

    private void createToggleChartLegendButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the chart legend");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/tag.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedNMROverlayUI.this.chartNMR.toggleSeriesLegendVisibility();
            }
        });
    }

    private void createResetButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset the Overlay");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedNMROverlayUI.this.applyOverlaySettings();
            }
        });
    }

    private void createSettingsButton(Composite parent) {
        if (this.preferenceStore == null) {
            return;
        }
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePageOverlay preferencePageOverlay = new PreferencePageOverlay();
                preferencePageOverlay.setTitle("Overlay Settings");
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)preferencePageOverlay));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.setPreferenceStore(ExtendedNMROverlayUI.this.preferenceStore);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedNMROverlayUI.this.applyOverlaySettings();
                    }
                    catch (Exception e1) {
                        System.out.println(e1);
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the chart settings.");
                    }
                }
            }
        });
    }

    private void createOverlayChart(Composite parent) {
        this.chartNMR = new ChartNMR(parent, 2048);
        IChartSettings chartSettings = this.chartNMR.getChartSettings();
        chartSettings.setCreateMenu(true);
        chartSettings.setEnableRangeSelector(false);
        chartSettings.setShowRangeSelectorInitially(false);
        this.chartNMR.applySettings(chartSettings);
        this.chartNMR.setLayoutData(new GridData(1808));
    }

    private void applyOverlaySettings() {
    }

    private void refreshUpdateOverlayChart() {
        this.chartNMR.deleteSeries();
        this.colorSchemeNormal.reset();
        Collection<OverlayDataNMRSelection> spectras = this.dataNMREditors.get().values();
        if (spectras.size() > 0) {
            ArrayList<ILineSeriesData> lineSeriesDataList = new ArrayList<ILineSeriesData>();
            int i = 1;
            Color color = this.colorSchemeNormal.getColor();
            double yOffset = 0.0;
            for (OverlayDataNMRSelection selection : spectras) {
                ILineSeriesData lineSeriesData;
                IComplexSignalMeasurement<?> measurement = selection.getMeasurement();
                if (!(measurement instanceof SpectrumMeasurement) || (lineSeriesData = this.getLineSeriesData((SpectrumMeasurement)measurement, "NMR_" + i++, measurement.getDataName(), yOffset)) == null) continue;
                ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
                lineSeriesSettings.setLineColor(color);
                lineSeriesSettings.setEnableArea(false);
                selection.setColor(color);
                lineSeriesDataList.add(lineSeriesData);
                color = this.colorSchemeNormal.getNextColor();
                if (this.mode != Mode.STACKED) continue;
                yOffset = this.getMax(lineSeriesData.getSeriesData()) * 1.1;
            }
            this.chartNMR.addSeriesData(lineSeriesDataList, LineChart.MEDIUM_COMPRESSION);
        }
    }

    private double getMax(ISeriesData seriesData) {
        double[] ySeries;
        double max = 0.0;
        double[] dArray = ySeries = seriesData.getYSeries();
        int n = ySeries.length;
        int n2 = 0;
        while (n2 < n) {
            double y = dArray[n2];
            if (y > max) {
                max = y;
            }
            ++n2;
        }
        return max;
    }

    private ILineSeriesData getLineSeriesData(SpectrumMeasurement spectrumMeasurement, String id, String label, double yOffset) {
        LineSeriesData lineSeriesData = new LineSeriesData(ChartNMR.createSignalSeries(id, spectrumMeasurement.getSignals(), yOffset, 0.0));
        lineSeriesData.getSettings().setDescription(label);
        return lineSeriesData;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == IDataNMRSelection.ChangeType.SELECTION_CHANGED) {
            Display.getDefault().asyncExec(this::refreshUpdateOverlayChart);
        }
    }

    private static enum Mode {
        OVERLAY,
        STACKED;

    }

    private static final class OverlayDataNMRSelection
    extends Observable
    implements IDataNMRSelection,
    IColorProvider {
        private IScanEditorNMR editor;
        private IComplexSignalMeasurement<?> selection;
        private Color color;

        public OverlayDataNMRSelection(IScanEditorNMR editor) {
            this.editor = editor;
            IComplexSignalMeasurement<?>[] measurements = this.getMeasurements();
            if (measurements.length > 0) {
                this.setActiveMeasurement(measurements[0]);
            }
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public String getName() {
            return this.editor.getName();
        }

        public IComplexSignalMeasurement<?> getMeasurement() {
            return this.selection;
        }

        public IComplexSignalMeasurement<?>[] getMeasurements() {
            ArrayList<SpectrumMeasurement> specras = new ArrayList<SpectrumMeasurement>();
            IComplexSignalMeasurement[] iComplexSignalMeasurementArray = this.editor.getScanSelection().getMeasurements();
            int n = iComplexSignalMeasurementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IComplexSignalMeasurement m = iComplexSignalMeasurementArray[n2];
                if (m instanceof SpectrumMeasurement) {
                    specras.add((SpectrumMeasurement)m);
                }
                ++n2;
            }
            return specras.toArray(new IComplexSignalMeasurement[0]);
        }

        public void setActiveMeasurement(IComplexSignalMeasurement<?> selection) {
            if (this.selection != selection) {
                this.selection = selection;
                this.setChanged();
                this.notifyObservers(IDataNMRSelection.ChangeType.SELECTION_CHANGED);
            }
        }

        public void addMeasurement(IComplexSignalMeasurement<?> selection) {
            this.editor.getScanSelection().addMeasurement(selection);
            this.setActiveMeasurement(selection);
        }

        @Override
        public void addObserver(Observer observer) {
            super.addObserver(observer);
        }

        public void removeObserver(Observer observer) {
            super.deleteObserver(observer);
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            return this.color;
        }
    }
}

