/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import javax.inject.Inject;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramDataSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.PeakDataSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.IntegrationAreaUI;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ExtendedIntegrationAreaUI {
    private Composite toolbarInfo;
    private Label labelInfo;
    private IntegrationAreaUI integrationAreaUI;
    private Object object;
    private PeakDataSupport peakDataSupport = new PeakDataSupport();
    private ChromatogramDataSupport chromatogramDataSupport = new ChromatogramDataSupport();

    @Inject
    public ExtendedIntegrationAreaUI(Composite parent) {
        this.initialize(parent);
    }

    @Focus
    public void setFocus() {
        this.updateObject();
    }

    public void update(Object object) {
        this.object = object;
        if (object instanceof IPeak) {
            IPeak peak = (IPeak)object;
            String description = peak.getIntegratorDescription();
            this.labelInfo.setText(String.valueOf(this.peakDataSupport.getPeakLabel(peak)) + " | " + description);
        } else if (object instanceof IChromatogram) {
            IChromatogram chromatogram = (IChromatogram)object;
            String description = chromatogram.getIntegratorDescription();
            this.labelInfo.setText(String.valueOf(ChromatogramDataSupport.getChromatogramLabel(chromatogram)) + " | " + description);
        } else {
            this.labelInfo.setText("No data has been selected.");
        }
        this.updateObject();
    }

    private void updateObject() {
        if (this.object != null) {
            this.integrationAreaUI.setInput(this.object);
        } else {
            this.integrationAreaUI.clear();
        }
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.toolbarInfo = this.createToolbarInfo(parent);
        this.createQuantitationTable(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfo, (boolean)true);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createButtonToggleToolbarInfo(composite);
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelInfo = new Label(composite, 0);
        this.labelInfo.setText("");
        this.labelInfo.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private void createQuantitationTable(Composite parent) {
        this.integrationAreaUI = new IntegrationAreaUI(parent, 68354);
        this.integrationAreaUI.getTable().setLayoutData((Object)new GridData(1808));
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedIntegrationAreaUI.this.toolbarInfo);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }
}

