/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.chemclipse.processing.filter.FilterContext;
import org.eclipse.chemclipse.ux.extension.xxd.ui.editors.EditorExtension;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DynamicSettingsUI {
    private Composite parent;
    private Object layoutData;
    private Composite composite;

    public DynamicSettingsUI(Composite parent, Object layoutData) {
        this.parent = parent;
        this.layoutData = layoutData;
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DynamicSettingsUI.this.disposeCurrent();
            }
        });
    }

    public <T, C> void setActiveContext(FilterContext<T, C> context, final Observer observer) {
        EditorExtension editorExtension;
        Object config;
        this.disposeCurrent();
        if (context != null && (config = context.getFilterConfig()) != null && (editorExtension = (EditorExtension)Adapters.adapt((Object)config, EditorExtension.class)) != null) {
            this.composite = new Composite(this.parent, 0);
            this.composite.setLayout((Layout)new FillLayout());
            this.composite.setLayoutData(this.layoutData);
            final Observable extension = editorExtension.createExtension(this.composite);
            if (observer != null) {
                this.composite.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        extension.deleteObserver(observer);
                    }
                });
                extension.addObserver(observer);
            }
        }
    }

    private void disposeCurrent() {
        if (this.composite != null) {
            this.composite.dispose();
            this.composite = null;
        }
    }
}

