/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.model.core.IMarkedSignals;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.comparator.IonValueComparator;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.DisplayType;
import org.eclipse.chemclipse.wsd.model.comparator.WavelengthValueComparator;
import org.eclipse.chemclipse.wsd.model.core.IScanSignalWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.chemclipse.wsd.model.core.support.IMarkedWavelength;
import org.eclipse.chemclipse.wsd.model.core.support.IMarkedWavelengths;
import org.eclipse.swtchart.extensions.barcharts.BarSeriesData;
import org.eclipse.swtchart.extensions.barcharts.IBarSeriesData;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.SeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesData;
import org.eclipse.swtchart.extensions.linecharts.LineSeriesData;

public class ScanChartSupport {
    private IonValueComparator ionValueComparator = new IonValueComparator(SortOrder.ASC);
    private WavelengthValueComparator wavelengthValueComparator = new WavelengthValueComparator(SortOrder.ASC);

    public IBarSeriesData getBarSeriesData(IScan scan, String postfix, boolean mirrored) {
        ISeriesData seriesData = this.getSeriesData(scan, postfix, mirrored);
        BarSeriesData barSeriesData = new BarSeriesData(seriesData);
        return barSeriesData;
    }

    public ILineSeriesData getLineSeriesData(IScan scan, String postfix, boolean mirrored) {
        ISeriesData seriesData = this.getSeriesData(scan, postfix, mirrored);
        LineSeriesData lineSeriesData = new LineSeriesData(seriesData);
        return lineSeriesData;
    }

    public ILineSeriesData getLineSeriesDataPoint(IScan scan, boolean mirrored, String seriesId, DisplayType displayType, IMarkedSignals markedSignals) {
        ArrayList<IScan> scans = new ArrayList<IScan>();
        scans.add(scan);
        return this.getLineSeriesDataPoint(scans, mirrored, seriesId, displayType, markedSignals);
    }

    public ILineSeriesData getLineSeriesDataPoint(List<IScan> scans, boolean mirrored, String seriesId) {
        IMarkedSignals markedSignals = null;
        return this.getLineSeriesDataPoint(scans, mirrored, seriesId, DisplayType.TIC, markedSignals);
    }

    public ILineSeriesData getLineSeriesDataPoint(List<IScan> scans, boolean mirrored, String seriesId, DisplayType displayType, IChromatogramSelection chromatogramSelection) {
        IMarkedWavelengths markedSignals = null;
        if (displayType.equals((Object)DisplayType.SWC)) {
            markedSignals = ((IChromatogramSelectionWSD)chromatogramSelection).getSelectedWavelengths();
        }
        return this.getLineSeriesDataPoint(scans, mirrored, seriesId, displayType, (IMarkedSignals)markedSignals);
    }

    public ILineSeriesData getLineSeriesDataPoint(IScan scan, boolean mirrored, String seriesId, DisplayType displayType, IChromatogramSelection chromatogramSelection) {
        return this.getLineSeriesDataPoint(Collections.singletonList(scan), mirrored, seriesId, displayType, chromatogramSelection);
    }

    public ILineSeriesData getLineSeriesDataPoint(List<IScan> scans, boolean mirrored, String seriesId, DisplayType displayType, IMarkedSignals markedSignals) {
        ArrayList<Double> xSeries = new ArrayList<Double>(scans.size());
        ArrayList<Double> ySeries = new ArrayList<Double>(scans.size());
        for (IScan scan : scans) {
            Optional scanSignal;
            if (displayType.equals((Object)DisplayType.TIC)) {
                if (scan == null) continue;
                xSeries.add(Double.valueOf(scan.getRetentionTime()));
                ySeries.add(Double.valueOf(mirrored ? scan.getTotalSignal() * -1.0f : scan.getTotalSignal()));
                continue;
            }
            if (!displayType.equals((Object)DisplayType.SWC) || !(scan instanceof IScanWSD) || !(markedSignals instanceof IMarkedWavelengths)) continue;
            IScanWSD scanWSD = (IScanWSD)scan;
            Iterator markedWavelengths = ((IMarkedWavelengths)markedSignals).iterator();
            if (!markedWavelengths.hasNext() || !(scanSignal = scanWSD.getScanSignal(((IMarkedWavelength)markedWavelengths.next()).getWavelength())).isPresent()) continue;
            xSeries.add(Double.valueOf(scan.getRetentionTime()));
            ySeries.add(Double.valueOf(((IScanSignalWSD)scanSignal.get()).getAbundance()));
        }
        SeriesData seriesData = new SeriesData(xSeries.stream().mapToDouble(Double::doubleValue).toArray(), ySeries.stream().mapToDouble(Double::doubleValue).toArray(), seriesId);
        LineSeriesData lineSeriesData = new LineSeriesData((ISeriesData)seriesData);
        return lineSeriesData;
    }

    private ISeriesData getSeriesData(IScan scan, String postfix, boolean mirrored) {
        double[] ySeries;
        double[] xSeries;
        String scanNumber = scan.getScanNumber() > 0 ? Integer.toString(scan.getScanNumber()) : "--";
        String id = "Scan " + scanNumber;
        if (!"".equals(postfix)) {
            id = String.valueOf(id) + " " + postfix;
        }
        if (scan instanceof IScanMSD) {
            IScanMSD scanMSD = (IScanMSD)scan;
            ArrayList ions = new ArrayList(scanMSD.getIons());
            Collections.sort(ions, this.ionValueComparator);
            int size = ions.size();
            xSeries = new double[size];
            ySeries = new double[size];
            int index = 0;
            for (IIon ion : ions) {
                xSeries[index] = ion.getIon();
                ySeries[index] = mirrored ? ion.getAbundance() * -1.0f : ion.getAbundance();
                ++index;
            }
        } else if (scan instanceof IScanCSD) {
            IScanCSD scanCSD = (IScanCSD)scan;
            xSeries = new double[]{scanCSD.getRetentionTime()};
            ySeries = new double[]{mirrored ? scanCSD.getTotalSignal() * -1.0f : scanCSD.getTotalSignal()};
        } else if (scan instanceof IScanWSD) {
            IScanWSD scanWSD = (IScanWSD)scan;
            ArrayList scanSignalsWSD = new ArrayList(scanWSD.getScanSignals());
            Collections.sort(scanSignalsWSD, this.wavelengthValueComparator);
            int size = scanSignalsWSD.size();
            xSeries = new double[size];
            ySeries = new double[size];
            int index = 0;
            for (IScanSignalWSD scanSignalWSD : scanSignalsWSD) {
                xSeries[index] = scanSignalWSD.getWavelength();
                ySeries[index] = mirrored ? scanSignalWSD.getAbundance() * -1.0f : scanSignalWSD.getAbundance();
                ++index;
            }
        } else {
            xSeries = new double[]{};
            ySeries = new double[]{};
        }
        return new SeriesData(xSeries, ySeries, id);
    }
}

