/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.wsd.model.core.IPeakWSD;

public class PeakDataSupport {
    private DecimalFormat decimalFormatRetentionTime = ValueFormat.getDecimalFormatEnglish((String)"0.0##");

    public String getPeakLabel(IPeak peak) {
        StringBuilder builder = new StringBuilder();
        if (peak != null) {
            builder.append("Peak");
            builder.append(" | ");
            builder.append("Start RT: ");
            builder.append(this.decimalFormatRetentionTime.format((double)peak.getPeakModel().getStartRetentionTime() / 60000.0));
            builder.append(" | ");
            builder.append("Stop RT: ");
            builder.append(this.decimalFormatRetentionTime.format((double)peak.getPeakModel().getStopRetentionTime() / 60000.0));
            builder.append(" | ");
            builder.append("Signal: ");
            builder.append((int)peak.getIntegratedArea());
        } else {
            builder.append("No peak has been selected yet.");
        }
        return builder.toString();
    }

    public String getType(IPeak peak) {
        if (peak instanceof IPeakCSD) {
            return "[CSD]";
        }
        if (peak instanceof IPeakMSD) {
            return "[MSD]";
        }
        if (peak instanceof IPeakWSD) {
            return "[WSD]";
        }
        return "";
    }
}

