/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.extensions.axisconverter.MillisecondsToMinuteConverter;
import org.eclipse.swtchart.extensions.axisconverter.PercentageConverter;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.IPrimaryAxisSettings;
import org.eclipse.swtchart.extensions.core.SecondaryAxisSettings;

public class ChartSupport {
    public static void setPrimaryAxisSet(IChartSettings chartSettings, String xAxisTitle, boolean xAxisVisible, String yAxisTitle) {
        IPrimaryAxisSettings primaryAxisSettingsX = chartSettings.getPrimaryAxisSettingsX();
        primaryAxisSettingsX.setTitle(xAxisTitle);
        primaryAxisSettingsX.setDecimalFormat(new DecimalFormat("0.0##", new DecimalFormatSymbols(Locale.ENGLISH)));
        primaryAxisSettingsX.setColor(DisplayUtils.getDisplay().getSystemColor(2));
        primaryAxisSettingsX.setVisible(xAxisVisible);
        IPrimaryAxisSettings primaryAxisSettingsY = chartSettings.getPrimaryAxisSettingsY();
        primaryAxisSettingsY.setTitle(yAxisTitle);
        primaryAxisSettingsY.setDecimalFormat(new DecimalFormat("0.0#E0", new DecimalFormatSymbols(Locale.ENGLISH)));
        primaryAxisSettingsY.setColor(DisplayUtils.getDisplay().getSystemColor(2));
    }

    public static void clearSecondaryAxes(IChartSettings chartSettings) {
        chartSettings.getSecondaryAxisSettingsListX().clear();
        chartSettings.getSecondaryAxisSettingsListY().clear();
    }

    public static void addSecondaryAxisX(IChartSettings chartSettings, String xAxisTitle) {
        SecondaryAxisSettings secondaryAxisSettingsX = new SecondaryAxisSettings(xAxisTitle, (IAxisScaleConverter)new MillisecondsToMinuteConverter());
        secondaryAxisSettingsX.setPosition(IAxis.Position.Primary);
        secondaryAxisSettingsX.setDecimalFormat(new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.ENGLISH)));
        secondaryAxisSettingsX.setColor(DisplayUtils.getDisplay().getSystemColor(2));
        chartSettings.getSecondaryAxisSettingsListX().add(secondaryAxisSettingsX);
    }

    public static void addSecondaryAxisY(IChartSettings chartSettings, String yAxisTitle) {
        SecondaryAxisSettings secondaryAxisSettingsY = new SecondaryAxisSettings(yAxisTitle, (IAxisScaleConverter)new PercentageConverter(512, true));
        secondaryAxisSettingsY.setPosition(IAxis.Position.Secondary);
        secondaryAxisSettingsY.setDecimalFormat(new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.ENGLISH)));
        secondaryAxisSettingsY.setColor(DisplayUtils.getDisplay().getSystemColor(2));
        chartSettings.getSecondaryAxisSettingsListY().add(secondaryAxisSettingsY);
    }
}

