/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.support;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public enum DisplayType {
    TIC("TIC", "Total Intensity Chromatogram"),
    BPC("BPC", "Base Peak Chromatogram"),
    XIC("XIC", "Extracted Ion Chromatogram"),
    SIC("SIC", "Selected Ion Chromatogram"),
    XWC("XWC", "Extracted Wavelength Chromatogram"),
    SWC("SWC", "Selected Wavelength Chromatogram"),
    TSC("TSC", "Total Subtracted Chromatogram"),
    SRM("SRM", "Single Reaction Monitoring"),
    MRM("MRM", "Multiple Reaction Monitoring");

    private static Map<String, DisplayType> shortcutMap;
    private String shortucut;
    private String description;

    static {
        shortcutMap = new HashMap<String, DisplayType>();
        DisplayType[] displayTypeArray = DisplayType.values();
        int n = displayTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayType displayType = displayTypeArray[n2];
            shortcutMap.put(displayType.shortucut, displayType);
            ++n2;
        }
    }

    private DisplayType(String shortcut, String description) {
        this.shortucut = shortcut;
        this.description = description;
    }

    public String getShortcut() {
        return this.shortucut;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.description;
    }

    public static String toDescription(Collection<DisplayType> types) {
        return DisplayType.toDescription(types.toArray(new DisplayType[types.size()]));
    }

    public static String toDescription(DisplayType ... types) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < types.length) {
            sb.append(types[i].toString());
            if (i + 1 < types.length) {
                sb.append("+");
            }
            ++i;
        }
        return sb.toString();
    }

    public static String toShortcut(Collection<DisplayType> types) {
        return DisplayType.toShortcut(types.toArray(new DisplayType[types.size()]));
    }

    public static String toShortcut(DisplayType ... types) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < types.length) {
            sb.append(types[i].getShortcut());
            if (i + 1 < types.length) {
                sb.append("+");
            }
            ++i;
        }
        return sb.toString();
    }

    public static Set<DisplayType> toDisplayTypes(String shortcut) {
        return Arrays.stream(shortcut.split("\\+")).map(s -> shortcutMap.get(s)).collect(Collectors.toSet());
    }
}

